/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ErrorVisitor;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.Set;
import soot.SootMethod;

public class ForbiddenMethodError
extends AbstractError {
    private Collection<SootMethod> alternatives;
    private SootMethod calledMethod;
    private Set<String> alternativesSet = Sets.newHashSet();

    public ForbiddenMethodError(Statement errorLocation, CrySLRule rule, SootMethod calledMethod, Collection<SootMethod> collection) {
        super(errorLocation, rule);
        this.calledMethod = calledMethod;
        this.alternatives = collection;
        for (SootMethod method : this.alternatives) {
            this.alternativesSet.add(method.getSignature());
        }
    }

    public Collection<SootMethod> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public void accept(ErrorVisitor visitor) {
        visitor.visit(this);
    }

    public SootMethod getCalledMethod() {
        return this.calledMethod;
    }

    @Override
    public String toErrorMarkerString() {
        StringBuilder msg = new StringBuilder();
        msg.append("Detected call to forbidden method ");
        msg.append(this.getCalledMethod().getSubSignature());
        msg.append(" of class " + this.getCalledMethod().getDeclaringClass());
        if (!this.getAlternatives().isEmpty()) {
            msg.append(". Instead, call method ");
            Collection<SootMethod> subSignatures = this.getAlternatives();
            msg.append(Joiner.on(", ").join(subSignatures));
            msg.append(".");
        }
        return msg.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alternativesSet == null ? 0 : this.alternativesSet.hashCode());
        result = 31 * result + (this.calledMethod == null ? 0 : this.calledMethod.getSignature().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForbiddenMethodError other = (ForbiddenMethodError)obj;
        if (this.alternativesSet == null ? other.alternativesSet != null : !this.alternativesSet.equals(other.alternativesSet)) {
            return false;
        }
        return !(this.calledMethod == null ? other.calledMethod != null : !this.calledMethod.getSignature().equals(other.calledMethod.getSignature()));
    }
}

