/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis.errors;

import boomerang.jimple.Statement;
import crypto.analysis.errors.IError;
import crypto.rules.CrySLRule;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JReturnVoidStmt;

public abstract class AbstractError
implements IError {
    private Statement errorLocation;
    private CrySLRule rule;
    private final String outerMethod;
    private final String invokeMethod;
    private final String declaringClass;

    public AbstractError(Statement errorLocation, CrySLRule rule) {
        this.errorLocation = errorLocation;
        this.rule = rule;
        this.outerMethod = errorLocation.getMethod().getSignature();
        this.declaringClass = errorLocation.getMethod().getDeclaringClass().toString();
        this.invokeMethod = errorLocation.getUnit().get().containsInvokeExpr() ? errorLocation.getUnit().get().getInvokeExpr().getMethod().toString() : (errorLocation.getUnit().get() instanceof JReturnStmt || errorLocation.getUnit().get() instanceof JReturnVoidStmt ? errorLocation.getUnit().get().toString() : ((JAssignStmt)errorLocation.getUnit().get()).getLeftOp().toString());
    }

    public Statement getErrorLocation() {
        return this.errorLocation;
    }

    public CrySLRule getRule() {
        return this.rule;
    }

    public abstract String toErrorMarkerString();

    public String toString() {
        return this.toErrorMarkerString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.invokeMethod == null ? 0 : this.invokeMethod.hashCode());
        result = 31 * result + (this.outerMethod == null ? 0 : this.outerMethod.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractError other = (AbstractError)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.invokeMethod == null ? other.invokeMethod != null : !this.invokeMethod.equals(other.invokeMethod)) {
            return false;
        }
        if (this.outerMethod == null ? other.outerMethod != null : !this.outerMethod.equals(other.outerMethod)) {
            return false;
        }
        if (this.rule == null) {
            if (other.rule != null) {
                return false;
            }
        } else {
            if (!this.rule.equals(other.rule)) {
                return false;
            }
            if (!this.errorLocation.equals(other.getErrorLocation())) {
                return false;
            }
        }
        return true;
    }
}

