/*
 * Decompiled with CFR 0.152.
 */
package crypto.analysis;

import boomerang.WeightedForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.CryptoScanner;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.rules.CrySLForbiddenMethod;
import crypto.rules.CrySLRule;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.ExtendedIDEALAnaylsis;
import crypto.typestate.SootBasedStateMachineGraph;
import ideal.IDEALSeedSolver;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import typestate.TransitionFunction;

public class ClassSpecification {
    private ExtendedIDEALAnaylsis extendedIdealAnalysis;
    private CrySLRule crySLRule;
    private final CryptoScanner cryptoScanner;
    private final SootBasedStateMachineGraph fsm;

    public ClassSpecification(CrySLRule rule, CryptoScanner cScanner) {
        this.crySLRule = rule;
        this.cryptoScanner = cScanner;
        this.fsm = new SootBasedStateMachineGraph(rule.getUsagePattern());
        this.extendedIdealAnalysis = new ExtendedIDEALAnaylsis(){

            @Override
            public SootBasedStateMachineGraph getStateMachine() {
                return ClassSpecification.this.fsm;
            }

            @Override
            public CrySLResultsReporter analysisListener() {
                return ClassSpecification.this.cryptoScanner.getAnalysisListener();
            }

            @Override
            public ObservableICFG<Unit, SootMethod> icfg() {
                return ClassSpecification.this.cryptoScanner.icfg();
            }

            @Override
            protected Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver) {
                return ClassSpecification.this.cryptoScanner.debugger(solver, null);
            }
        };
    }

    public boolean isLeafRule() {
        return this.crySLRule.isLeafRule();
    }

    public Collection<WeightedForwardQuery<TransitionFunction>> getInitialSeeds(SootMethod m4) {
        return this.extendedIdealAnalysis.computeSeeds(m4);
    }

    public String toString() {
        return this.crySLRule.getClassName().toString();
    }

    public void invokesForbiddenMethod(SootMethod m4) {
        if (!m4.hasActiveBody()) {
            return;
        }
        for (Unit u : m4.getActiveBody().getUnits()) {
            InvokeExpr invokeExpr;
            SootMethod method;
            Optional<CrySLForbiddenMethod> forbiddenMethod;
            Stmt stmt;
            if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !(forbiddenMethod = this.isForbiddenMethod(method = (invokeExpr = stmt.getInvokeExpr()).getMethod())).isPresent()) continue;
            this.cryptoScanner.getAnalysisListener().reportError(null, new ForbiddenMethodError(new Statement((Stmt)u, this.cryptoScanner.icfg().getMethodOf(u)), this.getRule(), method, CrySLMethodToSootMethod.v().convert(forbiddenMethod.get().getAlternatives())));
        }
    }

    private Optional<CrySLForbiddenMethod> isForbiddenMethod(SootMethod method) {
        List<CrySLForbiddenMethod> forbiddenMethods = this.crySLRule.getForbiddenMethods();
        for (CrySLForbiddenMethod m4 : forbiddenMethods) {
            Collection<SootMethod> matchingMethod;
            if (m4.getSilent().booleanValue() || !(matchingMethod = CrySLMethodToSootMethod.v().convert(m4.getMethod())).contains(method)) continue;
            return Optional.of(m4);
        }
        return Optional.empty();
    }

    public CrySLRule getRule() {
        return this.crySLRule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.crySLRule == null ? 0 : this.crySLRule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassSpecification other = (ClassSpecification)obj;
        return !(this.crySLRule == null ? other.crySLRule != null : !this.crySLRule.equals(other.crySLRule));
    }

    public Collection<SootMethod> getInvolvedMethods() {
        return this.fsm.getInvolvedMethods();
    }

    public SootBasedStateMachineGraph getFSM() {
        return this.fsm;
    }
}

