/*
 * Decompiled with CFR 0.152.
 */
package boomerang.stats;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAUpdateListener;

public class SimpleBoomerangStats<W extends Weight>
implements IBoomerangStats<W> {
    private Map<Query, AbstractBoomerangSolver<W>> queries = Maps.newHashMap();
    private Set<SootMethod> callVisitedMethods = Sets.newHashSet();
    private Set<SootMethod> fieldVisitedMethods = Sets.newHashSet();

    @Override
    public void registerSolver(Query key, AbstractBoomerangSolver<W> solver) {
        if (this.queries.containsKey(key)) {
            return;
        }
        this.queries.put(key, solver);
        solver.getCallAutomaton().registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

            @Override
            public void onWeightAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                SimpleBoomerangStats.this.callVisitedMethods.add(((Statement)t2.getLabel()).getMethod());
            }
        });
        solver.getFieldAutomaton().registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                SimpleBoomerangStats.this.fieldVisitedMethods.add(((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).getMethod());
            }
        });
    }

    @Override
    public void registerFieldWritePOI(WeightedBoomerang.FieldWritePOI key) {
    }

    @Override
    public void registerFieldReadPOI(WeightedBoomerang.FieldReadPOI key) {
    }

    public String toString() {
        String s2 = "=========== Boomerang Stats =============\n";
        int forwardQuery = 0;
        int backwardQuery = 0;
        for (Query q : this.queries.keySet()) {
            if (q instanceof ForwardQuery) {
                ++forwardQuery;
                continue;
            }
            ++backwardQuery;
        }
        s2 = s2 + String.format("Queries (Forward/Backward/Total): \t\t %s/%s/%s\n", forwardQuery, backwardQuery, this.queries.keySet().size());
        s2 = s2 + String.format("Visited Methods (Field/Call): \t\t %s/%s/(%s/%s)\n", this.fieldVisitedMethods.size(), this.callVisitedMethods.size(), Sets.difference(this.fieldVisitedMethods, this.callVisitedMethods).size(), Sets.difference(this.callVisitedMethods, this.fieldVisitedMethods).size());
        s2 = s2 + "\n";
        return s2;
    }

    @Override
    public Collection<? extends Node<Statement, Val>> getForwardReachesNodes() {
        HashSet res = Sets.newHashSet();
        for (Query q : this.queries.keySet()) {
            if (!(q instanceof ForwardQuery)) continue;
            res.addAll(this.queries.get(q).getReachedStates());
        }
        return res;
    }

    @Override
    public Set<SootMethod> getCallVisitedMethods() {
        return Sets.newHashSet(this.callVisitedMethods);
    }

    @Override
    public void terminated(ForwardQuery query, ForwardBoomerangResults<W> forwardBoomerangResults) {
    }

    @Override
    public void terminated(BackwardQuery query, BackwardBoomerangResults<W> backwardBoomerangResults) {
    }
}

