/*
 * Decompiled with CFR 0.152.
 */
package boomerang.stats;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.Util;
import boomerang.WeightedBoomerang;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import soot.SootMethod;
import sync.pds.solver.SyncPDSUpdateListener;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAUpdateListener;
import wpds.interfaces.WPDSUpdateListener;

public class CSVBoomerangStatsWriter<W extends Weight>
implements IBoomerangStats<W> {
    private Map<Query, AbstractBoomerangSolver<W>> queries = Maps.newHashMap();
    private Set<WeightedTransition<Field, INode<Node<Statement, Val>>, W>> globalFieldTransitions = Sets.newHashSet();
    private int fieldTransitionCollisions;
    private Set<WeightedTransition<Statement, INode<Val>, W>> globalCallTransitions = Sets.newHashSet();
    private int callTransitionCollisions;
    private Set<Rule<Field, INode<Node<Statement, Val>>, W>> globalFieldRules = Sets.newHashSet();
    private int fieldRulesCollisions;
    private Set<Rule<Statement, INode<Val>, W>> globalCallRules = Sets.newHashSet();
    private int callRulesCollisions;
    private Set<Node<Statement, Val>> reachedForwardNodes = Sets.newHashSet();
    private int reachedForwardNodeCollisions;
    private Set<Node<Statement, Val>> reachedBackwardNodes = Sets.newHashSet();
    private int reachedBackwardNodeCollisions;
    private Set<SootMethod> callVisitedMethods = Sets.newHashSet();
    private Set<SootMethod> fieldVisitedMethods = Sets.newHashSet();
    private Set<Statement> callVisitedStmts = Sets.newHashSet();
    private Set<Statement> fieldVisitedStmts = Sets.newHashSet();
    private Set<INode<Node<Statement, Val>>> fieldGeneratedStates = Sets.newHashSet();
    private Set<INode<Val>> callGeneratedStates = Sets.newHashSet();
    private int arrayFlows;
    private int staticFlows;
    private int fieldWritePOIs;
    private int fieldReadPOIs;
    private String outputFileName;
    private static final String CSV_SEPARATOR = ";";
    private List<String> headers = Lists.newArrayList();
    private Map<String, String> headersToValues = Maps.newHashMap();
    private long memoryBefore;

    public CSVBoomerangStatsWriter(String outputFileName) {
        this.outputFileName = outputFileName;
        for (Headers h2 : Headers.values()) {
            this.headers.add(h2.toString());
        }
        this.memoryBefore = Util.getReallyUsedMemory();
    }

    public static <K> Map<K, Integer> sortByValues(final Map<K, Integer> map) {
        Comparator valueComparator = new Comparator<K>(){

            @Override
            public int compare(K k1, K k2) {
                if ((Integer)map.get(k2) > (Integer)map.get(k1)) {
                    return 1;
                }
                return -1;
            }
        };
        TreeMap<K, Integer> sortedByValues = new TreeMap<K, Integer>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    @Override
    public void registerSolver(Query key, final AbstractBoomerangSolver<W> solver) {
        if (this.queries.containsKey(key)) {
            return;
        }
        this.queries.put(key, solver);
        solver.getFieldAutomaton().registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (!CSVBoomerangStatsWriter.this.globalFieldTransitions.add(new WeightedTransition(t2, w))) {
                    CSVBoomerangStatsWriter.this.fieldTransitionCollisions++;
                }
                CSVBoomerangStatsWriter.this.fieldVisitedMethods.add(((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).getMethod());
                CSVBoomerangStatsWriter.this.fieldVisitedStmts.add(((Node)((INode)t2.getStart()).fact()).stmt());
                if (((Field)t2.getLabel()).equals(Field.array())) {
                    CSVBoomerangStatsWriter.this.arrayFlows++;
                }
                CSVBoomerangStatsWriter.this.addFieldGeneratedState((INode)t2.getStart());
                CSVBoomerangStatsWriter.this.addFieldGeneratedState((INode)t2.getTarget());
            }
        });
        solver.getCallAutomaton().registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

            @Override
            public void onWeightAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                if (!CSVBoomerangStatsWriter.this.globalCallTransitions.add(new WeightedTransition(t2, w))) {
                    CSVBoomerangStatsWriter.this.callTransitionCollisions++;
                }
                CSVBoomerangStatsWriter.this.callVisitedMethods.add(((Statement)t2.getLabel()).getMethod());
                CSVBoomerangStatsWriter.this.fieldVisitedStmts.add(t2.getLabel());
                if (((Val)((INode)t2.getStart()).fact()).isStatic()) {
                    CSVBoomerangStatsWriter.this.staticFlows++;
                }
                CSVBoomerangStatsWriter.this.addCallGeneratedState((INode)t2.getStart());
                CSVBoomerangStatsWriter.this.addCallGeneratedState((INode)t2.getTarget());
            }
        });
        solver.getFieldPDS().registerUpdateListener(new WPDSUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onRuleAdded(Rule<Field, INode<Node<Statement, Val>>, W> rule) {
                if (!CSVBoomerangStatsWriter.this.globalFieldRules.add(rule)) {
                    CSVBoomerangStatsWriter.this.fieldRulesCollisions++;
                }
            }
        });
        solver.getCallPDS().registerUpdateListener(new WPDSUpdateListener<Statement, INode<Val>, W>(){

            @Override
            public void onRuleAdded(Rule<Statement, INode<Val>, W> rule) {
                if (!CSVBoomerangStatsWriter.this.globalCallRules.add(rule)) {
                    CSVBoomerangStatsWriter.this.callRulesCollisions++;
                }
            }
        });
        solver.registerListener(new SyncPDSUpdateListener<Statement, Val>(){

            @Override
            public void onReachableNodeAdded(Node<Statement, Val> reachableNode) {
                if (solver instanceof ForwardBoomerangSolver) {
                    if (!CSVBoomerangStatsWriter.this.reachedForwardNodes.add(reachableNode)) {
                        CSVBoomerangStatsWriter.this.reachedForwardNodeCollisions++;
                    }
                } else if (!CSVBoomerangStatsWriter.this.reachedBackwardNodes.add(reachableNode)) {
                    CSVBoomerangStatsWriter.this.reachedBackwardNodeCollisions++;
                }
            }
        });
    }

    protected void addFieldGeneratedState(INode<Node<Statement, Val>> s2) {
        if (s2 instanceof GeneratedState) {
            this.fieldGeneratedStates.add(s2);
        }
    }

    protected void addCallGeneratedState(INode<Val> s2) {
        if (s2 instanceof GeneratedState) {
            this.callGeneratedStates.add(s2);
        }
    }

    @Override
    public void registerFieldWritePOI(WeightedBoomerang.FieldWritePOI key) {
        ++this.fieldWritePOIs;
    }

    @Override
    public void registerFieldReadPOI(WeightedBoomerang.FieldReadPOI key) {
        ++this.fieldReadPOIs;
    }

    public String toString() {
        String s2 = "=========== Boomerang Stats =============\n";
        int forwardQuery = 0;
        int backwardQuery = 0;
        for (Query q : this.queries.keySet()) {
            if (q instanceof ForwardQuery) {
                ++forwardQuery;
                continue;
            }
            ++backwardQuery;
        }
        s2 = s2 + String.format("Queries (Forward/Backward/Total): \t\t %s/%s/%s\n", forwardQuery, backwardQuery, this.queries.keySet().size());
        s2 = s2 + String.format("Visited Methods (Field/Call): \t\t %s/%s\n", this.fieldVisitedMethods.size(), this.callVisitedMethods.size());
        s2 = s2 + String.format("Reached Forward Nodes(Collisions): \t\t %s (%s)\n", this.reachedForwardNodes.size(), this.reachedForwardNodeCollisions);
        s2 = s2 + String.format("Reached Backward Nodes(Collisions): \t\t %s (%s)\n", this.reachedBackwardNodes.size(), this.reachedBackwardNodeCollisions);
        s2 = s2 + String.format("Global Field Rules(Collisions): \t\t %s (%s)\n", this.globalFieldRules.size(), this.fieldRulesCollisions);
        s2 = s2 + String.format("Global Field Transitions(Collisions): \t\t %s (%s)\n", this.globalFieldTransitions.size(), this.fieldTransitionCollisions);
        s2 = s2 + String.format("Global Call Rules(Collisions): \t\t %s (%s)\n", this.globalCallRules.size(), this.callRulesCollisions);
        s2 = s2 + String.format("Global Call Transitions(Collisions): \t\t %s (%s)\n", this.globalCallTransitions.size(), this.callTransitionCollisions);
        s2 = s2 + String.format("Special Flows (Static/Array): \t\t %s(%s)/%s(%s)\n", this.staticFlows, this.globalCallTransitions.size(), this.arrayFlows, this.globalFieldTransitions.size());
        s2 = s2 + this.computeMetrics();
        s2 = s2 + "\n";
        return s2;
    }

    @Override
    public Set<SootMethod> getCallVisitedMethods() {
        return Sets.newHashSet(this.callVisitedMethods);
    }

    private String computeMetrics() {
        int min2 = Integer.MAX_VALUE;
        int totalReached = 0;
        int max = 0;
        Query maxQuery = null;
        for (Query q : this.queries.keySet()) {
            int size = this.queries.get(q).getReachedStates().size();
            totalReached += size;
            min2 = Math.min(size, min2);
            if (size > max) {
                maxQuery = q;
            }
            max = Math.max(size, max);
        }
        float average = (float)totalReached / (float)this.queries.keySet().size();
        String s2 = String.format("Reachable nodes (Min/Avg/Max): \t\t%s/%s/%s\n", min2, Float.valueOf(average), max);
        s2 = s2 + String.format("Maximal Query: \t\t%s\n", maxQuery);
        return s2;
    }

    @Override
    public Collection<? extends Node<Statement, Val>> getForwardReachesNodes() {
        HashSet res = Sets.newHashSet();
        for (Query q : this.queries.keySet()) {
            if (!(q instanceof ForwardQuery)) continue;
            res.addAll(this.queries.get(q).getReachedStates());
        }
        return res;
    }

    @Override
    public void terminated(ForwardQuery query, ForwardBoomerangResults<W> res) {
        this.writeToFile(query, res.getAnalysisWatch().elapsed(TimeUnit.MILLISECONDS), res.isTimedout());
    }

    @Override
    public void terminated(BackwardQuery query, BackwardBoomerangResults<W> res) {
        this.writeToFile(query, res.getAnalysisWatch().elapsed(TimeUnit.MILLISECONDS), res.isTimedout());
    }

    private void writeToFile(Query query, long queryTime, boolean timeout) {
        long memoryAfter = Util.getReallyUsedMemory();
        this.put(Headers.Query, (Object)query.toString());
        this.put(Headers.QueryType, (Object)(query instanceof BackwardQuery ? "B" : "F"));
        this.put(Headers.QueryTime, (Object)queryTime);
        this.put(Headers.Timeout, (Object)(timeout ? "1" : "0"));
        this.put(Headers.ArrayFlows, (Object)this.arrayFlows);
        this.put(Headers.CallRules, (Object)this.globalCallRules.size());
        this.put(Headers.FieldRules, (Object)this.globalFieldRules.size());
        this.put(Headers.CallTransitions, (Object)this.globalCallTransitions.size());
        this.put(Headers.FieldTransitions, (Object)this.globalFieldTransitions.size());
        this.put(Headers.FieldReadPOIs, (Object)this.fieldReadPOIs);
        this.put(Headers.FieldWritePOIs, (Object)this.fieldWritePOIs);
        this.put(Headers.FieldVisitedMethods, (Object)this.fieldVisitedMethods.size());
        this.put(Headers.CallVisitedMethods, (Object)this.callVisitedMethods.size());
        this.put(Headers.FieldVisitedStmts, (Object)this.fieldVisitedStmts.size());
        this.put(Headers.CallVisitedStmts, (Object)this.callVisitedStmts.size());
        this.put(Headers.ReachedForwardNodes, (Object)this.reachedForwardNodes.size());
        this.put(Headers.ReachedBackwardNodes, (Object)this.reachedBackwardNodes.size());
        this.put(Headers.StaticFlows, (Object)this.staticFlows);
        this.put(Headers.ICFGEdges, (Object)Util.getICFGEdges());
        this.put(Headers.CallGeneratedStates, (Object)this.callGeneratedStates.size());
        this.put(Headers.FieldGeneratedStates, (Object)this.fieldGeneratedStates.size());
        this.put(Headers.CallLongestCallStack, (Object)this.queries.get(query).getCallAutomaton().getLongestPath().size());
        this.put(Headers.FieldLongestAccessPath, (Object)this.queries.get(query).getFieldAutomaton().getLongestPath().size());
        this.put(Headers.CallContainsLoop, (Object)this.queries.get(query).getCallAutomaton().containsLoop());
        this.put(Headers.FieldContainsLoop, (Object)this.queries.get(query).getFieldAutomaton().containsLoop());
        this.put(Headers.MemoryAfter, (Object)memoryAfter);
        this.put(Headers.MemoryBefore, (Object)this.memoryBefore);
        this.put(Headers.MemoryDiff, (Object)(memoryAfter - this.memoryBefore));
        try {
            File reportFile = new File(this.outputFileName).getAbsoluteFile();
            if (!reportFile.getParentFile().exists()) {
                try {
                    Files.createDirectories(reportFile.getParentFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Was not able to create directories for IDEViz output!");
                }
            }
            boolean fileExisted = reportFile.exists();
            FileWriter writer = new FileWriter(reportFile, true);
            if (!fileExisted) {
                writer.write(Joiner.on(CSV_SEPARATOR).join(this.headers) + "\n");
            }
            ArrayList<String> line = Lists.newArrayList();
            for (String h2 : this.headers) {
                String string = this.headersToValues.get(h2);
                if (string == null) {
                    string = "";
                }
                line.add(string);
            }
            writer.write(Joiner.on(CSV_SEPARATOR).join(line) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void put(String key, Object val) {
        if (!this.headers.contains(key)) {
            System.err.println("Did not create a header to this value " + key);
        } else {
            this.headersToValues.put(key, val.toString());
        }
    }

    private void put(Headers key, Object val) {
        this.put(key.toString(), val);
    }

    private static class WeightedTransition<X extends Location, Y extends State, W> {
        final Transition<X, Y> t;
        final W w;

        public WeightedTransition(Transition<X, Y> t2, W w) {
            this.t = t2;
            this.w = w;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightedTransition other = (WeightedTransition)obj;
            if (this.t == null ? other.t != null : !this.t.equals(other.t)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }

    private static enum Headers {
        Query,
        QueryType,
        FieldTransitions,
        CallTransitions,
        CallRules,
        FieldRules,
        ReachedForwardNodes,
        ReachedBackwardNodes,
        CallVisitedMethods,
        FieldVisitedMethods,
        CallVisitedStmts,
        FieldVisitedStmts,
        FieldWritePOIs,
        FieldReadPOIs,
        StaticFlows,
        ArrayFlows,
        QueryTime,
        Timeout,
        ICFGEdges,
        CallGeneratedStates,
        FieldGeneratedStates,
        FieldLongestAccessPath,
        CallLongestCallStack,
        CallContainsLoop,
        FieldContainsLoop,
        MemoryBefore,
        MemoryAfter,
        MemoryDiff;

    }
}

