/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BoomerangOptions;
import boomerang.Query;
import boomerang.Util;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.MethodBasedFieldTransitionListener;
import boomerang.solver.ReachableMethodListener;
import boomerang.solver.StatementBasedCallTransitionListener;
import boomerang.solver.StatementBasedFieldTransitionListener;
import boomerang.util.RegExAccessPath;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pathexpression.IRegEx;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.impl.WeightedPushdownSystem;
import wpds.interfaces.State;
import wpds.interfaces.WPAUpdateListener;

public abstract class AbstractBoomerangSolver<W extends Weight>
extends SyncPDSSolver<Statement, Val, Field, W> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBoomerangSolver.class);
    protected final ObservableICFG<Unit, SootMethod> icfg;
    protected final Query query;
    protected boolean INTERPROCEDURAL = true;
    protected final Map<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>> generatedFieldState;
    private Multimap<SootMethod, Transition<Field, INode<Node<Statement, Val>>>> perMethodFieldTransitions = HashMultimap.create();
    private Multimap<SootMethod, MethodBasedFieldTransitionListener<W>> perMethodFieldTransitionsListener = HashMultimap.create();
    private Multimap<Statement, Transition<Field, INode<Node<Statement, Val>>>> perStatementFieldTransitions = HashMultimap.create();
    private Multimap<Statement, StatementBasedFieldTransitionListener<W>> perStatementFieldTransitionsListener = HashMultimap.create();
    private HashBasedTable<Statement, Transition<Statement, INode<Val>>, W> perStatementCallTransitions = HashBasedTable.create();
    private Multimap<Statement, StatementBasedCallTransitionListener<W>> perStatementCallTransitionsListener = HashMultimap.create();
    private Set<ReachableMethodListener<W>> reachableMethodListeners = Sets.newHashSet();
    private Multimap<SootMethod, Runnable> queuedReachableMethod = HashMultimap.create();
    private Collection<SootMethod> reachableMethods = Sets.newHashSet();
    protected final BoomerangOptions options;

    public AbstractBoomerangSolver(ObservableICFG<Unit, SootMethod> icfg, Query query, Map<Map.Entry<INode<Node<Statement, Val>>, Field>, INode<Node<Statement, Val>>> genField, BoomerangOptions options, NestedWeightedPAutomatons<Statement, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<Statement, Val>>, W> fieldSummaries) {
        super(new SingleNode<Val>(query.asNode().fact()), new SingleNode(query.asNode()), options.callSummaries(), callSummaries, options.fieldSummaries(), fieldSummaries);
        this.options = options;
        this.icfg = icfg;
        this.query = query;
        this.fieldAutomaton.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                AbstractBoomerangSolver.this.addTransitionToMethod(((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).getMethod(), t2);
                AbstractBoomerangSolver.this.addTransitionToMethod(((Statement)((Node)((INode)t2.getTarget()).fact()).stmt()).getMethod(), t2);
                AbstractBoomerangSolver.this.addTransitionToStatement((Statement)((Node)((INode)t2.getStart()).fact()).stmt(), t2);
            }
        });
        this.callAutomaton.registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

            @Override
            public void onWeightAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                AbstractBoomerangSolver.this.addCallTransitionToStatement((Statement)t2.getLabel(), t2, w);
            }
        });
        this.generatedFieldState = genField;
        this.addReachable(query.asNode().stmt().getMethod());
    }

    @Override
    protected boolean preventCallTransitionAdd(Transition<Statement, INode<Val>> t2, W weight) {
        if (t2.getString().getUnit().isPresent() && !this.icfg.isReachable(t2.getString().getUnit().get())) {
            return true;
        }
        if (t2.getStart() instanceof GeneratedState) {
            return false;
        }
        Val fact = (Val)((INode)t2.getStart()).fact();
        if (fact.isStatic()) {
            return false;
        }
        if (this.callAutomaton.isUnbalancedState(t2.getStart()) && this.callAutomaton.isUnbalancedState(t2.getTarget())) {
            return false;
        }
        SootMethod m4 = fact.m();
        SootMethod method = ((Statement)t2.getLabel()).getMethod();
        if (m4 == null || method == null) {
            return false;
        }
        return !m4.equals(method);
    }

    @Override
    public void addCallRule(final Rule<Statement, INode<Val>, W> rule) {
        if (rule instanceof NormalRule && rule.getL1().equals(rule.getL2()) && rule.getS1().equals(rule.getS2())) {
            return;
        }
        if (rule instanceof PopRule) {
            super.addCallRule(rule);
        } else {
            this.submit(rule.getS2().fact().m(), new Runnable(){

                @Override
                public void run() {
                    AbstractBoomerangSolver.super.addCallRule(rule);
                }
            });
        }
    }

    @Override
    public void addFieldRule(final Rule<Field, INode<Node<Statement, Val>>, W> rule) {
        if (rule instanceof NormalRule && rule.getL1().equals(rule.getL2()) && rule.getS1().equals(rule.getS2())) {
            return;
        }
        this.submit(rule.getS2().fact().stmt().getMethod(), new Runnable(){

            @Override
            public void run() {
                AbstractBoomerangSolver.super.addFieldRule(rule);
            }
        });
    }

    private void addTransitionToMethod(SootMethod method, Transition<Field, INode<Node<Statement, Val>>> t2) {
        if (this.perMethodFieldTransitions.put(method, t2)) {
            for (MethodBasedFieldTransitionListener<W> l : Lists.newArrayList(this.perMethodFieldTransitionsListener.get(method))) {
                l.onAddedTransition(t2);
            }
        }
    }

    public void registerFieldTransitionListener(MethodBasedFieldTransitionListener<W> l) {
        if (this.perMethodFieldTransitionsListener.put(l.getMethod(), l)) {
            for (Transition<Field, INode<Node<Statement, Val>>> t2 : Lists.newArrayList(this.perMethodFieldTransitions.get(l.getMethod()))) {
                l.onAddedTransition(t2);
            }
        }
    }

    private void addTransitionToStatement(Statement s2, Transition<Field, INode<Node<Statement, Val>>> t2) {
        if (this.perStatementFieldTransitions.put(s2, t2)) {
            for (StatementBasedFieldTransitionListener<W> l : Lists.newArrayList(this.perStatementFieldTransitionsListener.get(s2))) {
                l.onAddedTransition(t2);
            }
        }
    }

    public void registerStatementFieldTransitionListener(StatementBasedFieldTransitionListener<W> l) {
        if (this.perStatementFieldTransitionsListener.put(l.getStmt(), l)) {
            for (Transition<Field, INode<Node<Statement, Val>>> t2 : Lists.newArrayList(this.perStatementFieldTransitions.get(l.getStmt()))) {
                l.onAddedTransition(t2);
            }
        }
    }

    private void addCallTransitionToStatement(Statement s2, Transition<Statement, INode<Val>> t2, W w) {
        block3: {
            block2: {
                Weight put = (Weight)this.perStatementCallTransitions.get(s2, t2);
                if (put == null) break block2;
                Weight combineWith = put.combineWith((Weight)w);
                if (combineWith.equals(put)) break block3;
                this.perStatementCallTransitions.put((Object)s2, t2, combineWith);
                for (StatementBasedCallTransitionListener<W> l : Lists.newArrayList(this.perStatementCallTransitionsListener.get(s2))) {
                    l.onAddedTransition(t2, w);
                }
                break block3;
            }
            this.perStatementCallTransitions.put((Object)s2, t2, w);
            for (StatementBasedCallTransitionListener<W> l : Lists.newArrayList(this.perStatementCallTransitionsListener.get(s2))) {
                l.onAddedTransition(t2, w);
            }
        }
    }

    public void registerStatementCallTransitionListener(StatementBasedCallTransitionListener<W> l) {
        if (this.perStatementCallTransitionsListener.put(l.getStmt(), l)) {
            Map row = this.perStatementCallTransitions.row((Object)l.getStmt());
            for (Map.Entry t2 : Lists.newArrayList(row.entrySet())) {
                l.onAddedTransition((Transition)t2.getKey(), (Weight)t2.getValue());
            }
        }
    }

    @Override
    public INode<Node<Statement, Val>> generateFieldState(INode<Node<Statement, Val>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Statement, Val>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState<Node<Statement, Val>, Field>(d, loc));
        }
        return this.generatedFieldState.get(e);
    }

    protected boolean isIdentityFlow(Val value, Stmt succ, SootMethod method, Collection<State> out) {
        if (out.size() != 1 || succ.containsInvokeExpr() || this.icfg.isExitStmt(succ)) {
            return false;
        }
        if (value.isStatic() ? this.containsStaticFieldAccess(succ) : succ.containsFieldRef()) {
            return false;
        }
        ArrayList<State> l = Lists.newArrayList(out);
        State state = (State)l.get(0);
        return state.equals(new Node<Statement, Val>(new Statement(succ, method), value));
    }

    private boolean containsStaticFieldAccess(Stmt succ) {
        if (succ instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)succ;
            return assignStmt.getLeftOp() instanceof StaticFieldRef || assignStmt.getRightOp() instanceof StaticFieldRef;
        }
        return false;
    }

    protected Field getWrittenField(Stmt curr) {
        AssignStmt as = (AssignStmt)curr;
        if (as.getLeftOp() instanceof StaticFieldRef) {
            StaticFieldRef staticFieldRef = (StaticFieldRef)as.getLeftOp();
            return new Field(staticFieldRef.getField());
        }
        InstanceFieldRef ifr = (InstanceFieldRef)as.getLeftOp();
        return new Field(ifr.getField());
    }

    protected boolean isFieldWriteWithBase(Stmt curr, Val base) {
        AssignStmt as;
        if (curr instanceof AssignStmt && (as = (AssignStmt)curr).getLeftOp() instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)as.getLeftOp();
            return ifr.getBase().equals(base.value());
        }
        return false;
    }

    protected Field getLoadedField(Stmt curr) {
        AssignStmt as = (AssignStmt)curr;
        InstanceFieldRef ifr = (InstanceFieldRef)as.getRightOp();
        return new Field(ifr.getField());
    }

    protected boolean isFieldLoadWithBase(Stmt curr, Val base) {
        AssignStmt as;
        if (curr instanceof AssignStmt && (as = (AssignStmt)curr).getRightOp() instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)as.getRightOp();
            return ifr.getBase().equals(base.value());
        }
        return false;
    }

    protected abstract boolean killFlow(SootMethod var1, Stmt var2, Val var3);

    public boolean valueUsedInStatement(Stmt u, Val value) {
        if (value.isStatic()) {
            return true;
        }
        if (AbstractBoomerangSolver.assignsValue(u, value)) {
            return true;
        }
        if (Util.isReturnOperator(value, u)) {
            return true;
        }
        return this.isParameter(value, u);
    }

    public boolean isParameter(Val value, Stmt u) {
        if (u.containsInvokeExpr()) {
            InstanceInvokeExpr iie;
            InvokeExpr invokeExpr = u.getInvokeExpr();
            if (invokeExpr instanceof InstanceInvokeExpr && (iie = (InstanceInvokeExpr)invokeExpr).getBase().equals(value.value())) {
                return true;
            }
            for (Value arg : invokeExpr.getArgs()) {
                if (!arg.equals(value.value())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean assignsValue(Stmt u, Val value) {
        AssignStmt assignStmt;
        return u instanceof AssignStmt && (assignStmt = (AssignStmt)u).getLeftOp().equals(value.value());
    }

    private boolean isBackward() {
        return this instanceof BackwardBoomerangSolver;
    }

    protected abstract Collection<? extends State> computeReturnFlow(SootMethod var1, Stmt var2, Val var3, Stmt var4, Stmt var5);

    protected void returnFlow(SootMethod method, Node<Statement, Val> currNode) {
        Val value = currNode.fact();
        Stmt curr = currNode.stmt().getUnit().get();
        if (method.isStaticInitializer() && value.isStatic()) {
            HashSet<State> out = Sets.newHashSet();
            for (SootMethod entryPoint : Scene.v().getEntryPoints()) {
                for (Unit sp : this.icfg.getStartPointsOf(entryPoint)) {
                    Collection<State> outFlow = this.computeReturnFlow(method, curr, value, (Stmt)sp, (Stmt)sp);
                    out.addAll(outFlow);
                }
            }
            for (State s2 : out) {
                this.propagate(currNode, s2);
            }
        } else if (this.icfg.isUnbalancedMethod(method)) {
            HashSet<State> out = Sets.newHashSet();
            for (Unit unit : this.icfg.getAllPrecomputedCallers(method)) {
                if (!((Stmt)unit).containsInvokeExpr()) continue;
                for (Unit returnSite : this.icfg.getSuccsOf(unit)) {
                    Collection<State> outFlow = this.computeReturnFlow(method, curr, value, (Stmt)unit, (Stmt)returnSite);
                    out.addAll(outFlow);
                }
            }
            for (State s3 : out) {
                this.propagate(currNode, s3);
            }
        } else {
            this.icfg.addCallerListener(new ReturnFlowCallerListener(curr, method, value, currNode));
        }
    }

    protected abstract Collection<? extends State> getEmptyCalleeFlow(SootMethod var1, Stmt var2, Val var3, Stmt var4);

    protected abstract Collection<State> computeNormalFlow(SootMethod var1, Stmt var2, Val var3, Stmt var4);

    @Override
    public Field epsilonField() {
        return Field.epsilon();
    }

    @Override
    public Field emptyField() {
        return Field.empty();
    }

    @Override
    public Statement epsilonStmt() {
        return Statement.epsilon();
    }

    @Override
    public Field fieldWildCard() {
        return Field.wildcard();
    }

    @Override
    public Field exclusionFieldWildCard(Field exclusion) {
        return Field.exclusionWildcard(exclusion);
    }

    public WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> getFieldAutomaton() {
        return this.fieldAutomaton;
    }

    public WeightedPAutomaton<Statement, INode<Val>, W> getCallAutomaton() {
        return this.callAutomaton;
    }

    public WeightedPushdownSystem<Statement, INode<Val>, W> getCallPDS() {
        return this.callingPDS;
    }

    public WeightedPushdownSystem<Field, INode<Node<Statement, Val>>, W> getFieldPDS() {
        return this.fieldPDS;
    }

    @Override
    protected void processNode(final Node<Statement, Val> witnessNode) {
        if (witnessNode.stmt().getUnit().isPresent() && !this.icfg.isReachable(witnessNode.stmt().getUnit().get())) {
            return;
        }
        this.submit(witnessNode.stmt().getMethod(), new Runnable(){

            @Override
            public void run() {
                AbstractBoomerangSolver.super.processNode(witnessNode);
            }
        });
    }

    public Set<Statement> getSuccsOf(Statement stmt) {
        HashSet<Statement> res = Sets.newHashSet();
        if (!stmt.getUnit().isPresent()) {
            return res;
        }
        Stmt curr = stmt.getUnit().get();
        for (Unit succ : this.icfg.getSuccsOf(curr)) {
            res.add(new Statement((Stmt)succ, this.icfg.getMethodOf(succ)));
        }
        return res;
    }

    public Set<Statement> getPredsOf(Statement stmt) {
        HashSet<Statement> res = Sets.newHashSet();
        if (!stmt.getUnit().isPresent()) {
            return res;
        }
        Stmt curr = stmt.getUnit().get();
        for (Unit succ : this.icfg.getPredsOf(curr)) {
            res.add(new Statement((Stmt)succ, this.icfg.getMethodOf(succ)));
        }
        return res;
    }

    public String toString() {
        return "Solver for: " + this.query.toString();
    }

    public Map<Transition<Statement, INode<Val>>, W> getTransitionsToFinalWeights() {
        return this.callAutomaton.getTransitionsToFinalWeights();
    }

    public int getNumberOfRules() {
        return this.callingPDS.getAllRules().size() + this.fieldPDS.getAllRules().size();
    }

    @Override
    protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<Statement, Val>>> t2, W weight) {
        Type targetVal;
        if (!((Field)t2.getLabel()).equals(Field.empty()) || !this.options.typeCheck()) {
            return false;
        }
        if (t2.getTarget() instanceof GeneratedState || t2.getStart() instanceof GeneratedState) {
            return false;
        }
        Val target = (Val)((Node)((INode)t2.getTarget()).fact()).fact();
        Val source = (Val)((Node)((INode)t2.getStart()).fact()).fact();
        Type sourceVal = source.getType();
        if (sourceVal.equals(targetVal = target.getType())) {
            return false;
        }
        if (source.isStatic()) {
            return false;
        }
        if (!(targetVal instanceof RefType) || !(sourceVal instanceof RefType)) {
            return this.options.killNullAtCast() && targetVal instanceof NullType && this.isCastNode((Node)((INode)t2.getStart()).fact());
        }
        RefType targetType = (RefType)targetVal;
        RefType sourceType = (RefType)sourceVal;
        if (targetType.getSootClass().isPhantom() || sourceType.getSootClass().isPhantom()) {
            return false;
        }
        if (target instanceof AllocVal && ((AllocVal)target).allocationValue() instanceof NewExpr) {
            boolean castFails = Scene.v().getOrMakeFastHierarchy().canStoreType(targetType, sourceType);
            return !castFails;
        }
        if (targetType.getSootClass().isInterface()) {
            return false;
        }
        boolean castFails = Scene.v().getOrMakeFastHierarchy().canStoreType(targetType, sourceType) || Scene.v().getOrMakeFastHierarchy().canStoreType(sourceType, targetType);
        return !castFails;
    }

    private boolean isCastNode(Node<Statement, Val> node) {
        CastExpr c;
        AssignStmt x;
        Stmt stmt = node.stmt().getUnit().get();
        return stmt instanceof AssignStmt && (x = (AssignStmt)stmt).getRightOp() instanceof CastExpr && (c = (CastExpr)x.getRightOp()).getOp().equals(node.fact().value());
    }

    public void addReachable(SootMethod m4) {
        if (this.reachableMethods.add(m4)) {
            ArrayList<Runnable> collection = Lists.newArrayList(this.queuedReachableMethod.get(m4));
            for (Runnable runnable : collection) {
                runnable.run();
            }
            for (ReachableMethodListener reachableMethodListener : Lists.newArrayList(this.reachableMethodListeners)) {
                reachableMethodListener.reachable(m4);
            }
        }
    }

    public void submit(SootMethod method, Runnable runnable) {
        if (this.reachableMethods.contains(method) || !this.options.onTheFlyCallGraph()) {
            runnable.run();
        } else {
            this.queuedReachableMethod.put(method, runnable);
        }
    }

    public void registerReachableMethodListener(ReachableMethodListener<W> reachableMethodListener) {
        if (this.reachableMethodListeners.add(reachableMethodListener)) {
            for (SootMethod m4 : Lists.newArrayList(this.reachableMethods)) {
                reachableMethodListener.reachable(m4);
            }
        }
    }

    public Map<RegExAccessPath, W> getResultsAt(final Statement stmt) {
        final HashMap results = Maps.newHashMap();
        this.fieldAutomaton.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (t2.getStart() instanceof GeneratedState) {
                    return;
                }
                if (((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).equals(stmt)) {
                    IRegEx<Field> regEx = AbstractBoomerangSolver.this.fieldAutomaton.toRegEx(t2.getStart(), AbstractBoomerangSolver.this.fieldAutomaton.getInitialState());
                    results.put(new RegExAccessPath((Val)((Node)((INode)t2.getStart()).fact()).fact(), regEx), w);
                }
            }
        });
        return results;
    }

    public Table<Statement, RegExAccessPath, W> getResults(final SootMethod m4) {
        final HashBasedTable results = HashBasedTable.create();
        logger.debug("Start extracting results from {}", (Object)this);
        this.fieldAutomaton.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(final Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (t2.getStart() instanceof GeneratedState) {
                    return;
                }
                if (((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).getMethod().equals(m4)) {
                    final IRegEx regEx = AbstractBoomerangSolver.this.fieldAutomaton.toRegEx(t2.getStart(), AbstractBoomerangSolver.this.fieldAutomaton.getInitialState());
                    AbstractBoomerangSolver.this.callAutomaton.registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

                        @Override
                        public void onWeightAdded(Transition<Statement, INode<Val>> callT, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                            if (((Val)((INode)callT.getStart()).fact()).equals(((Node)((INode)t2.getStart()).fact()).fact()) && ((Statement)callT.getLabel()).equals(((Node)((INode)t2.getStart()).fact()).stmt())) {
                                results.put(((Node)((INode)t2.getStart()).fact()).stmt(), new RegExAccessPath((Val)((Node)((INode)t2.getStart()).fact()).fact(), regEx), w);
                            }
                        }
                    });
                }
            }
        });
        logger.debug("End extracted results from {}", (Object)this);
        return results;
    }

    public void debugFieldAutomaton(final Statement stmt) {
        this.fieldAutomaton.registerListener(new WPAUpdateListener<Field, INode<Node<Statement, Val>>, W>(){

            @Override
            public void onWeightAdded(Transition<Field, INode<Node<Statement, Val>>> t2, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> aut) {
                if (t2.getStart() instanceof GeneratedState) {
                    return;
                }
                if (((Statement)((Node)((INode)t2.getStart()).fact()).stmt()).equals(stmt)) {
                    IRegEx regEx = AbstractBoomerangSolver.this.fieldAutomaton.toRegEx(t2.getStart(), AbstractBoomerangSolver.this.fieldAutomaton.getInitialState());
                    logger.debug(((Node)((INode)t2.getStart()).fact()).fact() + " " + regEx);
                }
            }
        });
    }

    public Collection<SootMethod> getReachableMethods() {
        return this.reachableMethods;
    }

    public void cleanup() {
        this.callAutomaton.clearListener();
        this.fieldAutomaton.clearListener();
        this.queuedReachableMethod.clear();
        this.perMethodFieldTransitionsListener.clear();
        this.perStatementCallTransitionsListener.clear();
        this.perStatementFieldTransitionsListener.clear();
    }

    public Set<SootMethod> getVisitedMethods() {
        HashSet<SootMethod> methods = Sets.newHashSet();
        for (Node s2 : this.getReachedStates()) {
            methods.add(((Statement)s2.stmt()).getMethod());
        }
        return methods;
    }

    public Set<Val> getValsAtStatement(Statement exitStmt) {
        HashSet<Val> vals = Sets.newHashSet();
        for (Node s2 : this.getReachedStates()) {
            if (!((Statement)s2.stmt()).equals(exitStmt)) continue;
            vals.add((Val)s2.fact());
        }
        return vals;
    }

    private final class ReturnFlowCallerListener
    implements CallerListener<Unit, SootMethod> {
        private final Stmt curr;
        private final SootMethod method;
        private final Val value;
        private final Node<Statement, Val> currNode;

        private ReturnFlowCallerListener(Stmt curr, SootMethod method, Val value, Node<Statement, Val> currNode) {
            this.curr = curr;
            this.method = method;
            this.value = value;
            this.currNode = currNode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
            result = 31 * result + (this.currNode == null ? 0 : this.currNode.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnFlowCallerListener other = (ReturnFlowCallerListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.curr == null ? other.curr != null : !this.curr.equals(other.curr)) {
                return false;
            }
            if (this.currNode == null ? other.currNode != null : !this.currNode.equals(other.currNode)) {
                return false;
            }
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public void onCallerAdded(Unit callSite, SootMethod m4) {
            if (!((Stmt)callSite).containsInvokeExpr()) {
                return;
            }
            HashSet<State> out = Sets.newHashSet();
            for (Unit returnSite : AbstractBoomerangSolver.this.icfg.getSuccsOf(callSite)) {
                Collection<State> outFlow = AbstractBoomerangSolver.this.computeReturnFlow(this.method, this.curr, this.value, (Stmt)callSite, (Stmt)returnSite);
                out.addAll(outFlow);
            }
            for (State s2 : out) {
                AbstractBoomerangSolver.this.propagate(this.currNode, s2);
            }
        }

        @Override
        public SootMethod getObservedCallee() {
            return this.method;
        }

        private AbstractBoomerangSolver getOuterType() {
            return AbstractBoomerangSolver.this;
        }
    }
}

