/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.Util;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.AbstractBoomerangResults;
import boomerang.results.ExtractAllAliasListener;
import boomerang.results.ExtractAllocationSiteStateListener;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import boomerang.util.AccessPath;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import heros.utilities.DefaultValueMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.PointsToSet;
import soot.Type;
import soot.jimple.ClassConstant;
import soot.jimple.NewExpr;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;

public class BackwardBoomerangResults<W extends Weight>
extends AbstractBoomerangResults<W>
implements PointsToSet {
    private final BackwardQuery query;
    private Map<ForwardQuery, AbstractBoomerangResults.Context> allocationSites;
    private final boolean timedout;
    private final IBoomerangStats<W> stats;
    private Stopwatch analysisWatch;
    private long maxMemory;

    public BackwardBoomerangResults(BackwardQuery query, boolean timedout, DefaultValueMap<Query, AbstractBoomerangSolver<W>> queryToSolvers, IBoomerangStats<W> stats, Stopwatch analysisWatch) {
        super(queryToSolvers);
        this.query = query;
        this.timedout = timedout;
        this.stats = stats;
        this.analysisWatch = analysisWatch;
        stats.terminated(query, this);
        this.maxMemory = Util.getReallyUsedMemory();
    }

    public Map<ForwardQuery, AbstractBoomerangResults.Context> getAllocationSites() {
        this.computeAllocations();
        return this.allocationSites;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public Stopwatch getAnalysisWatch() {
        return this.analysisWatch;
    }

    private void computeAllocations() {
        if (this.allocationSites != null) {
            return;
        }
        final HashSet<ForwardQuery> results = Sets.newHashSet();
        for (Map.Entry fw : this.queryToSolvers.entrySet()) {
            if (!(fw.getKey() instanceof ForwardQuery)) continue;
            ((AbstractBoomerangSolver)fw.getValue()).getFieldAutomaton().registerListener(new ExtractAllocationSiteStateListener<W>(((AbstractBoomerangSolver)fw.getValue()).getFieldAutomaton().getInitialState(), this.query, (ForwardQuery)fw.getKey()){

                @Override
                protected void allocationSiteFound(ForwardQuery allocationSite, BackwardQuery query) {
                    results.add(allocationSite);
                }
            });
        }
        this.allocationSites = Maps.newHashMap();
        for (ForwardQuery q : results) {
            AbstractBoomerangResults.Context context = this.constructContextGraph(q, this.query.asNode());
            assert (this.allocationSites.get(q) == null);
            this.allocationSites.put(q, context);
        }
    }

    public boolean aliases(Query el) {
        for (Query query : this.getAllocationSites().keySet()) {
            if (query instanceof BackwardQuery || !((AbstractBoomerangSolver)this.queryToSolvers.getOrCreate(query)).getReachedStates().contains(el.asNode())) continue;
            for (Transition<Field, INode<Node<Statement, Val>>> t2 : ((AbstractBoomerangSolver)this.queryToSolvers.getOrCreate(query)).getFieldAutomaton().getTransitions()) {
                if (t2.getStart() instanceof GeneratedState || !((Node)((INode)t2.getStart()).fact()).equals(el.asNode()) || !((Field)t2.getLabel()).equals(Field.empty())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public Set<AccessPath> getAllAliases(Statement stmt) {
        HashSet<AccessPath> results = Sets.newHashSet();
        for (Query query : this.getAllocationSites().keySet()) {
            if (query instanceof BackwardQuery) continue;
            ((AbstractBoomerangSolver)this.queryToSolvers.getOrCreate(query)).registerListener(new ExtractAllAliasListener((AbstractBoomerangSolver)this.queryToSolvers.get(query), results, stmt));
        }
        return results;
    }

    @Deprecated
    public Set<AccessPath> getAllAliases() {
        return this.getAllAliases(this.query.stmt());
    }

    @Override
    public boolean isEmpty() {
        this.computeAllocations();
        return this.allocationSites.isEmpty();
    }

    @Override
    public boolean hasNonEmptyIntersection(PointsToSet other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BackwardBoomerangResults)) {
            throw new RuntimeException("Expected a points-to set of type " + BackwardBoomerangResults.class.getName());
        }
        BackwardBoomerangResults otherRes = (BackwardBoomerangResults)other;
        Map<ForwardQuery, AbstractBoomerangResults.Context> otherAllocs = otherRes.getAllocationSites();
        boolean intersection = false;
        for (Map.Entry<ForwardQuery, AbstractBoomerangResults.Context> a : this.getAllocationSites().entrySet()) {
            for (Map.Entry<ForwardQuery, AbstractBoomerangResults.Context> b : otherAllocs.entrySet()) {
                if (!a.getKey().equals(b.getKey()) || !this.contextMatch(a.getValue(), b.getValue())) continue;
                intersection = true;
            }
        }
        return intersection;
    }

    private boolean contextMatch(AbstractBoomerangResults.Context context, AbstractBoomerangResults.Context context2) {
        return true;
    }

    @Override
    public Set<Type> possibleTypes() {
        this.computeAllocations();
        HashSet<Type> res = Sets.newHashSet();
        for (ForwardQuery q : this.allocationSites.keySet()) {
            Val fact = q.asNode().fact();
            if (fact.isNewExpr()) {
                AllocVal alloc = (AllocVal)fact;
                NewExpr expr = (NewExpr)alloc.allocationValue();
                res.add(expr.getType());
                continue;
            }
            res.add(fact.value().getType());
        }
        return res;
    }

    public Set<Type> getPropagationType() {
        AbstractBoomerangSolver solver = (AbstractBoomerangSolver)this.queryToSolvers.get(this.query);
        HashSet<Type> types = Sets.newHashSet();
        for (Transition<Statement, INode<Val>> t2 : solver.getCallAutomaton().getTransitions()) {
            types.add(((Val)((INode)t2.getStart()).fact()).getType());
        }
        return types;
    }

    public Set<Node<Statement, Val>> getDataFlowPath(ForwardQuery query) {
        HashSet<Node<Statement, Val>> dataFlowPath = Sets.newHashSet();
        WeightedPAutomaton callAut = ((AbstractBoomerangSolver)this.queryToSolvers.getOrCreate(query)).getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition<Statement, INode<Val>> t2 = e.getKey();
            if (((Statement)t2.getLabel()).equals(Statement.epsilon()) || ((Val)((INode)t2.getStart()).fact()).value() instanceof Local && !((Statement)t2.getLabel()).getMethod().equals(((Val)((INode)t2.getStart()).fact()).m()) || !((AbstractBoomerangSolver)this.queryToSolvers.getOrCreate(query)).valueUsedInStatement(((Statement)t2.getLabel()).getUnit().get(), (Val)((INode)t2.getStart()).fact())) continue;
            dataFlowPath.add(new Node(t2.getLabel(), ((INode)t2.getStart()).fact()));
        }
        return dataFlowPath;
    }

    @Override
    public Set<String> possibleStringConstants() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Set<ClassConstant> possibleClassConstants() {
        throw new RuntimeException("Not implemented!");
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }
}

