/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import heros.utilities.DefaultValueMap;
import java.util.Map;
import java.util.Set;
import soot.Local;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.PAutomaton;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAStateListener;

public class AbstractBoomerangResults<W extends Weight> {
    protected final DefaultValueMap<Query, AbstractBoomerangSolver<W>> queryToSolvers;

    public AbstractBoomerangResults(DefaultValueMap<Query, AbstractBoomerangSolver<W>> solverMap) {
        this.queryToSolvers = solverMap;
    }

    protected Context constructContextGraph(ForwardQuery forwardQuery, Node<Statement, Val> targetFact) {
        Context context = new Context(targetFact, forwardQuery);
        context.computeUnmatchedOpeningContext();
        context.computeUnmatchedClosingContext();
        return context;
    }

    public Table<Statement, Val, W> asStatementValWeightTable(ForwardQuery query) {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton<Statement, INode<Val>, W> callAut = this.queryToSolvers.getOrCreate(query).getCallAutomaton();
        for (Map.Entry<Transition<Statement, INode<Val>>, W> e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition<Statement, INode<Val>> t2 = e.getKey();
            Weight w = (Weight)e.getValue();
            if (((Statement)t2.getLabel()).equals(Statement.epsilon()) || ((Val)((INode)t2.getStart()).fact()).value() instanceof Local && !((Statement)t2.getLabel()).getMethod().equals(((Val)((INode)t2.getStart()).fact()).m()) || !((Statement)t2.getLabel()).getUnit().isPresent()) continue;
            results.put(t2.getLabel(), ((INode)t2.getStart()).fact(), w);
        }
        return results;
    }

    public class Context {
        final Node<Statement, Val> node;
        private final PAutomaton<Statement, INode<Val>> openingContext;
        private final PAutomaton<Statement, INode<Val>> closingContext;
        private final Set<INode<Val>> unbalancedClosingContexts = Sets.newHashSet();
        private ForwardQuery forwardQuery;

        public Context(Node<Statement, Val> node, ForwardQuery forwardQuery) {
            this.node = node;
            this.forwardQuery = forwardQuery;
            this.openingContext = new PAutomaton<Statement, INode<Val>>(new SingleNode<Val>(node.fact())){

                @Override
                public INode<Val> createState(INode<Val> d, Statement loc) {
                    throw new RuntimeException("Not implemented");
                }

                @Override
                public boolean isGeneratedState(INode<Val> d) {
                    throw new RuntimeException("Not implemented");
                }

                @Override
                public Statement epsilon() {
                    return Statement.epsilon();
                }
            };
            this.closingContext = new PAutomaton<Statement, INode<Val>>(new SingleNode<Val>(node.fact())){

                @Override
                public INode<Val> createState(INode<Val> d, Statement loc) {
                    throw new RuntimeException("Not implemented");
                }

                @Override
                public boolean isGeneratedState(INode<Val> d) {
                    throw new RuntimeException("Not implemented");
                }

                @Override
                public Statement epsilon() {
                    return Statement.epsilon();
                }
            };
        }

        public void computeUnmatchedClosingContext() {
            for (INode<Val> v : this.unbalancedClosingContexts) {
                AbstractBoomerangResults.this.queryToSolvers.get(this.forwardQuery).getCallAutomaton().registerListener(new ClosingCallStackExtracter(v, v, this, AbstractBoomerangResults.this.queryToSolvers.get(this.forwardQuery)));
            }
        }

        public void computeUnmatchedOpeningContext() {
            SingleNode<Val> initialState = new SingleNode<Val>(this.node.fact());
            AbstractBoomerangResults.this.queryToSolvers.get(this.forwardQuery).getCallAutomaton().registerListener(new OpeningCallStackExtracter(initialState, initialState, this, AbstractBoomerangResults.this.queryToSolvers.get(this.forwardQuery)));
        }

        public void addUnbalancedNodes(INode<Val> target) {
            this.unbalancedClosingContexts.add(target);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.closingContext == null ? 0 : this.closingContext.hashCode());
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.openingContext == null ? 0 : this.openingContext.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        private AbstractBoomerangResults getOuterType() {
            return AbstractBoomerangResults.this;
        }

        public PAutomaton<Statement, INode<Val>> getOpeningContext() {
            return this.openingContext;
        }

        public PAutomaton<Statement, INode<Val>> getClosingContext() {
            return this.closingContext;
        }
    }

    private class ClosingCallStackExtracter
    extends WPAStateListener<Statement, INode<Val>, W> {
        private AbstractBoomerangSolver<W> solver;
        private INode<Val> source;
        private Context context;

        public ClosingCallStackExtracter(INode<Val> state, INode<Val> source, Context context, AbstractBoomerangSolver<W> solver) {
            super(state);
            this.source = source;
            this.context = context;
            this.solver = solver;
        }

        @Override
        public void onOutTransitionAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> weightedPAutomaton) {
        }

        @Override
        public void onInTransitionAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> weightedPAutomaton) {
            if (weightedPAutomaton.isUnbalancedState((INode<Val>)t2.getStart()) && !((Val)((INode)t2.getStart()).fact()).isStatic()) {
                this.context.getClosingContext().addTransition(t2);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.solver == null ? 0 : this.solver.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClosingCallStackExtracter other = (ClosingCallStackExtracter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            if (this.solver == null ? other.solver != null : !this.solver.equals(other.solver)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        private AbstractBoomerangResults getOuterType() {
            return AbstractBoomerangResults.this;
        }
    }

    private class OpeningCallStackExtracter
    extends WPAStateListener<Statement, INode<Val>, W> {
        private AbstractBoomerangSolver<W> solver;
        private INode<Val> source;
        private Context context;

        public OpeningCallStackExtracter(INode<Val> state, INode<Val> source, Context context, AbstractBoomerangSolver<W> solver) {
            super(state);
            this.source = source;
            this.context = context;
            this.solver = solver;
        }

        @Override
        public void onOutTransitionAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> weightedPAutomaton) {
            if (((INode)t2.getTarget()).equals(weightedPAutomaton.getInitialState())) {
                return;
            }
            if (((Val)((INode)t2.getTarget()).fact()).isUnbalanced()) {
                this.context.addUnbalancedNodes((INode)t2.getTarget());
            }
            if (((Statement)t2.getLabel()).getMethod() != null && this.solver.getReachableMethods().contains(((Statement)t2.getLabel()).getMethod())) {
                if (t2.getStart() instanceof GeneratedState) {
                    this.context.getOpeningContext().addTransition(new Transition<Object, Object>(this.source, t2.getLabel(), t2.getTarget()));
                } else {
                    weightedPAutomaton.registerListener(new OpeningCallStackExtracter((INode)t2.getTarget(), this.source, this.context, this.solver));
                    return;
                }
            }
            weightedPAutomaton.registerListener(new OpeningCallStackExtracter((INode)t2.getTarget(), (INode)t2.getTarget(), this.context, this.solver));
        }

        @Override
        public void onInTransitionAdded(Transition<Statement, INode<Val>> t2, W w, WeightedPAutomaton<Statement, INode<Val>, W> weightedPAutomaton) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.solver == null ? 0 : this.solver.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpeningCallStackExtracter other = (OpeningCallStackExtracter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            if (this.solver == null ? other.solver != null : !this.solver.equals(other.solver)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        private AbstractBoomerangResults getOuterType() {
            return AbstractBoomerangResults.this;
        }
    }
}

