/*
 * Decompiled with CFR 0.152.
 */
package boomerang.jimple;

import com.google.common.collect.Maps;
import java.util.Map;
import soot.SootField;
import wpds.interfaces.Empty;
import wpds.interfaces.Location;
import wpds.wildcard.ExclusionWildcard;
import wpds.wildcard.Wildcard;

public class Field
implements Location {
    private static Field wildcard;
    private static Field epsilon;
    private static Field empty;
    private static Field array;
    private final SootField delegate;
    private final String rep;
    private static Map<Field, ExclusionWildcardField> exclusionWildcards;

    public Field(SootField delegate) {
        this.delegate = delegate;
        this.rep = null;
    }

    private Field(String rep) {
        this.rep = rep;
        this.delegate = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.rep != null) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (other.rep != null) {
            return false;
        }
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        if (this.delegate == null) {
            return this.rep;
        }
        return this.delegate.getName().toString();
    }

    public static Field wildcard() {
        if (wildcard == null) {
            wildcard = new WildcardField();
        }
        return wildcard;
    }

    public static Field empty() {
        if (empty == null) {
            empty = new EmptyField("{}");
        }
        return empty;
    }

    public static Field epsilon() {
        if (epsilon == null) {
            epsilon = new EmptyField("eps_f");
        }
        return epsilon;
    }

    public static Field array() {
        if (array == null) {
            array = new Field("array");
        }
        return array;
    }

    public static Field exclusionWildcard(Field exclusion) {
        if (!exclusionWildcards.containsKey(exclusion)) {
            exclusionWildcards.put(exclusion, new ExclusionWildcardField(exclusion));
        }
        return exclusionWildcards.get(exclusion);
    }

    public SootField getSootField() {
        return this.delegate;
    }

    static {
        exclusionWildcards = Maps.newHashMap();
    }

    private static class ExclusionWildcardField
    extends Field
    implements ExclusionWildcard<Field> {
        private final Field excludes;

        public ExclusionWildcardField(Field excl) {
            super(excl.delegate);
            this.excludes = excl;
        }

        @Override
        public Field excludes() {
            return this.excludes;
        }

        @Override
        public String toString() {
            return "not " + super.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExclusionWildcardField other = (ExclusionWildcardField)obj;
            return !(this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes));
        }
    }

    private static class WildcardField
    extends Field
    implements Wildcard {
        public WildcardField() {
            super("*");
        }
    }

    private static class EmptyField
    extends Field
    implements Empty {
        public EmptyField(String rep) {
            super(rep);
        }
    }
}

