/*
 * Decompiled with CFR 0.152.
 */
package boomerang.example;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.DefaultBoomerangOptions;
import boomerang.callgraph.ObservableDynamicICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.preanalysis.BoomerangPretransformer;
import boomerang.results.BackwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import soot.G;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Transformer;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.options.Options;
import soot.util.queue.QueueReader;
import wpds.impl.Weight;

public class ExampleMain {
    public static void main(String ... args) {
        String sootClassPath = ExampleMain.getSootClassPath();
        String mainClass = "boomerang.example.BoomerangExampleTarget";
        ExampleMain.setupSoot(sootClassPath, mainClass);
        ExampleMain.analyze();
    }

    private static String getSootClassPath() {
        String sootClassPath = System.getProperty("user.dir") + File.separator + "target" + File.separator + "classes";
        File classPathDir = new File(sootClassPath);
        if (!classPathDir.exists() && !(classPathDir = new File(sootClassPath = System.getProperty("user.dir") + File.separator + "boomerangPDS" + File.separator + "target" + File.separator + "classes")).exists()) {
            throw new RuntimeException("Classpath could not be found.");
        }
        return sootClassPath;
    }

    private static void setupSoot(String sootClassPath, String mainClass) {
        G.v();
        G.reset();
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.*");
        includeList.add("java.util.*");
        includeList.add("java.io.*");
        includeList.add("sun.misc.*");
        includeList.add("java.net.*");
        includeList.add("javax.servlet.*");
        includeList.add("javax.crypto.*");
        Options.v().set_include(includeList);
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().set_soot_classpath(sootClassPath);
        Options.v().set_prepend_classpath(true);
        Scene.v().loadNecessaryClasses();
        SootClass c = Scene.v().forceResolve(mainClass, 3);
        if (c != null) {
            c.setApplicationClass();
        }
        for (SootMethod m4 : c.getMethods()) {
            System.out.println(m4);
        }
    }

    private static void analyze() {
        Transform transform = new Transform("wjtp.ifds", ExampleMain.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        PackManager.v().getPack("cg").apply();
        BoomerangPretransformer.v().apply();
        PackManager.v().getPack("wjtp").apply();
    }

    private static Transformer createAnalysisTransformer() {
        return new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                Boomerang solver = new Boomerang(new DefaultBoomerangOptions(){

                    @Override
                    public boolean onTheFlyCallGraph() {
                        return false;
                    }
                }){
                    ObservableICFG<Unit, SootMethod> icfg;
                    {
                        super(opt);
                        this.icfg = new ObservableDynamicICFG(this);
                    }

                    @Override
                    public ObservableICFG<Unit, SootMethod> icfg() {
                        return this.icfg;
                    }

                    @Override
                    public SeedFactory<Weight.NoWeight> getSeedFactory() {
                        return null;
                    }
                };
                BackwardQuery query = this.createQuery();
                System.out.println("Solving query: " + query);
                BackwardBoomerangResults backwardQueryResults = solver.solve(query);
                solver.debugOutput();
                System.out.println("All allocation sites of the query variable are:");
                System.out.println(backwardQueryResults.getAllocationSites());
                System.out.println("All aliasing access path of the query variable are:");
                System.out.println(backwardQueryResults.getAllAliases());
            }

            private BackwardQuery createQuery() {
                ReachableMethods reachableMethods = Scene.v().getReachableMethods();
                QueueReader<MethodOrMethodContext> l = reachableMethods.listener();
                while (l.hasNext()) {
                    MethodOrMethodContext next = l.next();
                    BackwardQuery q = this.getQuery(next.method());
                    if (q == null) continue;
                    return q;
                }
                throw new RuntimeException("No method found that contains a call to method queryFor!");
            }

            private BackwardQuery getQuery(SootMethod method) {
                if (!method.hasActiveBody()) {
                    return null;
                }
                for (Unit u : method.getActiveBody().getUnits()) {
                    Stmt s2;
                    if (!(u instanceof Stmt) || !(s2 = (Stmt)u).containsInvokeExpr() || !s2.toString().contains("queryFor")) continue;
                    Value arg = s2.getInvokeExpr().getArg(0);
                    return new BackwardQuery(new Statement(s2, method), new Val(arg, method));
                }
                return null;
            }
        };
    }
}

