/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.BackwardQuery;
import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.util.RegExAccessPath;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.NormalRule;
import wpds.impl.Rule;
import wpds.impl.Weight;

public class IDEVizDebugger<W extends Weight>
extends Debugger<W> {
    private static boolean ONLY_CFG = false;
    private static final Logger logger = LoggerFactory.getLogger(IDEVizDebugger.class);
    private File ideVizFile;
    private ObservableICFG<Unit, SootMethod> icfg;
    private Table<Query, SootMethod, Set<Rule<Statement, INode<Val>, W>>> rules = HashBasedTable.create();
    private Map<Object, Integer> objectToInteger = new HashMap<Object, Integer>();
    private int charSize;

    public IDEVizDebugger(File ideVizFile, ObservableICFG<Unit, SootMethod> icfg) {
        this.ideVizFile = ideVizFile;
        this.icfg = icfg;
    }

    private void callRules(Query q, Set<Rule<Statement, INode<Val>, W>> allRules) {
        for (Rule<Statement, INode<Val>, W> e : allRules) {
            Statement stmt = e.getL1();
            if (stmt.getMethod() == null) continue;
            Set<Rule<Statement, INode<Val>, W>> transInMethod = this.getOrCreateRuleSet(q, stmt.getMethod());
            transInMethod.add(e);
        }
    }

    private Set<Rule<Statement, INode<Val>, W>> getOrCreateRuleSet(Query q, SootMethod method) {
        Set<Rule<Statement, INode<Val>, W>> map = this.rules.get(q, method);
        if (map != null) {
            return map;
        }
        this.rules.put(q, method, Sets.newHashSet());
        return this.rules.get(q, method);
    }

    @Override
    public void done(Map<Query, AbstractBoomerangSolver<W>> solvers) {
        logger.warn("Starting to compute visualization, this requires a large amount of memory, please ensure the VM has enough memory.");
        Stopwatch watch = Stopwatch.createStarted();
        JSONArray eventualData = new JSONArray();
        if (!ONLY_CFG) {
            for (Query query : solvers.keySet()) {
                this.callRules(query, solvers.get(query).getCallPDS().getAllRules());
            }
        }
        for (Map.Entry entry : Lists.newArrayList(solvers.entrySet())) {
            logger.debug("Computing results for {}", entry.getKey());
            Query query = (Query)entry.getKey();
            JSONQuery queryJSON = new JSONQuery(query);
            JSONArray data = new JSONArray();
            for (SootMethod m4 : Lists.newArrayList(((AbstractBoomerangSolver)entry.getValue()).getReachableMethods())) {
                Table results = ((AbstractBoomerangSolver)entry.getValue()).getResults(m4);
                if (results.isEmpty()) continue;
                int labelYOffset = ONLY_CFG ? 0 : this.computeLabelYOffset(results.columnKeySet());
                JSONMethod jsonMethod = new JSONMethod(m4);
                logger.debug("Creating control-flow graph for {}", (Object)m4);
                JSONControlFlowGraph cfg = this.createControlFlowGraph(m4, labelYOffset);
                jsonMethod.put("cfg", cfg);
                if (!ONLY_CFG) {
                    Set<Rule<Statement, INode<Val>, W>> rulesInMethod = this.getOrCreateRuleSet(query, m4);
                    logger.debug("Creating data-flow graph for {}", (Object)m4);
                    DataFlowGraph dfg = this.createDataFlowGraph(query, results, rulesInMethod, cfg, m4, labelYOffset);
                    jsonMethod.put("dfg", dfg);
                }
                data.add(jsonMethod);
            }
            queryJSON.put("methods", data);
            eventualData.add(queryJSON);
        }
        logger.info("Computing visualization took: {}", (Object)watch.elapsed());
        try {
            Throwable throwable = null;
            try (FileWriter file = new FileWriter(this.ideVizFile);){
                logger.info("Writing visualization to file {}", (Object)this.ideVizFile.getAbsolutePath());
                file.write(eventualData.toJSONString());
                logger.info("Visualization available in file {}", (Object)this.ideVizFile.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info("Exception in writing to visualization file {}", (Object)this.ideVizFile.getAbsolutePath());
        }
    }

    private int computeLabelYOffset(Set<RegExAccessPath> facts) {
        int labelYOffset = 0;
        for (RegExAccessPath g2 : facts) {
            labelYOffset = Math.max(labelYOffset, this.charSize * g2.toString().length());
        }
        return labelYOffset;
    }

    private DataFlowGraph createDataFlowGraph(Query q, Table<Statement, RegExAccessPath, W> table, Set<Rule<Statement, INode<Val>, W>> rulesInMethod, JSONControlFlowGraph cfg, SootMethod m4, int labelYOffset) {
        LinkedList<RegExAccessPath> factsList = new LinkedList<RegExAccessPath>();
        DataFlowGraph dataFlowGraph = new DataFlowGraph();
        Set<RegExAccessPath> facts = table.columnKeySet();
        JSONArray data = new JSONArray();
        int offset = 0;
        int charSize = 8;
        for (RegExAccessPath u : facts) {
            JSONObject jSONObject = new JSONObject();
            JSONObject pos = new JSONObject();
            factsList.add(u);
            pos.put("x", factsList.size() * 30 + offset * charSize);
            pos.put("y", labelYOffset);
            jSONObject.put("position", pos);
            JSONObject label = new JSONObject();
            label.put("label", u.toString());
            label.put("factId", this.id(u));
            jSONObject.put("classes", "fact label method" + this.id(m4));
            jSONObject.put("data", label);
            data.add(jSONObject);
        }
        HashMultimap<Node<Statement, Val>, RegExAccessPath> esgNodes = HashMultimap.create();
        for (Table.Cell<Statement, RegExAccessPath, W> cell : table.cellSet()) {
            Statement statement = cell.getRowKey();
            Stmt stmt = statement.getUnit().get();
            RegExAccessPath val = cell.getColumnKey();
            if (!cell.getRowKey().getMethod().equals(val.getVal().m())) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            pos.put("x", (factsList.indexOf(val) + 1) * 30);
            pos.put("y", cfg.stmtsList.indexOf(stmt) * 30 + (q instanceof BackwardQuery ? 30 : 0));
            nodeObj.put("position", pos);
            String classes = "esgNode method" + this.id(m4) + " ";
            JSONObject additionalData = new JSONObject();
            additionalData.put("id", "q" + this.id(q) + "n" + this.id(new Node<Statement, RegExAccessPath>(statement, val)));
            additionalData.put("stmtId", this.id(stmt));
            additionalData.put("factId", this.id(val));
            if (cell.getValue() != null) {
                additionalData.put("ideValue", ((Weight)cell.getValue()).toString());
            }
            nodeObj.put("classes", classes);
            nodeObj.put("group", "nodes");
            nodeObj.put("data", additionalData);
            data.add(nodeObj);
            esgNodes.put(new Node<Statement, Val>(statement, val.getVal()), val);
        }
        for (Rule rule : rulesInMethod) {
            if (!(rule instanceof NormalRule)) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject dataEntry = new JSONObject();
            dataEntry.put("id", "e" + this.id(rule));
            Node<Statement, Val> start = this.getStartNode(rule);
            Node<Statement, Val> target = this.getTargetNode(rule);
            for (RegExAccessPath startField : esgNodes.get(start)) {
                for (RegExAccessPath targetField : esgNodes.get(target)) {
                    dataEntry.put("source", "q" + this.id(q) + "n" + this.id(new Node<Statement, RegExAccessPath>(start.stmt(), startField)));
                    dataEntry.put("target", "q" + this.id(q) + "n" + this.id(new Node<Statement, RegExAccessPath>(target.stmt(), targetField)));
                    dataEntry.put("directed", "true");
                    dataEntry.put("direction", q instanceof BackwardQuery ? "Backward" : "Forward");
                    nodeObj.put("data", dataEntry);
                    nodeObj.put("classes", "esgEdge  method" + this.id(m4));
                    nodeObj.put("group", "edges");
                    data.add(nodeObj);
                }
            }
        }
        dataFlowGraph.put("dataFlowNode", data);
        return dataFlowGraph;
    }

    private Node<Statement, Val> getTargetNode(Rule<Statement, INode<Val>, W> rule) {
        return new Node<Statement, Val>(rule.getL2(), rule.getS2().fact());
    }

    private Node<Statement, Val> getStartNode(Rule<Statement, INode<Val>, W> rule) {
        return new Node<Statement, Val>(rule.getL1(), rule.getS1().fact());
    }

    private JSONControlFlowGraph createControlFlowGraph(SootMethod m4, int labelYOffset) {
        JSONControlFlowGraph cfg = new JSONControlFlowGraph();
        int index = 0;
        int offset = 0;
        JSONArray data = new JSONArray();
        for (Unit u : m4.getActiveBody().getUnits()) {
            JSONArray callees;
            if (this.icfg.getMethodOf(u) == null) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            cfg.stmtsList.add(u);
            pos.put("x", 10);
            pos.put("y", cfg.stmtsList.size() * 30 + labelYOffset);
            nodeObj.put("position", pos);
            JSONObject label = new JSONObject();
            label.put("label", u.toString());
            label.put("shortLabel", this.getShortLabel(u));
            if (this.icfg.isCallStmt(u)) {
                label.put("callSite", this.icfg.isCallStmt(u));
                callees = new JSONArray();
                this.icfg.addCalleeListener(new JsonCalleeListener(u, callees));
                label.put("callees", callees);
            }
            if (this.icfg.isExitStmt(u)) {
                label.put("returnSite", this.icfg.isExitStmt(u));
                callees = new JSONArray();
                HashSet<SootMethod> callers = new HashSet<SootMethod>();
                this.icfg.addCallerListener(new JsonCallerListener(u, callers));
                for (SootMethod caller : callers) {
                    callees.add(new JSONMethod(caller));
                }
                label.put("callers", callees);
            }
            label.put("stmtId", this.id(u));
            label.put("id", "stmt" + this.id(u));
            label.put("stmtIndex", index);
            ++index;
            nodeObj.put("data", label);
            nodeObj.put("classes", "stmt label " + (this.icfg.isExitStmt(u) ? " returnSite " : " ") + (this.icfg.isCallStmt(u) ? " callSite " : " ") + " method" + this.id(m4));
            data.add(nodeObj);
            offset = Math.max(offset, this.getShortLabel(u).toString().length());
            for (Unit succ : this.icfg.getSuccsOf(u)) {
                JSONObject cfgEdgeObj = new JSONObject();
                JSONObject dataEntry = new JSONObject();
                dataEntry.put("source", "stmt" + this.id(u));
                dataEntry.put("target", "stmt" + this.id(succ));
                dataEntry.put("directed", "true");
                cfgEdgeObj.put("data", dataEntry);
                cfgEdgeObj.put("classes", "cfgEdge label method" + this.id(m4));
                data.add(cfgEdgeObj);
            }
        }
        cfg.put("controlFlowNode", data);
        return cfg;
    }

    private String getShortLabel(Unit u) {
        if (u instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)u;
            if (assignStmt.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getRightOp();
                return assignStmt.getLeftOp() + " = " + fr.getBase() + "." + fr.getField().getName();
            }
            if (assignStmt.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef fr = (InstanceFieldRef)assignStmt.getLeftOp();
                return fr.getBase() + "." + fr.getField().getName() + " = " + assignStmt.getRightOp();
            }
        }
        if (u instanceof Stmt && ((Stmt)u).containsInvokeExpr()) {
            InvokeExpr invokeExpr = ((Stmt)u).getInvokeExpr();
            if (invokeExpr instanceof StaticInvokeExpr) {
                return (u instanceof AssignStmt ? ((AssignStmt)u).getLeftOp() + " = " : "") + invokeExpr.getMethod().getName() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
            if (invokeExpr instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)invokeExpr;
                return (u instanceof AssignStmt ? ((AssignStmt)u).getLeftOp() + " = " : "") + iie.getBase() + "." + invokeExpr.getMethod().getName() + "(" + invokeExpr.getArgs().toString().replace("[", "").replace("]", "") + ")";
            }
        }
        return u.toString();
    }

    public Integer id(Object u) {
        if (this.objectToInteger.get(u) != null) {
            return this.objectToInteger.get(u);
        }
        int size = this.objectToInteger.size() + 1;
        this.objectToInteger.put(u, size);
        return size;
    }

    private class DataFlowGraph
    extends JSONObject {
        private DataFlowGraph() {
        }
    }

    private class JSONControlFlowGraph
    extends JSONObject {
        public List<Unit> stmtsList = Lists.newLinkedList();

        private JSONControlFlowGraph() {
        }
    }

    private class JSONQuery
    extends JSONObject {
        JSONQuery(Query m4) {
            this.put("query", StringEscapeUtils.escapeHtml4(this.prettyPrintQuery(m4)));
            this.put("id", IDEVizDebugger.this.id(m4));
        }

        private String prettyPrintQuery(Query m4) {
            return (m4 instanceof BackwardQuery ? "B " : "F ") + m4.asNode().fact().value() + " @ " + m4.asNode().stmt().getMethod().getName();
        }
    }

    private class JSONMethod
    extends JSONObject {
        JSONMethod(SootMethod m4) {
            this.put("methodName", StringEscapeUtils.escapeHtml4(m4.toString()));
            this.put("id", IDEVizDebugger.this.id(m4));
        }
    }

    private class JsonCallerListener
    implements CallerListener<Unit, SootMethod> {
        Unit u;
        Set<SootMethod> callers;

        JsonCallerListener(Unit u, Set<SootMethod> callers) {
            this.u = u;
            this.callers = callers;
        }

        @Override
        public SootMethod getObservedCallee() {
            return (SootMethod)IDEVizDebugger.this.icfg.getMethodOf(this.u);
        }

        @Override
        public void onCallerAdded(Unit unit, SootMethod sootMethod) {
            this.callers.add((SootMethod)IDEVizDebugger.this.icfg.getMethodOf(unit));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCallerListener that = (JsonCallerListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callers, that.callers);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callers);
        }
    }

    private class JsonCalleeListener
    implements CalleeListener<Unit, SootMethod> {
        Unit u;
        JSONArray callees;

        JsonCalleeListener(Unit u, JSONArray callees) {
            this.u = u;
            this.callees = callees;
        }

        @Override
        public Unit getObservedCaller() {
            return this.u;
        }

        @Override
        public void onCalleeAdded(Unit unit, SootMethod sootMethod) {
            if (sootMethod != null && sootMethod.toString() != null) {
                this.callees.add(new JSONMethod(sootMethod));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCalleeListener that = (JsonCalleeListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callees, that.callees);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callees);
        }
    }
}

