/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.Query;
import boomerang.debugger.Debugger;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.base.Joiner;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import wpds.impl.Weight;

public class ConsoleDebugger<W extends Weight>
extends Debugger<W> {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleDebugger.class);

    @Override
    public void done(Map<Query, AbstractBoomerangSolver<W>> queryToSolvers) {
        int totalRules = 0;
        for (Query q : queryToSolvers.keySet()) {
            totalRules += queryToSolvers.get(q).getNumberOfRules();
        }
        logger.debug("Total number of rules: " + totalRules);
        for (Query q : queryToSolvers.keySet()) {
            logger.debug("========================");
            logger.debug(q.toString());
            logger.debug("========================");
            queryToSolvers.get(q).debugOutput();
            for (SootMethod m4 : queryToSolvers.get(q).getReachableMethods()) {
                logger.debug(m4 + "\n" + Joiner.on("\n\t").join(queryToSolvers.get(q).getResults(m4).cellSet()));
            }
            queryToSolvers.get(q).debugOutput();
        }
    }
}

