/*
 * Decompiled with CFR 0.152.
 */
package boomerang.callgraph;

import boomerang.callgraph.BoomerangICFG;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class ObservableStaticICFG
implements ObservableICFG<Unit, SootMethod> {
    private BoomerangICFG precomputedGraph;
    private Set<SootMethod> unbalancedMethods = Sets.newHashSet();

    public ObservableStaticICFG(BoomerangICFG icfg) {
        this.precomputedGraph = icfg;
    }

    @Override
    public SootMethod getMethodOf(Unit unit) {
        return this.precomputedGraph.getMethodOf(unit);
    }

    @Override
    public List<Unit> getPredsOf(Unit unit) {
        return this.precomputedGraph.getPredsOf(unit);
    }

    @Override
    public List<Unit> getSuccsOf(Unit unit) {
        return this.precomputedGraph.getSuccsOf(unit);
    }

    @Override
    public void addCalleeListener(CalleeListener<Unit, SootMethod> listener) {
        for (SootMethod method : this.precomputedGraph.getCalleesOfCallAt(listener.getObservedCaller())) {
            listener.onCalleeAdded(listener.getObservedCaller(), method);
        }
    }

    @Override
    public void addCallerListener(CallerListener<Unit, SootMethod> listener) {
        for (Unit unit : this.precomputedGraph.getCallersOf(listener.getObservedCallee())) {
            listener.onCallerAdded(unit, listener.getObservedCallee());
        }
    }

    @Override
    public Collection<Unit> getAllPrecomputedCallers(SootMethod sootMethod) {
        for (Unit u : this.precomputedGraph.getCallersOf(sootMethod)) {
            this.unbalancedMethods.add(this.getMethodOf(u));
        }
        return this.precomputedGraph.getCallersOf(sootMethod);
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod sootMethod) {
        return this.precomputedGraph.getCallsFromWithin(sootMethod);
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod sootMethod) {
        return this.precomputedGraph.getStartPointsOf(sootMethod);
    }

    @Override
    public boolean isCallStmt(Unit stmt) {
        return this.precomputedGraph.isCallStmt(stmt);
    }

    @Override
    public boolean isExitStmt(Unit stmt) {
        return this.precomputedGraph.isExitStmt(stmt);
    }

    @Override
    public boolean isStartPoint(Unit stmt) {
        return this.precomputedGraph.isStartPoint(stmt);
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        return this.precomputedGraph.allNonCallStartNodes();
    }

    @Override
    public Collection<Unit> getEndPointsOf(SootMethod sootMethod) {
        return this.precomputedGraph.getEndPointsOf(sootMethod);
    }

    @Override
    public Set<Unit> allNonCallEndNodes() {
        return this.precomputedGraph.allNonCallEndNodes();
    }

    @Override
    public List<Value> getParameterRefs(SootMethod sootMethod) {
        return this.precomputedGraph.getParameterRefs(sootMethod);
    }

    @Override
    public boolean isReachable(Unit u) {
        return this.precomputedGraph.isReachable(u);
    }

    @Override
    public CallGraph getCallGraphCopy() {
        CallGraph copy = new CallGraph();
        HashSet<SootMethod> visited = new HashSet<SootMethod>();
        for (SootMethod entryPoint : Scene.v().getEntryPoints()) {
            if (visited.contains(entryPoint)) continue;
            this.addEdgesForCallees(entryPoint, visited, copy);
        }
        return copy;
    }

    private void addEdgesForCallees(SootMethod sootMethod, HashSet<SootMethod> visited, CallGraph copy) {
        visited.add(sootMethod);
        for (Unit callsite : this.precomputedGraph.getCallsFromWithin(sootMethod)) {
            for (SootMethod callee : this.precomputedGraph.getCalleesOfCallAt(callsite)) {
                copy.addEdge(new Edge(sootMethod, (Stmt)callsite, callee));
                if (visited.contains(callee)) continue;
                this.addEdgesForCallees(callee, visited, copy);
            }
        }
    }

    @Override
    public boolean isUnbalancedMethod(SootMethod method) {
        return this.unbalancedMethods.contains(method);
    }

    @Override
    public void addUnbalancedMethod(SootMethod method) {
        this.unbalancedMethods.add(method);
    }

    @Override
    public int getNumberOfEdgesTakenFromPrecomputedGraph() {
        return -1;
    }

    @Override
    public void resetCallGraph() {
    }
}

