/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BoomerangOptions;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.stats.IBoomerangStats;
import boomerang.stats.SimpleBoomerangStats;
import com.google.common.base.Optional;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class DefaultBoomerangOptions
implements BoomerangOptions {
    @Override
    public boolean isAllocationVal(Value val) {
        if (!this.trackStrings() && this.isStringAllocationType(val.getType())) {
            return false;
        }
        if (this.trackNullAssignments() && val instanceof NullConstant) {
            return true;
        }
        if (this.arrayFlows() && this.isArrayAllocationVal(val)) {
            return true;
        }
        if (this.trackStrings() && val instanceof StringConstant) {
            return true;
        }
        if (!this.trackAnySubclassOfThrowable() && this.isThrowableAllocationType(val.getType())) {
            return false;
        }
        return val instanceof NewExpr;
    }

    protected boolean isThrowableAllocationType(Type type) {
        return Scene.v().getOrMakeFastHierarchy().canStoreType(type, Scene.v().getType("java.lang.Throwable"));
    }

    protected boolean isStringAllocationType(Type type) {
        return type.toString().equals("java.lang.String") || type.toString().equals("java.lang.StringBuilder") || type.toString().equals("java.lang.StringBuffer");
    }

    protected boolean isArrayAllocationVal(Value val) {
        if (val instanceof NewArrayExpr) {
            NewArrayExpr expr = (NewArrayExpr)val;
            return expr.getBaseType() instanceof RefType;
        }
        return val instanceof NewMultiArrayExpr;
    }

    @Override
    public boolean staticFlows() {
        return true;
    }

    @Override
    public boolean arrayFlows() {
        return true;
    }

    @Override
    public boolean typeCheck() {
        return true;
    }

    @Override
    public boolean trackReturnOfInstanceOf() {
        return false;
    }

    @Override
    public boolean onTheFlyCallGraph() {
        return true;
    }

    @Override
    public boolean throwFlows() {
        return false;
    }

    @Override
    public boolean callSummaries() {
        return false;
    }

    @Override
    public boolean fieldSummaries() {
        return false;
    }

    public boolean trackAnySubclassOfThrowable() {
        return false;
    }

    public boolean trackStrings() {
        return false;
    }

    public boolean trackNullAssignments() {
        return false;
    }

    @Override
    public boolean isIgnoredMethod(SootMethod method) {
        return this.trackAnySubclassOfThrowable() && Scene.v().getFastHierarchy().canStoreType(method.getDeclaringClass().getType(), Scene.v().getType("java.lang.Throwable"));
    }

    @Override
    public Optional<AllocVal> getAllocationVal(SootMethod m4, Stmt stmt, Val fact, ObservableICFG<Unit, SootMethod> icfg) {
        if (!(stmt instanceof AssignStmt)) {
            return Optional.absent();
        }
        AssignStmt as = (AssignStmt)stmt;
        if (!as.getLeftOp().equals(fact.value())) {
            return Optional.absent();
        }
        if (this.isAllocationVal(as.getRightOp())) {
            return Optional.of(new AllocVal(as.getLeftOp(), m4, as.getRightOp(), new Statement(stmt, m4)));
        }
        if (as.containsInvokeExpr()) {
            AtomicReference<AllocVal> returnValue = new AtomicReference<AllocVal>();
            icfg.addCalleeListener(new AllocationValCalleeListener(returnValue, as, icfg, m4));
            if (returnValue.get() != null) {
                return Optional.of(returnValue.get());
            }
        }
        return Optional.absent();
    }

    @Override
    public int analysisTimeoutMS() {
        return 60000;
    }

    @Override
    public IBoomerangStats statsFactory() {
        return new SimpleBoomerangStats();
    }

    @Override
    public boolean aliasing() {
        return true;
    }

    @Override
    public boolean killNullAtCast() {
        return false;
    }

    @Override
    public boolean trackStaticFieldAtEntryPointToClinit() {
        return false;
    }

    @Override
    public boolean trackFields() {
        return true;
    }

    protected class AllocationValCalleeListener
    implements CalleeListener<Unit, SootMethod> {
        AtomicReference<AllocVal> returnValue;
        AssignStmt as;
        ObservableICFG<Unit, SootMethod> icfg;
        SootMethod m;

        AllocationValCalleeListener(AtomicReference<AllocVal> returnValue, AssignStmt as, ObservableICFG<Unit, SootMethod> icfg, SootMethod m4) {
            this.returnValue = returnValue;
            this.as = as;
            this.icfg = icfg;
            this.m = m4;
        }

        @Override
        public Unit getObservedCaller() {
            return this.as;
        }

        @Override
        public void onCalleeAdded(Unit unit, SootMethod sootMethod) {
            for (Unit u : this.icfg.getEndPointsOf(sootMethod)) {
                if (!(u instanceof ReturnStmt) || !DefaultBoomerangOptions.this.isAllocationVal(((ReturnStmt)u).getOp())) continue;
                this.returnValue.set(new AllocVal(this.as.getLeftOp(), this.m, ((ReturnStmt)u).getOp(), new Statement((Stmt)u, this.m)));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllocationValCalleeListener that = (AllocationValCalleeListener)o;
            return Objects.equals(this.returnValue, that.returnValue) && Objects.equals(this.as, that.as) && Objects.equals(this.m, that.m);
        }

        public int hashCode() {
            return Objects.hash(this.returnValue, this.as, this.m);
        }
    }
}

