/*
 * Decompiled with CFR 0.152.
 */
package wpds.interfaces;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.LinkedList;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.ReachabilityListener;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public class ForwardDFSVisitor<N extends Location, D extends State, W extends Weight>
implements WPAUpdateListener<N, D, W> {
    private Multimap<D, ReachabilityListener<N, D>> listeners = HashMultimap.create();
    protected WeightedPAutomaton<N, D, W> aut;
    private Multimap<D, D> adjacent = HashMultimap.create();
    private Multimap<D, D> reaches = HashMultimap.create();
    private Multimap<D, D> inverseReaches = HashMultimap.create();
    private Table<D, D, Integer> refCount = HashBasedTable.create();

    public ForwardDFSVisitor(WeightedPAutomaton<N, D, W> aut) {
        this.aut = aut;
    }

    public void registerListener(D state, ReachabilityListener<N, D> l) {
        if (this.listeners.put(state, l)) {
            for (State d : Lists.newArrayList(this.inverseReaches.get(state))) {
                this.aut.registerListener(new TransitiveClosure(this, d, state, l));
            }
        }
    }

    protected boolean continueWith(Transition<N, D> t) {
        return true;
    }

    @Override
    public void onWeightAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
        Object a = t.getStart();
        Object b = t.getTarget();
        this.inverseReaches(a, a);
        if (!this.continueWith(t)) {
            return;
        }
        this.insertEdge(a, b);
    }

    private void insertEdge(D a, D b) {
        LinkedList<Edge> worklist = Lists.newLinkedList();
        if (this.refCount.get(a, b) == null) {
            this.makeClosure(a, b);
            worklist.add(new Edge(this, (State)a, (State)b));
            this.refCount.put(a, b, 1);
        }
        this.makeEdge(a, b);
        for (State x : Lists.newArrayList(this.reaches.get(a))) {
            if (this.refCount.get(x, b) != null) continue;
            this.makeClosure(x, b);
            worklist.add(new Edge(this, x, (State)b));
            this.refCount.put(x, b, 1);
        }
        while (!worklist.isEmpty()) {
            State x;
            Edge e = (Edge)worklist.poll();
            x = e.from;
            Object y = e.to;
            for (State z : Lists.newArrayList(this.adjacent.get(y))) {
                if (this.refCount.get(x, z) != null) continue;
                this.makeClosure(x, z);
                worklist.add(new Edge(this, x, z));
                this.refCount.put(x, z, 1);
            }
        }
    }

    private void makeEdge(D from, D to) {
        this.adjacent.put(from, to);
        this.inverseReaches(from, to);
    }

    private void inverseReaches(D from, D to) {
        if (this.inverseReaches.put(from, to)) {
            for (ReachabilityListener<N, D> l : Lists.newArrayList(this.listeners.get(from))) {
                this.aut.registerListener(new TransitiveClosure(this, to, from, l));
            }
        }
    }

    private void makeClosure(D from, D to) {
        if (this.reaches.put(to, from)) {
            this.inverseReaches(from, to);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aut == null ? 0 : this.aut.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForwardDFSVisitor other = (ForwardDFSVisitor)obj;
        return !(this.aut == null ? other.aut != null : !this.aut.equals(other.aut));
    }

    private static class Edge {
        final D from;
        final D to;
        final /* synthetic */ ForwardDFSVisitor this$0;

        private Edge(D from, D to) {
            this.this$0 = var1_1;
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }

    private class Index {
        int refcount;

        private Index() {
        }
    }

    private static class TransitiveClosure
    extends WPAStateListener<N, D, W> {
        private ReachabilityListener<N, D> listener;
        private D s;
        final /* synthetic */ ForwardDFSVisitor this$0;

        public TransitiveClosure(D state, D s2, ReachabilityListener<N, D> l) {
            this.this$0 = var1_1;
            super(state);
            this.s = s2;
            this.listener = l;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
            this.listener.reachable(t);
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransitiveClosure other = (TransitiveClosure)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.s == null ? other.s != null : !this.s.equals(other.s)) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }

        private ForwardDFSVisitor getOuterType() {
            return this.this$0;
        }
    }
}

