/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pathexpression.Edge;
import pathexpression.IRegEx;
import pathexpression.LabeledGraph;
import pathexpression.PathExpressionComputer;
import pathexpression.RegEx;
import wpds.impl.ConnectPushListener;
import wpds.impl.NestedAutomatonListener;
import wpds.impl.Transition;
import wpds.impl.UnbalancedPopListener;
import wpds.impl.Weight;
import wpds.interfaces.ForwardDFSEpsilonVisitor;
import wpds.interfaces.ForwardDFSVisitor;
import wpds.interfaces.Location;
import wpds.interfaces.ReachabilityListener;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class WeightedPAutomaton<N extends Location, D extends State, W extends Weight>
implements LabeledGraph<D, N> {
    private Map<Transition<N, D>, W> transitionToWeights = new HashMap<Transition<N, D>, W>();
    protected Set<Transition<N, D>> transitions = Sets.newHashSet();
    protected Set<D> finalState = Sets.newHashSet();
    protected final D initialState;
    protected Set<D> states = Sets.newHashSet();
    private final Multimap<D, Transition<N, D>> transitionsOutOf = HashMultimap.create();
    private final Multimap<D, Transition<N, D>> transitionsInto = HashMultimap.create();
    private Set<WPAUpdateListener<N, D, W>> listeners = Sets.newHashSet();
    private Multimap<D, WPAStateListener<N, D, W>> stateListeners = HashMultimap.create();
    private Map<D, ForwardDFSVisitor<N, D, W>> stateToDFS = Maps.newHashMap();
    private Map<D, ForwardDFSVisitor<N, D, W>> stateToEpsilonDFS = Maps.newHashMap();
    private Set<WeightedPAutomaton<N, D, W>> nestedAutomatons = Sets.newHashSet();
    private Set<NestedAutomatonListener<N, D, W>> nestedAutomataListeners = Sets.newHashSet();
    private Map<D, ReachabilityListener<N, D>> stateToEpsilonReachabilityListener = Maps.newHashMap();
    private Map<D, ReachabilityListener<N, D>> stateToReachabilityListener = Maps.newHashMap();
    private Set<ReturnSiteWithWeights> connectedPushes = Sets.newHashSet();
    private Set<ConnectPushListener<N, D, W>> conntectedPushListeners = Sets.newHashSet();
    private Set<UnbalancedPopListener<N, D, W>> unbalancedPopListeners = Sets.newHashSet();
    private Map<UnbalancedPopEntry, W> unbalancedPops = Maps.newHashMap();
    private Map<Transition<N, D>, W> transitionsToFinalWeights = Maps.newHashMap();
    private ForwardDFSVisitor<N, D, W> dfsVisitor;
    private ForwardDFSVisitor<N, D, W> dfsEpsVisitor;
    public int failedAdditions;
    public int failedDirectAdditions;
    private WeightedPAutomaton<N, D, W> initialAutomaton;
    private PathExpressionComputer<D, N> pathExpressionComputer;
    protected Set<D> unbalancedStates = Sets.newHashSet();
    private int lastStates = 0;
    private static int count = 0;

    public WeightedPAutomaton(D initialState) {
        this.initialState = initialState;
        this.unbalancedStates.add(initialState);
    }

    public abstract D createState(D var1, N var2);

    public abstract boolean isGeneratedState(D var1);

    public Collection<Transition<N, D>> getTransitions() {
        return Lists.newArrayList(this.transitions);
    }

    public boolean addTransition(Transition<N, D> trans) {
        boolean addWeightForTransition = this.addWeightForTransition(trans, this.getOne());
        if (!addWeightForTransition) {
            ++this.failedDirectAdditions;
        }
        return addWeightForTransition;
    }

    public D getInitialState() {
        return this.initialState;
    }

    public Set<D> getFinalState() {
        return this.finalState;
    }

    public String toString() {
        String s2 = "PAutomaton\n";
        s2 = s2 + "\tInitialStates:" + this.initialState + "\n";
        s2 = s2 + "\tFinalStates:" + this.finalState + "\n";
        s2 = s2 + "\tWeightToTransitions:\n\t\t";
        s2 = s2 + Joiner.on("\n\t\t").join(this.transitionToWeights.entrySet());
        for (WeightedPAutomaton<N, D, W> nested : this.nestedAutomatons) {
            s2 = s2 + "\n";
            s2 = s2 + nested.toString();
        }
        return s2;
    }

    private String wrapIfInitialOrFinalState(D s2) {
        return s2.equals(this.initialState) ? "ENTRY: " + this.wrapFinalState(s2) : this.wrapFinalState(s2);
    }

    private String wrapFinalState(D s2) {
        return this.finalState.contains(s2) ? "TO: " + s2 + "" : s2.toString();
    }

    public String toDotString() {
        return this.toDotString(Sets.newHashSet());
    }

    private String toDotString(Set<WeightedPAutomaton<N, D, W>> visited) {
        if (!visited.add(this)) {
            return "NESTED loop: " + this.getInitialState();
        }
        String s2 = "digraph {\n";
        TreeSet<String> trans = new TreeSet<String>();
        for (State state : this.states) {
            Collection<Transition<N, D>> collection = this.transitionsOutOf.get(state);
            for (State target : this.states) {
                LinkedList<String> labels = Lists.newLinkedList();
                for (Transition<N, D> t : collection) {
                    if (!t.getTarget().equals(target)) continue;
                    labels.add(this.escapeQuotes(t.getString().toString()) + " W: " + this.transitionToWeights.get(t));
                }
                if (labels.isEmpty()) continue;
                String v = "\t\"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(state)) + "\"";
                v = v + " -> \"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(target)) + "\"";
                v = v + "[label=\"" + Joiner.on("\\n").join(labels) + "\"];\n";
                trans.add(v);
            }
        }
        s2 = s2 + Joiner.on("").join(trans);
        s2 = s2 + "}\n";
        s2 = s2 + "Transitions: " + this.transitions.size() + " Nested: " + this.nestedAutomatons.size() + "\n";
        for (WeightedPAutomaton weightedPAutomaton : this.nestedAutomatons) {
            s2 = s2 + "NESTED -> \n";
            s2 = s2 + weightedPAutomaton.toDotString(visited);
        }
        s2 = s2 + "End nesting\n";
        return s2;
    }

    private String escapeQuotes(String string) {
        return string.replace("\"", "");
    }

    /*
     * WARNING - void declaration
     */
    public String toLabelGroupedDotString() {
        HashBasedTable groupedByTargetAndLabel = HashBasedTable.create();
        for (Transition<N, D> t : this.transitions) {
            void var4_4;
            Collection collection = (Collection)groupedByTargetAndLabel.get(t.getTarget(), t.getLabel());
            if (collection == null) {
                HashSet hashSet = Sets.newHashSet();
            }
            var4_4.add(t.getStart());
            groupedByTargetAndLabel.put(t.getTarget(), t.getLabel(), (Object)var4_4);
        }
        String s2 = "digraph {\n";
        for (State state : groupedByTargetAndLabel.rowKeySet()) {
            for (Location label : groupedByTargetAndLabel.columnKeySet()) {
                Collection source = (Collection)groupedByTargetAndLabel.get(state, label);
                if (source == null) continue;
                s2 = s2 + "\t\"" + Joiner.on("\\n").join(source) + "\"";
                s2 = s2 + " -> \"" + this.wrapIfInitialOrFinalState(state) + "\"";
                s2 = s2 + "[label=\"" + label + "\"];\n";
            }
        }
        s2 = s2 + "}\n";
        s2 = s2 + "Transitions: " + this.transitions.size() + "\n";
        for (WeightedPAutomaton weightedPAutomaton : this.nestedAutomatons) {
            s2 = s2 + "NESTED -> \n";
            s2 = s2 + weightedPAutomaton.toDotString();
        }
        return s2;
    }

    public abstract N epsilon();

    public IRegEx<N> extractLanguage(D from) {
        PathExpressionComputer expr = new PathExpressionComputer(this);
        IRegEx res = null;
        for (State finalState : this.getFinalState()) {
            IRegEx regEx = expr.getExpressionBetween((State)from, finalState);
            if (res == null) {
                res = regEx;
                continue;
            }
            res = RegEx.union(res, regEx);
        }
        if (res == null) {
            return new RegEx.EmptySet();
        }
        return res;
    }

    public IRegEx<N> extractLanguage(D from, D to) {
        PathExpressionComputer expr = new PathExpressionComputer(this);
        IRegEx res = expr.getExpressionBetween(from, to);
        if (res == null) {
            return new RegEx.EmptySet();
        }
        return res;
    }

    public Set<D> getStates() {
        return this.states;
    }

    @Override
    public Set<Edge<D, N>> getEdges() {
        HashSet<Edge<D, N>> trans = Sets.newHashSet();
        for (Edge edge : this.transitions) {
            if (((Location)edge.getLabel()).equals(this.epsilon())) continue;
            trans.add(new Transition<Location, State>((State)edge.getTarget(), (Location)edge.getLabel(), (State)edge.getStart()));
        }
        return trans;
    }

    @Override
    public Set<D> getNodes() {
        return this.getStates();
    }

    public boolean addWeightForTransition(Transition<N, D> trans, W weight) {
        W newWeight;
        if (weight == null) {
            throw new IllegalArgumentException("Weight must not be null!");
        }
        if (trans.getStart().equals(trans.getTarget()) && trans.getLabel().equals(this.epsilon())) {
            ++this.failedAdditions;
            return false;
        }
        this.transitionsOutOf.get(trans.getStart()).add(trans);
        this.transitionsInto.get(trans.getTarget()).add(trans);
        this.states.add(trans.getTarget());
        this.states.add(trans.getStart());
        boolean added = this.transitions.add(trans);
        Weight oldWeight = (Weight)this.transitionToWeights.get(trans);
        Object object = newWeight = oldWeight == null ? weight : oldWeight.combineWith((Weight)weight);
        if (!newWeight.equals(oldWeight)) {
            this.transitionToWeights.put(trans, newWeight);
            for (WPAUpdateListener<N, D, W> wPAUpdateListener : Lists.newArrayList(this.listeners)) {
                wPAUpdateListener.onWeightAdded(trans, newWeight, this);
            }
            for (WPAStateListener wPAStateListener : Lists.newArrayList(this.stateListeners.get(trans.getStart()))) {
                wPAStateListener.onOutTransitionAdded(trans, newWeight, this);
            }
            for (WPAStateListener wPAStateListener : Lists.newArrayList(this.stateListeners.get(trans.getTarget()))) {
                wPAStateListener.onInTransitionAdded(trans, newWeight, this);
            }
            return true;
        }
        if (!added) {
            ++this.failedAdditions;
        }
        return added;
    }

    public W getWeightFor(Transition<N, D> trans) {
        return (W)((Weight)this.transitionToWeights.get(trans));
    }

    public void registerListener(WPAUpdateListener<N, D, W> listener) {
        if (!this.listeners.add(listener)) {
            return;
        }
        for (Map.Entry<Transition<N, D>, W> entry : Lists.newArrayList(this.transitionToWeights.entrySet())) {
            listener.onWeightAdded(entry.getKey(), (Weight)entry.getValue(), this);
        }
        for (WeightedPAutomaton weightedPAutomaton : Lists.newArrayList(this.nestedAutomatons)) {
            weightedPAutomaton.registerListener(listener);
        }
    }

    private void increaseListenerCount(WPAStateListener<N, D, W> l) {
        if (++count % 100000 == 0) {
            this.onManyStateListenerRegister();
        }
    }

    public void onManyStateListenerRegister() {
    }

    public void registerListener(WPAStateListener<N, D, W> l) {
        if (!this.stateListeners.put(l.getState(), l)) {
            return;
        }
        this.increaseListenerCount(l);
        for (Transition<N, D> transition : Lists.newArrayList(this.transitionsOutOf.get(l.getState()))) {
            l.onOutTransitionAdded(transition, (Weight)this.transitionToWeights.get(transition), this);
        }
        for (Transition<N, D> transition : Lists.newArrayList(this.transitionsInto.get(l.getState()))) {
            l.onInTransitionAdded(transition, (Weight)this.transitionToWeights.get(transition), this);
        }
        for (WeightedPAutomaton weightedPAutomaton : Lists.newArrayList(this.nestedAutomatons)) {
            weightedPAutomaton.registerListener(l);
        }
    }

    public void addFinalState(D state) {
        this.finalState.add(state);
    }

    public void registerDFSListener(D state, ReachabilityListener<N, D> l) {
        this.stateToReachabilityListener.put(state, l);
        if (this.dfsVisitor == null) {
            this.dfsVisitor = new ForwardDFSVisitor(this);
            this.registerListener(this.dfsVisitor);
        }
        this.dfsVisitor.registerListener(state, l);
    }

    protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToDFS() {
        return this.stateToDFS;
    }

    public void registerDFSEpsilonListener(D state, ReachabilityListener<N, D> l) {
        this.stateToEpsilonReachabilityListener.put(state, l);
        if (this.dfsEpsVisitor == null) {
            this.dfsEpsVisitor = new ForwardDFSEpsilonVisitor(this);
            this.registerListener(this.dfsEpsVisitor);
        }
        for (WeightedPAutomaton weightedPAutomaton : Lists.newLinkedList(this.nestedAutomatons)) {
            weightedPAutomaton.registerDFSEpsilonListener(state, l);
        }
        this.dfsEpsVisitor.registerListener(state, l);
    }

    protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToEpsilonDFS() {
        return this.stateToEpsilonDFS;
    }

    public abstract W getZero();

    public abstract W getOne();

    public WeightedPAutomaton<N, D, W> createNestedAutomaton(D initialState) {
        WeightedPAutomaton nested = new WeightedPAutomaton<N, D, W>((State)initialState){

            @Override
            public D createState(D d, N loc) {
                return WeightedPAutomaton.this.createState(d, loc);
            }

            @Override
            public N epsilon() {
                return WeightedPAutomaton.this.epsilon();
            }

            @Override
            public W getZero() {
                return WeightedPAutomaton.this.getZero();
            }

            @Override
            public W getOne() {
                return WeightedPAutomaton.this.getOne();
            }

            @Override
            public boolean isGeneratedState(D d) {
                return WeightedPAutomaton.this.isGeneratedState(d);
            }

            @Override
            protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToDFS() {
                return WeightedPAutomaton.this.stateToDFS;
            }

            @Override
            protected Map<D, ForwardDFSVisitor<N, D, W>> getStateToEpsilonDFS() {
                return WeightedPAutomaton.this.stateToEpsilonDFS;
            }

            @Override
            public boolean nested() {
                return true;
            }

            @Override
            public String toString() {
                return "NESTED: \n" + super.toString();
            }
        };
        this.addNestedAutomaton(nested);
        return nested;
    }

    public void reconnectPush(N callSite, N returnSite, D returnedFact, W returnedWeight) {
        ReturnSiteWithWeights returnSiteWithWeights = new ReturnSiteWithWeights(this, callSite, returnSite, returnedFact, returnedWeight);
        if (this.connectedPushes.add(returnSiteWithWeights)) {
            for (ConnectPushListener<Location, State, Weight> connectPushListener : Lists.newArrayList(this.conntectedPushListeners)) {
                connectPushListener.connect(returnSiteWithWeights.callSite, returnSiteWithWeights.returnSite, returnSiteWithWeights.returnedFact, returnSiteWithWeights.returnedWeight);
            }
        }
    }

    public void registerConnectPushListener(ConnectPushListener<N, D, W> l) {
        if (this.conntectedPushListeners.add(l)) {
            for (ReturnSiteWithWeights e : Lists.newArrayList(this.connectedPushes)) {
                l.connect(e.callSite, e.returnSite, e.returnedFact, e.returnedWeight);
            }
        }
    }

    public void registerUnbalancedPopListener(UnbalancedPopListener<N, D, W> l) {
        if (this.unbalancedPopListeners.add(l)) {
            for (Map.Entry<UnbalancedPopEntry, W> e : Lists.newArrayList(this.unbalancedPops.entrySet())) {
                UnbalancedPopEntry t = e.getKey();
                l.unbalancedPop(t.targetState, t.trans, (Weight)e.getValue());
            }
        }
    }

    public void unbalancedPop(D targetState, Transition<N, D> trans, W weight) {
        W newVal;
        UnbalancedPopEntry t = new UnbalancedPopEntry(this, targetState, trans);
        Weight oldVal = (Weight)this.unbalancedPops.get(t);
        Object object = newVal = oldVal == null ? weight : oldVal.combineWith((Weight)weight);
        if (!newVal.equals(oldVal)) {
            this.unbalancedPops.put(t, newVal);
            for (UnbalancedPopListener<N, D, W> l : Lists.newArrayList(this.unbalancedPopListeners)) {
                l.unbalancedPop(targetState, trans, newVal);
            }
        }
    }

    public Map<Transition<N, D>, W> getTransitionsToFinalWeights() {
        for (State s2 : this.unbalancedStates) {
            this.registerListener(new ValueComputationListener(this, s2, this.getOne()));
        }
        return this.transitionsToFinalWeights;
    }

    public boolean nested() {
        return false;
    }

    public void addNestedAutomaton(WeightedPAutomaton<N, D, W> nested) {
        if (!this.nestedAutomatons.add(nested)) {
            return;
        }
        for (WPAStateListener<N, D, W> wPAStateListener : Lists.newArrayList(this.stateListeners.values())) {
            nested.registerListener(wPAStateListener);
        }
        for (WPAUpdateListener wPAUpdateListener : Lists.newArrayList(this.listeners)) {
            nested.registerListener(wPAUpdateListener);
        }
        for (ConnectPushListener connectPushListener : Lists.newArrayList(this.conntectedPushListeners)) {
            nested.registerConnectPushListener(connectPushListener);
        }
        for (UnbalancedPopListener unbalancedPopListener : Lists.newArrayList(this.unbalancedPopListeners)) {
            nested.registerUnbalancedPopListener(unbalancedPopListener);
        }
        for (Map.Entry entry : Lists.newArrayList(this.stateToEpsilonReachabilityListener.entrySet())) {
            nested.registerDFSEpsilonListener((State)entry.getKey(), (ReachabilityListener)entry.getValue());
        }
        for (Map.Entry entry : Lists.newArrayList(this.stateToReachabilityListener.entrySet())) {
            nested.registerDFSListener((State)entry.getKey(), (ReachabilityListener)entry.getValue());
        }
        for (Map.Entry entry : Lists.newArrayList(this.stateToReachabilityListener.entrySet())) {
            nested.registerDFSListener((State)entry.getKey(), (ReachabilityListener)entry.getValue());
        }
        for (NestedAutomatonListener nestedAutomatonListener : Lists.newArrayList(this.nestedAutomataListeners)) {
            nestedAutomatonListener.nestedAutomaton(this, nested);
            nested.registerNestedAutomatonListener(nestedAutomatonListener);
        }
    }

    public void registerNestedAutomatonListener(NestedAutomatonListener<N, D, W> l) {
        if (!this.nestedAutomataListeners.add(l)) {
            return;
        }
        for (WeightedPAutomaton<N, D, W> nested : Lists.newArrayList(this.nestedAutomatons)) {
            l.nestedAutomaton(this, nested);
        }
    }

    public void setInitialAutomaton(WeightedPAutomaton<N, D, W> aut) {
        this.initialAutomaton = aut;
    }

    public boolean isInitialAutomaton(WeightedPAutomaton<N, D, W> aut) {
        return this.initialAutomaton.equals(aut);
    }

    public IRegEx<N> toRegEx(D start, D end) {
        if (this.lastStates < this.states.size()) {
            this.pathExpressionComputer = new PathExpressionComputer(this);
            this.lastStates = this.states.size();
        }
        return RegEx.reverse(this.pathExpressionComputer.getExpressionBetween(end, start));
    }

    public boolean containsLoop() {
        HashSet<State> visited = Sets.newHashSet();
        LinkedList<Object> worklist = Lists.newLinkedList();
        worklist.add(this.initialState);
        while (!worklist.isEmpty()) {
            State pop = (State)worklist.pop();
            visited.add(pop);
            Collection<Transition<N, D>> inTrans = this.transitionsInto.get(pop);
            for (Transition<N, D> t : inTrans) {
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(t.getStart())) continue;
                if (visited.contains(t.getStart())) {
                    return true;
                }
                worklist.add(t.getStart());
            }
        }
        return false;
    }

    public Set<N> getLongestPath() {
        LinkedList<Object> worklist = Lists.newLinkedList();
        worklist.add(this.initialState);
        HashMap pathReachingD = Maps.newHashMap();
        while (!worklist.isEmpty()) {
            State pop = (State)worklist.pop();
            Set<N> atCurr = this.getOrCreate(pathReachingD, pop);
            Collection<Transition<N, D>> inTrans = this.transitionsInto.get(pop);
            for (Transition<N, D> t : inTrans) {
                boolean addAll;
                Object next;
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(next = t.getStart()) || next.equals(pop)) continue;
                Set<N> atNext = this.getOrCreate(pathReachingD, next);
                HashSet<N> newAtCurr = Sets.newHashSet(atCurr);
                if (!newAtCurr.add(t.getLabel()) || !(addAll = atNext.addAll(newAtCurr))) continue;
                worklist.add(next);
            }
        }
        Set longest = Sets.newHashSet();
        for (Set l : pathReachingD.values()) {
            if (longest.size() >= l.size()) continue;
            longest = l;
        }
        return longest;
    }

    private Set<N> getOrCreate(Map<D, Set<N>> pathReachingD, D pop) {
        Set<N> collection = pathReachingD.get(pop);
        if (collection == null) {
            collection = Sets.newHashSet();
            pathReachingD.put(pop, collection);
        }
        return collection;
    }

    public boolean isUnbalancedState(D target) {
        return this.unbalancedStates.contains(target);
    }

    public void addUnbalancedState(D state) {
        this.unbalancedStates.add(state);
    }

    public void clearListener() {
        this.conntectedPushListeners.clear();
        this.nestedAutomataListeners.clear();
        this.stateListeners.clear();
        this.listeners.clear();
        this.stateToEpsilonReachabilityListener.clear();
        this.stateToReachabilityListener.clear();
        this.unbalancedPopListeners.clear();
    }

    private static class ValueComputationListener
    extends WPAStateListener<N, D, W> {
        private W weight;
        final /* synthetic */ WeightedPAutomaton this$0;

        public ValueComputationListener(D state, W weight) {
            this.this$0 = var1_1;
            super(state);
            this.weight = weight;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> aut) {
            Weight newWeight = ((Weight)this.weight).extendWith((Weight)w);
            Weight weightAtTarget = (Weight)this.this$0.transitionsToFinalWeights.get(t);
            Weight newVal = weightAtTarget == null ? newWeight : weightAtTarget.combineWith(newWeight);
            this.this$0.transitionsToFinalWeights.put(t, newVal);
            if (this.this$0.isGeneratedState(t.getStart())) {
                this.this$0.registerListener(new ValueComputationListener(this.this$0, (State)t.getStart(), newVal));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueComputationListener other = (ValueComputationListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }

    private static class ReturnSiteWithWeights {
        private final N returnSite;
        private final W returnedWeight;
        private final D returnedFact;
        private final N callSite;
        final /* synthetic */ WeightedPAutomaton this$0;

        public ReturnSiteWithWeights(N callSite, N returnSite, D returnedFact, W returnedWeight) {
            this.this$0 = var1_1;
            this.callSite = callSite;
            this.returnSite = returnSite;
            this.returnedFact = returnedFact;
            this.returnedWeight = returnedWeight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.returnSite == null ? 0 : this.returnSite.hashCode());
            result = 31 * result + (this.returnedFact == null ? 0 : this.returnedFact.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnSiteWithWeights other = (ReturnSiteWithWeights)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            if (this.returnSite == null ? other.returnSite != null : !this.returnSite.equals(other.returnSite)) {
                return false;
            }
            if (this.returnedFact == null ? other.returnedFact != null : !this.returnedFact.equals(other.returnedFact)) {
                return false;
            }
            return !(this.returnedWeight == null ? other.returnedWeight != null : !this.returnedWeight.equals(other.returnedWeight));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }

    private static class UnbalancedPopEntry {
        private final Transition<N, D> trans;
        private final D targetState;
        final /* synthetic */ WeightedPAutomaton this$0;

        public UnbalancedPopEntry(D targetState, Transition<N, D> trans) {
            this.this$0 = var1_1;
            this.targetState = targetState;
            this.trans = trans;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.targetState == null ? 0 : this.targetState.hashCode());
            result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedPopEntry other = (UnbalancedPopEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.targetState == null ? other.targetState != null : !this.targetState.equals(other.targetState)) {
                return false;
            }
            return !(this.trans == null ? other.trans != null : !this.trans.equals(other.trans));
        }

        private WeightedPAutomaton getOuterType() {
            return this.this$0;
        }
    }
}

