/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import pathexpression.Edge;
import wpds.impl.Configuration;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.wildcard.Wildcard;

public class Transition<N extends Location, D extends State>
implements Edge<D, N> {
    private final D s1;
    private final N l1;
    private final D s2;
    private int hashCode;

    public Transition(D s1, N l1, D s2) {
        assert (s1 != null);
        assert (s2 != null);
        assert (l1 != null);
        this.s1 = s1;
        this.l1 = l1;
        this.s2 = s2;
        if (l1 instanceof Wildcard) {
            throw new RuntimeException("No wildcards allowed!");
        }
    }

    public Configuration<N, D> getStartConfig() {
        return new Configuration<N, D>(this.l1, this.s1);
    }

    @Override
    public D getTarget() {
        return this.s2;
    }

    @Override
    public D getStart() {
        return this.s1;
    }

    public N getString() {
        return this.l1;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.l1 == null ? 0 : this.l1.hashCode());
        result = 31 * result + (this.s1 == null ? 0 : this.s1.hashCode());
        this.hashCode = result = 31 * result + (this.s2 == null ? 0 : this.s2.hashCode());
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        if (this.l1 == null ? other.l1 != null : !this.l1.equals(other.l1)) {
            return false;
        }
        if (this.s1 == null ? other.s1 != null : !this.s1.equals(other.s1)) {
            return false;
        }
        return !(this.s2 == null ? other.s2 != null : !this.s2.equals(other.s2));
    }

    public String toString() {
        return this.s1 + "~" + this.l1 + "~>" + this.s2;
    }

    @Override
    public N getLabel() {
        return this.l1;
    }
}

