/*
 * Decompiled with CFR 0.152.
 */
package wpds.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;

public abstract class StackListener<N extends Location, D extends State, W extends Weight>
extends WPAStateListener<N, D, W> {
    private final WeightedPAutomaton<N, D, W> aut;
    private N source;
    private Set<N> notifiedStacks = Sets.newHashSet();

    public StackListener(WeightedPAutomaton<N, D, W> weightedPAutomaton, D state, N source) {
        super(state);
        this.aut = weightedPAutomaton;
        this.source = source;
    }

    @Override
    public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> weightedPAutomaton) {
        if (t.getLabel().equals(this.aut.epsilon())) {
            return;
        }
        if (this.aut.isGeneratedState(t.getTarget())) {
            this.aut.registerListener(new SubStackListener(this, (State)t.getTarget(), this));
        }
        if (this.aut.initialState.equals(t.getTarget()) && t.getLabel().equals(this.source)) {
            this.anyContext(this.source);
        }
    }

    @Override
    public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> weightedPAutomaton) {
    }

    public abstract void stackElement(N var1);

    public abstract void anyContext(N var1);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackListener other = (StackListener)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    private static class SubStackListener
    extends WPAStateListener<N, D, W> {
        private StackListener parent;
        final /* synthetic */ StackListener this$0;

        public SubStackListener(D state, StackListener parent) {
            this.this$0 = var1_1;
            super(state);
            this.parent = parent;
        }

        @Override
        public void onOutTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> weightedPAutomaton) {
            if (t.getLabel().equals(this.this$0.aut.epsilon())) {
                return;
            }
            this.stackElement(t.getLabel());
            if (this.this$0.aut.isGeneratedState(t.getTarget()) && !t.getTarget().equals(t.getStart())) {
                this.this$0.aut.registerListener(new SubStackListener(this.this$0, (State)t.getTarget(), this.parent));
            }
        }

        @Override
        public void onInTransitionAdded(Transition<N, D> t, W w, WeightedPAutomaton<N, D, W> weightedPAutomaton) {
        }

        public void stackElement(N parent) {
            if (this.this$0.notifiedStacks.add(parent)) {
                this.this$0.stackElement(parent);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubStackListener other = (SubStackListener)obj;
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }
    }
}

