/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines.alloc;

import boomerang.WeightedForwardQuery;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class PrintStreamStateMachine
extends TypeStateMachineWeightFunctions {
    public PrintStreamStateMachine() {
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.OPEN, this.readMethods(), MatcherTransition.Parameter.This, (State)States.OPEN, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.OPEN, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
    }

    private Set<SootMethod> closeMethods() {
        return this.selectMethodByName(this.getSubclassesOf("java.io.PrintStream"), "close");
    }

    private Set<SootMethod> readMethods() {
        List<SootClass> subclasses = this.getSubclassesOf("java.io.PrintStream");
        Set<SootMethod> closeMethods = this.closeMethods();
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m3 : c.getMethods()) {
                if (!m3.isPublic() || closeMethods.contains(m3) || m3.isStatic() || m3.isConstructor()) continue;
                out.add(m3);
            }
        }
        return out;
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod m3, Unit unit) {
        return this.generateAtAllocationSiteOf(m3, unit, PrintStream.class);
    }

    @Override
    protected State initialState() {
        return States.OPEN;
    }

    public static enum States implements State
    {
        OPEN,
        CLOSED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR || this == OPEN;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

