/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines.alloc;

import boomerang.WeightedForwardQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class InputStreamStateMachine
extends TypeStateMachineWeightFunctions {
    public InputStreamStateMachine() {
        this.addTransition(new MatcherTransition((State)States.OPEN, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.OPEN, this.readMethods(), MatcherTransition.Parameter.This, (State)States.OPEN, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.nativeReadMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.nativeReadMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.OPEN, this.nativeReadMethods(), MatcherTransition.Parameter.This, (State)States.OPEN, MatcherTransition.Type.OnCallToReturn));
    }

    private Set<SootMethod> nativeReadMethods() {
        List<SootClass> subclasses = this.getSubclassesOf("java.io.InputStream");
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m3 : c.getMethods()) {
                if (!m3.isNative() || !m3.toString().contains("read()")) continue;
                out.add(m3);
            }
        }
        return out;
    }

    private Set<SootMethod> constructors() {
        List<SootClass> subclasses = this.getSubclassesOf("java.io.InputStream");
        HashSet<SootMethod> out = new HashSet<SootMethod>();
        for (SootClass c : subclasses) {
            for (SootMethod m3 : c.getMethods()) {
                if (!m3.isConstructor()) continue;
                out.add(m3);
            }
        }
        return out;
    }

    private Set<SootMethod> closeMethods() {
        return this.selectMethodByName(this.getImplementersOf("java.io.InputStream"), "close");
    }

    private Set<SootMethod> readMethods() {
        return this.selectMethodByName(this.getImplementersOf("java.io.InputStream"), "read");
    }

    private List<SootClass> getImplementersOf(String className) {
        SootClass sootClass = Scene.v().getSootClass(className);
        List<SootClass> list = Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass);
        LinkedList<SootClass> res = new LinkedList<SootClass>();
        for (SootClass c : list) {
            res.add(c);
        }
        return res;
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod method, Unit unit) {
        return this.generateThisAtAnyCallSitesOf(method, unit, this.closeMethods());
    }

    @Override
    protected State initialState() {
        return States.CLOSED;
    }

    public static enum States implements State
    {
        OPEN,
        CLOSED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

