/*
 * Decompiled with CFR 0.152.
 */
package typestate.impl.statemachines;

import boomerang.WeightedForwardQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.TypeStateMachineWeightFunctions;

public class InputStreamStateMachine
extends TypeStateMachineWeightFunctions {
    private Set<SootMethod> closeMethods;
    private Set<SootMethod> readMethods;

    public InputStreamStateMachine() {
        this.addTransition(new MatcherTransition((State)States.NONE, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.closeMethods(), MatcherTransition.Parameter.This, (State)States.CLOSED, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, this.readMethods(), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnReturn));
        this.addTransition(new MatcherTransition((State)States.CLOSED, Collections.singleton(Scene.v().getMethod("<java.io.InputStream: int read()>")), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
        this.addTransition(new MatcherTransition((State)States.ERROR, Collections.singleton(Scene.v().getMethod("<java.io.InputStream: int read()>")), MatcherTransition.Parameter.This, (State)States.ERROR, MatcherTransition.Type.OnCallToReturn));
    }

    private Set<SootMethod> closeMethods() {
        if (this.closeMethods == null) {
            this.closeMethods = this.selectMethodByName(this.getImplementersOf("java.io.InputStream"), "close");
        }
        return this.closeMethods;
    }

    private Set<SootMethod> readMethods() {
        if (this.readMethods == null) {
            this.readMethods = this.selectMethodByName(this.getImplementersOf("java.io.InputStream"), "read");
        }
        return this.readMethods;
    }

    private List<SootClass> getImplementersOf(String className) {
        SootClass sootClass = Scene.v().getSootClass(className);
        List<SootClass> list = Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass);
        LinkedList<SootClass> res = new LinkedList<SootClass>();
        for (SootClass c : list) {
            res.add(c);
        }
        return res;
    }

    @Override
    public Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod method, Unit unit) {
        return this.generateThisAtAnyCallSitesOf(method, unit, this.closeMethods());
    }

    @Override
    public State initialState() {
        return States.NONE;
    }

    public static enum States implements State
    {
        NONE,
        CLOSED,
        ERROR;


        @Override
        public boolean isErrorState() {
            return this == ERROR;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isAccepting() {
            return false;
        }
    }
}

