/*
 * Decompiled with CFR 0.152.
 */
package typestate.finiteautomata;

import boomerang.WeightedForwardQuery;
import boomerang.jimple.AllocVal;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.Node;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;
import typestate.finiteautomata.Transition;

public abstract class TypeStateMachineWeightFunctions
implements WeightFunctions<Statement, Val, Statement, TransitionFunction> {
    public Set<MatcherTransition> transition = new HashSet<MatcherTransition>();

    public void addTransition(MatcherTransition trans) {
        this.transition.add(trans);
    }

    @Override
    public TransitionFunction getOne() {
        return TransitionFunction.one();
    }

    @Override
    public TransitionFunction getZero() {
        return TransitionFunction.zero();
    }

    @Override
    public TransitionFunction pop(Node<Statement, Val> curr, Statement returnSite) {
        return this.getMatchingTransitions(curr.stmt(), curr.fact(), returnSite, Collections2.filter(this.transition, new Predicate<MatcherTransition>(){

            @Override
            public boolean apply(MatcherTransition input) {
                return input.getType().equals((Object)MatcherTransition.Type.OnReturn);
            }
        }));
    }

    @Override
    public TransitionFunction push(Node<Statement, Val> curr, Node<Statement, Val> succ, Statement push) {
        return this.getMatchingTransitions(succ.stmt(), succ.fact(), curr.stmt(), Collections2.filter(this.transition, new Predicate<MatcherTransition>(){

            @Override
            public boolean apply(MatcherTransition input) {
                return input.getType().equals((Object)MatcherTransition.Type.OnCall) || input.getType().equals((Object)MatcherTransition.Type.OnCallOrOnCallToReturn);
            }
        }));
    }

    @Override
    public TransitionFunction normal(Node<Statement, Val> curr, Node<Statement, Val> succ) {
        if (succ.stmt().getUnit().isPresent() && succ.stmt().getUnit().get().containsInvokeExpr()) {
            return this.callToReturn(curr, succ, succ.stmt().getUnit().get().getInvokeExpr());
        }
        return this.getOne();
    }

    public TransitionFunction callToReturn(Node<Statement, Val> curr, Node<Statement, Val> succ, InvokeExpr invokeExpr) {
        HashSet<MatcherTransition> res = Sets.newHashSet();
        if (invokeExpr instanceof InstanceInvokeExpr) {
            SootMethod method = invokeExpr.getMethod();
            InstanceInvokeExpr e = (InstanceInvokeExpr)invokeExpr;
            if (e.getBase().equals(succ.fact().value())) {
                for (MatcherTransition trans : this.transition) {
                    if (!trans.matches(method) || !trans.getType().equals((Object)MatcherTransition.Type.OnCallToReturn) && !trans.getType().equals((Object)MatcherTransition.Type.OnCallOrOnCallToReturn)) continue;
                    res.add(trans);
                }
            }
        }
        return res.isEmpty() ? this.getOne() : new TransitionFunction(res, Collections.singleton(succ.stmt()));
    }

    private TransitionFunction getMatchingTransitions(Statement statement, Val node, Statement transitionStmt, Collection<MatcherTransition> filteredTrans) {
        HashSet<Transition> res = new HashSet<Transition>();
        for (MatcherTransition trans : filteredTrans) {
            if (!trans.matches(statement.getMethod())) continue;
            MatcherTransition.Parameter param = trans.getParam();
            if (param.equals((Object)MatcherTransition.Parameter.This) && this.isThisValue(statement.getMethod(), node)) {
                res.add(new Transition(trans.from(), trans.to()));
            }
            if (param.equals((Object)MatcherTransition.Parameter.Param1) && statement.getMethod().getActiveBody().getParameterLocal(0).equals(node.value())) {
                res.add(new Transition(trans.from(), trans.to()));
            }
            if (!param.equals((Object)MatcherTransition.Parameter.Param2) || !statement.getMethod().getActiveBody().getParameterLocal(1).equals(node.value())) continue;
            res.add(new Transition(trans.from(), trans.to()));
        }
        if (res.isEmpty()) {
            return this.getOne();
        }
        return new TransitionFunction(res, Collections.singleton(transitionStmt));
    }

    private boolean isThisValue(SootMethod method, Val node) {
        if (method.isStatic()) {
            return false;
        }
        if (!method.hasActiveBody()) {
            return false;
        }
        return method.getActiveBody().getThisLocal().equals(node.value());
    }

    protected Set<SootMethod> selectMethodByName(Collection<SootClass> classes, String pattern) {
        HashSet<SootMethod> res = new HashSet<SootMethod>();
        for (SootClass c : classes) {
            for (SootMethod m3 : c.getMethods()) {
                if (!Pattern.matches(pattern, m3.getName())) continue;
                res.add(m3);
            }
        }
        return res;
    }

    protected List<SootClass> getSubclassesOf(String className) {
        SootClass sootClass = Scene.v().getSootClass(className);
        List<SootClass> list = Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass);
        LinkedList<SootClass> res = new LinkedList<SootClass>();
        for (SootClass c : list) {
            res.add(c);
        }
        return res;
    }

    protected Collection<Val> generateAtConstructor(SootMethod m3, Unit unit, Collection<SootMethod> calledMethod, MatcherTransition initialTrans) {
        InstanceInvokeExpr iie;
        Stmt stmt;
        boolean matches = false;
        for (SootMethod method : calledMethod) {
            if (!initialTrans.matches(method)) continue;
            matches = true;
        }
        if (!matches) {
            return Collections.emptySet();
        }
        if (unit instanceof Stmt && (stmt = (Stmt)unit).containsInvokeExpr() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iie = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase() instanceof Local) {
            Local l = (Local)iie.getBase();
            HashSet<Val> out = new HashSet<Val>();
            out.add(new Val(l, m3));
            return out;
        }
        return Collections.emptySet();
    }

    protected Collection<WeightedForwardQuery<TransitionFunction>> getLeftSideOf(SootMethod m3, Unit unit) {
        if (unit instanceof AssignStmt) {
            AssignStmt stmt = (AssignStmt)unit;
            return Collections.singleton(new WeightedForwardQuery<TransitionFunction>(new Statement((Stmt)unit, m3), new AllocVal(stmt.getLeftOp(), m3, stmt.getRightOp(), new Statement((Stmt)unit, m3)), this.initialTransition()));
        }
        return Collections.emptySet();
    }

    protected Collection<WeightedForwardQuery<TransitionFunction>> generateThisAtAnyCallSitesOf(SootMethod m3, Unit unit, Collection<SootMethod> invokesMethod) {
        InstanceInvokeExpr iie;
        if (unit instanceof Stmt && ((Stmt)unit).containsInvokeExpr() && ((Stmt)unit).getInvokeExpr() instanceof InstanceInvokeExpr && invokesMethod.contains((iie = (InstanceInvokeExpr)((Stmt)unit).getInvokeExpr()).getMethod())) {
            Local thisLocal = (Local)iie.getBase();
            return Collections.singleton(new WeightedForwardQuery<TransitionFunction>(new Statement((Stmt)unit, m3), new AllocVal(thisLocal, m3, iie, new Statement((Stmt)unit, m3)), this.initialTransition()));
        }
        return Collections.emptySet();
    }

    protected Collection<WeightedForwardQuery<TransitionFunction>> generateAtAllocationSiteOf(SootMethod m3, Unit unit, Class allocationSuperType) {
        AssignStmt assignStmt;
        if (unit instanceof AssignStmt && (assignStmt = (AssignStmt)unit).getRightOp() instanceof NewExpr) {
            NewExpr newExpr = (NewExpr)assignStmt.getRightOp();
            Value leftOp = assignStmt.getLeftOp();
            Type type = newExpr.getType();
            if (Scene.v().getOrMakeFastHierarchy().canStoreType(type, Scene.v().getType(allocationSuperType.getName()))) {
                return Collections.singleton(new WeightedForwardQuery<TransitionFunction>(new Statement((Stmt)unit, m3), new AllocVal(leftOp, m3, assignStmt.getRightOp(), new Statement((Stmt)unit, m3)), this.initialTransition()));
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return Joiner.on("\n").join(this.transition);
    }

    public abstract Collection<WeightedForwardQuery<TransitionFunction>> generateSeed(SootMethod var1, Unit var2);

    public TransitionFunction initialTransition() {
        return new TransitionFunction(new Transition(this.initialState(), this.initialState()), Collections.emptySet());
    }

    protected abstract State initialState();
}

