/*
 * Decompiled with CFR 0.152.
 */
package typestate;

import boomerang.jimple.Statement;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import typestate.finiteautomata.ITransition;
import typestate.finiteautomata.Transition;
import wpds.impl.Weight;

public class TransitionFunction
extends Weight {
    private final Set<ITransition> value;
    private final String rep;
    private static TransitionFunction one;
    private static TransitionFunction zero;
    private Set<Statement> stateChangeStatements;

    public TransitionFunction(Set<? extends ITransition> trans, Set<Statement> stateChangeStatements) {
        this.stateChangeStatements = stateChangeStatements;
        this.value = new HashSet<ITransition>(trans);
        this.rep = null;
    }

    public TransitionFunction(ITransition trans, Set<Statement> stateChangeStatements) {
        this(new HashSet<ITransition>(Collections.singleton(trans)), stateChangeStatements);
    }

    private TransitionFunction(String rep) {
        this.value = Sets.newHashSet();
        this.rep = rep;
        this.stateChangeStatements = Sets.newHashSet();
    }

    public Collection<ITransition> values() {
        return Lists.newArrayList(this.value);
    }

    public Set<Statement> getLastStateChangeStatements() {
        return this.stateChangeStatements;
    }

    @Override
    public Weight extendWith(Weight other) {
        if (other.equals(TransitionFunction.one())) {
            return this;
        }
        if (this.equals(TransitionFunction.one())) {
            return other;
        }
        if (other.equals(TransitionFunction.zero()) || this.equals(TransitionFunction.zero())) {
            return TransitionFunction.zero();
        }
        TransitionFunction func = (TransitionFunction)other;
        Set<ITransition> otherTransitions = func.value;
        HashSet<ITransition> ress = new HashSet<ITransition>();
        HashSet<Statement> newStateChangeStatements = new HashSet<Statement>();
        for (ITransition first : this.value) {
            for (ITransition second : otherTransitions) {
                if (second.equals(Transition.identity())) {
                    ress.add(first);
                    newStateChangeStatements.addAll(this.stateChangeStatements);
                    continue;
                }
                if (first.equals(Transition.identity())) {
                    ress.add(second);
                    newStateChangeStatements.addAll(func.stateChangeStatements);
                    continue;
                }
                if (!first.to().equals(second.from())) continue;
                ress.add(new Transition(first.from(), second.to()));
                newStateChangeStatements.addAll(func.stateChangeStatements);
            }
        }
        return new TransitionFunction(ress, newStateChangeStatements);
    }

    @Override
    public Weight combineWith(Weight other) {
        if (!(other instanceof TransitionFunction)) {
            throw new RuntimeException();
        }
        if (this.equals(TransitionFunction.zero())) {
            return other;
        }
        if (other.equals(TransitionFunction.zero())) {
            return this;
        }
        if (other.equals(TransitionFunction.one()) && this.equals(TransitionFunction.one())) {
            return TransitionFunction.one();
        }
        TransitionFunction func = (TransitionFunction)other;
        if (other.equals(TransitionFunction.one()) || this.equals(TransitionFunction.one())) {
            HashSet<ITransition> transitions = new HashSet<ITransition>(other.equals(TransitionFunction.one()) ? this.value : func.value);
            HashSet<Transition> idTransitions = Sets.newHashSet();
            for (ITransition t : transitions) {
                idTransitions.add(new Transition(t.from(), t.from()));
            }
            transitions.addAll(idTransitions);
            return new TransitionFunction(transitions, Sets.newHashSet(other.equals(TransitionFunction.one()) ? this.stateChangeStatements : func.stateChangeStatements));
        }
        HashSet<ITransition> transitions = new HashSet<ITransition>(func.value);
        transitions.addAll(this.value);
        HashSet<Statement> newStateChangeStmts = Sets.newHashSet(this.stateChangeStatements);
        newStateChangeStmts.addAll(func.stateChangeStatements);
        return new TransitionFunction(transitions, newStateChangeStmts);
    }

    public static TransitionFunction one() {
        if (one == null) {
            one = new TransitionFunction("ONE");
        }
        return one;
    }

    public static TransitionFunction zero() {
        if (zero == null) {
            zero = new TransitionFunction("ZERO");
        }
        return zero;
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return "Weight: " + this.value.toString() + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransitionFunction other = (TransitionFunction)obj;
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

