/*
 * Decompiled with CFR 0.152.
 */
package test.core.selfrunning;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import soot.ArrayType;
import soot.G;
import soot.Local;
import soot.PackManager;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.options.Options;
import test.core.selfrunning.ImprecisionException;

public abstract class AbstractTestingFramework {
    @Rule
    public TestName testMethodName = new TestName();
    protected SootMethod sootTestMethod;
    protected File ideVizFile;
    protected File dotFile;

    @Before
    public void beforeTestCaseExecution() {
        this.initializeSootWithEntryPoint();
        this.createDebugFiles();
        try {
            this.analyze();
        }
        catch (ImprecisionException e) {
            Assert.fail(e.getMessage());
        }
        Assume.assumeTrue(false);
    }

    private void createDebugFiles() {
        this.ideVizFile = new File("target/IDEViz/" + this.getTestCaseClassName() + "/IDEViz-" + this.testMethodName.getMethodName() + ".json");
        if (!this.ideVizFile.getParentFile().exists()) {
            try {
                Files.createDirectories(this.ideVizFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Was not able to create directories for IDEViz output!");
            }
        }
        this.dotFile = new File("target/dot/" + this.getTestCaseClassName() + "/Dot-" + this.testMethodName.getMethodName() + ".dot");
        if (!this.dotFile.getParentFile().exists()) {
            try {
                Files.createDirectories(this.dotFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Was not able to create directories for dot output!");
            }
        }
    }

    private void analyze() {
        Transform transform = new Transform("wjtp.ifds", this.createAnalysisTransformer());
        PackManager.v().getPack("wjtp").add(transform);
        PackManager.v().getPack("cg").apply();
        PackManager.v().getPack("wjtp").apply();
    }

    protected abstract SceneTransformer createAnalysisTransformer();

    private void initializeSootWithEntryPoint() {
        G.v();
        G.reset();
        Options.v().set_whole_program(true);
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("cg.spark", "verbose:true");
        Options.v().set_output_format(12);
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_include(this.getIncludeList());
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().set_exclude(this.excludedPackages());
        if (AbstractTestingFramework.getJavaVersion() < 9) {
            Options.v().set_prepend_classpath(true);
            Options.v().set_soot_classpath(this.getSootClassPath());
        } else if (AbstractTestingFramework.getJavaVersion() >= 9) {
            Options.v().set_soot_classpath("VIRTUAL_FS_FOR_JDK" + File.pathSeparator + this.getSootClassPath());
        }
        SootClass sootTestCaseClass = Scene.v().forceResolve(this.getTestCaseClassName(), 3);
        for (SootMethod m3 : sootTestCaseClass.getMethods()) {
            if (!m3.getName().equals(this.testMethodName.getMethodName())) continue;
            this.sootTestMethod = m3;
        }
        if (this.sootTestMethod == null) {
            throw new RuntimeException("The method with name " + this.testMethodName.getMethodName() + " was not found in the Soot Scene.");
        }
        this.sootTestMethod.getDeclaringClass().setApplicationClass();
        Scene.v().addBasicClass(this.getTargetClass(), 3);
        Scene.v().loadNecessaryClasses();
        SootClass c = Scene.v().forceResolve(this.getTargetClass(), 3);
        if (c != null) {
            c.setApplicationClass();
        }
        SootMethod methodByName = c.getMethodByName("main");
        LinkedList<SootMethod> ePoints = new LinkedList<SootMethod>();
        for (SootMethod m4 : sootTestCaseClass.getMethods()) {
            if (!m4.isStaticInitializer()) continue;
            ePoints.add(m4);
        }
        for (SootClass inner : Scene.v().getClasses()) {
            if (!inner.getName().contains(sootTestCaseClass.getName())) continue;
            inner.setApplicationClass();
            for (SootMethod m5 : inner.getMethods()) {
                if (!m5.isStaticInitializer()) continue;
                ePoints.add(m5);
            }
        }
        ePoints.add(methodByName);
        Scene.v().setEntryPoints(ePoints);
    }

    protected String getSootClassPath() {
        String userdir = System.getProperty("user.dir");
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.equals("")) {
            throw new RuntimeException("Could not get property java.home!");
        }
        String sootCp = userdir + "/target/test-classes";
        if (AbstractTestingFramework.getJavaVersion() < 9) {
            sootCp = sootCp + File.pathSeparator + javaHome + "/lib/rt.jar";
            sootCp = sootCp + File.pathSeparator + javaHome + "/lib/jce.jar";
        }
        return sootCp;
    }

    protected List<String> getIncludeList() {
        LinkedList<String> includeList = new LinkedList<String>();
        includeList.add("java.lang.*");
        includeList.add("java.util.*");
        includeList.add("java.io.*");
        includeList.add("sun.misc.*");
        includeList.add("java.net.*");
        includeList.add("sun.nio.*");
        includeList.add("javax.servlet.*");
        return includeList;
    }

    private String getTargetClass() {
        SootClass sootClass = new SootClass("dummyClass");
        ArrayType paramType = ArrayType.v(RefType.v("java.lang.String"), 1);
        SootMethod mainMethod = new SootMethod("main", Collections.singletonList(paramType), VoidType.v(), 9);
        sootClass.addMethod(mainMethod);
        JimpleBody body = Jimple.v().newBody(mainMethod);
        mainMethod.setActiveBody(body);
        RefType testCaseType = RefType.v(this.getTestCaseClassName());
        Local loc = Jimple.v().newLocal("l0", paramType);
        body.getLocals().add(loc);
        body.getUnits().add(Jimple.v().newIdentityStmt(loc, Jimple.v().newParameterRef(paramType, 0)));
        Local allocatedTestObj = Jimple.v().newLocal("dummyObj", testCaseType);
        body.getLocals().add(allocatedTestObj);
        body.getUnits().add(Jimple.v().newAssignStmt(allocatedTestObj, Jimple.v().newNewExpr(testCaseType)));
        body.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(allocatedTestObj, this.sootTestMethod.makeRef())));
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        Scene.v().addClass(sootClass);
        body.validate();
        return sootClass.toString();
    }

    private String getTestCaseClassName() {
        return this.getClass().getName().replace("class ", "");
    }

    public List<String> excludedPackages() {
        LinkedList<String> excludedPackages = new LinkedList<String>();
        excludedPackages.add("sun.*");
        excludedPackages.add("javax.*");
        excludedPackages.add("com.sun.*");
        excludedPackages.add("com.ibm.*");
        excludedPackages.add("org.xml.*");
        excludedPackages.add("org.w3c.*");
        excludedPackages.add("apple.awt.*");
        excludedPackages.add("com.apple.*");
        return excludedPackages;
    }

    protected boolean staticallyUnknown() {
        return true;
    }

    private static int getJavaVersion() {
        String version2 = System.getProperty("java.version");
        if (version2.startsWith("1.")) {
            version2 = version2.substring(2, 3);
        } else {
            int dot = version2.indexOf(".");
            if (dot != -1) {
                version2 = version2.substring(0, dot);
            }
        }
        return Integer.parseInt(version2);
    }
}

