/*
 * Decompiled with CFR 0.152.
 */
package sync.pds.weights;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;
import wpds.interfaces.Location;

public class SetDomain<N, Stmt, Fact>
extends Weight {
    private static SetDomain one;
    private static SetDomain zero;
    private final String rep;
    private Collection<Node<Stmt, Fact>> nodes;

    private SetDomain(String rep) {
        this.rep = rep;
    }

    private SetDomain(Collection<Node<Stmt, Fact>> nodes) {
        this.nodes = nodes;
        this.rep = null;
    }

    public SetDomain(Node<Stmt, Fact> node) {
        this.nodes = Sets.newHashSet(node);
        this.rep = null;
    }

    @Override
    public Weight extendWith(Weight other) {
        if (other.equals(SetDomain.one())) {
            return this;
        }
        if (this.equals(SetDomain.one())) {
            return other;
        }
        return SetDomain.zero();
    }

    @Override
    public Weight combineWith(Weight other) {
        if (other.equals(SetDomain.zero())) {
            return this;
        }
        if (this.equals(SetDomain.zero())) {
            return other;
        }
        if (this.equals(SetDomain.one()) || other.equals(SetDomain.one())) {
            return SetDomain.one();
        }
        if (other instanceof SetDomain) {
            HashSet<Node<Stmt, Fact>> merged = Sets.newHashSet(this.nodes);
            merged.addAll(((SetDomain)other).nodes);
            return new SetDomain<N, Stmt, Fact>(merged);
        }
        return SetDomain.zero();
    }

    public static <N extends Location, Stmt, Fact> SetDomain<N, Stmt, Fact> one() {
        if (one == null) {
            one = new SetDomain<N, Stmt, Fact>("<1>");
        }
        return one;
    }

    public static <N extends Location, Stmt, Fact> SetDomain<N, Stmt, Fact> zero() {
        if (zero == null) {
            zero = new SetDomain<N, Stmt, Fact>("<0>");
        }
        return zero;
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return this.nodes.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetDomain other = (SetDomain)obj;
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public Collection<Node<Stmt, Fact>> elements() {
        return Sets.newHashSet(this.nodes);
    }
}

