/*
 * Decompiled with CFR 0.152.
 */
package sync.pds.solver;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.EmptyStackWitnessListener;
import sync.pds.solver.SyncPDSUpdateListener;
import sync.pds.solver.SyncStatePDSUpdateListener;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.WitnessListener;
import sync.pds.solver.nodes.CallPopNode;
import sync.pds.solver.nodes.ExclusionNode;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.NodeWithLocation;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedAutomatonListener;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.NormalRule;
import wpds.impl.PopRule;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.impl.WeightedPushdownSystem;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class SyncPDSSolver<Stmt extends Location, Fact, Field extends Location, W extends Weight> {
    private static final Logger logger = LoggerFactory.getLogger(SyncPDSSolver.class);
    private static final boolean FieldSensitive = true;
    private static final boolean ContextSensitive = true;
    protected final WeightedPushdownSystem<Stmt, INode<Fact>, W> callingPDS = new WeightedPushdownSystem<Stmt, INode<Fact>, W>(){

        @Override
        public String toString() {
            return "Call " + SyncPDSSolver.this.toString();
        }
    };
    protected final WeightedPushdownSystem<Field, INode<Node<Stmt, Fact>>, W> fieldPDS = new WeightedPushdownSystem<Field, INode<Node<Stmt, Fact>>, W>(){

        @Override
        public String toString() {
            return "Field " + SyncPDSSolver.this.toString();
        }
    };
    private final Set<Node<Stmt, Fact>> reachedStates = Sets.newHashSet();
    private final Set<Node<Stmt, Fact>> callingContextReachable = Sets.newHashSet();
    private final Set<Node<Stmt, Fact>> fieldContextReachable = Sets.newHashSet();
    private final Set<SyncPDSUpdateListener<Stmt, Fact>> updateListeners = Sets.newHashSet();
    private final Multimap<Node<Stmt, Fact>, SyncStatePDSUpdateListener<Stmt, Fact>> reachedStateUpdateListeners = HashMultimap.create();
    protected final WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> fieldAutomaton;
    protected final WeightedPAutomaton<Stmt, INode<Fact>, W> callAutomaton;
    protected Map<Map.Entry<INode<Fact>, Stmt>, INode<Fact>> generatedCallState = Maps.newHashMap();
    Map<Map.Entry<INode<Node<Stmt, Fact>>, Field>, INode<Node<Stmt, Fact>>> generatedFieldState = Maps.newHashMap();

    protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<Stmt, Fact>>> trans, W weight) {
        return false;
    }

    protected boolean preventCallTransitionAdd(Transition<Stmt, INode<Fact>> trans, W weight) {
        return false;
    }

    public SyncPDSSolver(INode<Fact> initialCallNode, INode<Node<Stmt, Fact>> initialFieldNode, final boolean useCallSummaries, NestedWeightedPAutomatons<Stmt, INode<Fact>, W> callSummaries, final boolean useFieldSummaries, NestedWeightedPAutomatons<Field, INode<Node<Stmt, Fact>>, W> fieldSummaries) {
        this.fieldAutomaton = new WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W>(initialFieldNode){

            @Override
            public INode<Node<Stmt, Fact>> createState(INode<Node<Stmt, Fact>> d, Field loc) {
                if (loc.equals(SyncPDSSolver.this.emptyField())) {
                    return d;
                }
                return SyncPDSSolver.this.generateFieldState(d, loc);
            }

            @Override
            public Field epsilon() {
                return SyncPDSSolver.this.epsilonField();
            }

            @Override
            public boolean nested() {
                return useFieldSummaries;
            }

            @Override
            public W getZero() {
                return SyncPDSSolver.this.getFieldWeights().getZero();
            }

            @Override
            public W getOne() {
                return SyncPDSSolver.this.getFieldWeights().getOne();
            }

            @Override
            public boolean addWeightForTransition(Transition<Field, INode<Node<Stmt, Fact>>> trans, W weight) {
                if (SyncPDSSolver.this.preventFieldTransitionAdd(trans, weight)) {
                    return false;
                }
                logger.trace("Adding field transition {} with weight {}", (Object)trans, weight);
                return super.addWeightForTransition(trans, weight);
            }

            @Override
            public boolean isGeneratedState(INode<Node<Stmt, Fact>> d) {
                return d instanceof GeneratedState;
            }

            @Override
            public void onManyStateListenerRegister() {
                SyncPDSSolver.this.onManyStateListenerRegister();
            }
        };
        this.callAutomaton = new WeightedPAutomaton<Stmt, INode<Fact>, W>(initialCallNode){

            @Override
            public INode<Fact> createState(INode<Fact> d, Stmt loc) {
                return SyncPDSSolver.this.generateCallState(d, loc);
            }

            @Override
            public Stmt epsilon() {
                return SyncPDSSolver.this.epsilonStmt();
            }

            @Override
            public W getZero() {
                return SyncPDSSolver.this.getCallWeights().getZero();
            }

            @Override
            public boolean nested() {
                return useCallSummaries;
            }

            @Override
            public W getOne() {
                return SyncPDSSolver.this.getCallWeights().getOne();
            }

            @Override
            public boolean addWeightForTransition(Transition<Stmt, INode<Fact>> trans, W weight) {
                if (SyncPDSSolver.this.preventCallTransitionAdd(trans, weight)) {
                    return false;
                }
                logger.trace("Adding call transition {} with weight {}", (Object)trans, weight);
                return super.addWeightForTransition(trans, weight);
            }

            @Override
            public boolean isGeneratedState(INode<Fact> d) {
                return d instanceof GeneratedState;
            }
        };
        this.callAutomaton.registerListener(new CallAutomatonListener());
        this.fieldAutomaton.registerListener(new FieldUpdateListener());
        if (this.callAutomaton.nested()) {
            this.callAutomaton.registerNestedAutomatonListener(new CallSummaryListener());
        }
        this.callingPDS.poststar(this.callAutomaton, callSummaries);
        this.fieldPDS.poststar(this.fieldAutomaton, fieldSummaries);
    }

    protected void onManyStateListenerRegister() {
    }

    public void solve(Node<Stmt, Fact> curr, W weight) {
        INode<Node<Stmt, Fact>> start = this.asFieldFact(curr);
        INode<Node<Stmt, Fact>> target = this.fieldAutomaton.getInitialState();
        Transition<Field, INode<Node<Stmt, Fact>>> fieldTrans = new Transition<Field, INode<Node<Stmt, Fact>>>(start, this.emptyField(), target);
        this.fieldAutomaton.addTransition(fieldTrans);
        Transition<Stmt, INode<Fact>> callTrans = this.createInitialCallTransition(curr);
        this.callAutomaton.addWeightForTransition(callTrans, weight);
        this.processNode(curr);
    }

    public void solve(Node<Stmt, Fact> curr) {
        this.solve(curr, this.getCallWeights().getOne());
    }

    private Transition<Stmt, INode<Fact>> createInitialCallTransition(Node<Stmt, Fact> curr) {
        return new Transition<Location, INode<Fact>>(this.wrap(curr.fact()), (Location)curr.stmt(), this.callAutomaton.getInitialState());
    }

    protected void processNode(Node<Stmt, Fact> curr) {
        if (!this.addReachableState(curr)) {
            return;
        }
        this.computeSuccessor(curr);
    }

    protected void propagate(Node<Stmt, Fact> curr, State s2) {
        if (s2 instanceof Node) {
            Node succ = (Node)s2;
            if (succ instanceof PushNode) {
                PushNode pushNode = (PushNode)succ;
                PDSSystem system = pushNode.system();
                Location location = (Location)pushNode.location();
                this.processPush(curr, location, pushNode, system);
            } else {
                this.processNormal(curr, succ);
            }
        } else if (s2 instanceof PopNode) {
            PopNode popNode = (PopNode)s2;
            this.processPop(curr, popNode);
        }
    }

    private boolean addReachableState(Node<Stmt, Fact> curr) {
        if (this.reachedStates.contains(curr)) {
            return false;
        }
        this.reachedStates.add(curr);
        for (SyncPDSUpdateListener syncPDSUpdateListener : Lists.newLinkedList(this.updateListeners)) {
            syncPDSUpdateListener.onReachableNodeAdded(curr);
        }
        for (SyncStatePDSUpdateListener syncStatePDSUpdateListener : Lists.newLinkedList(this.reachedStateUpdateListeners.get(curr))) {
            syncStatePDSUpdateListener.reachable();
        }
        return true;
    }

    public void processNormal(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        this.addNormalFieldFlow(curr, succ);
        this.addNormalCallFlow(curr, succ);
    }

    public void addNormalCallFlow(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        this.addCallRule(new NormalRule<Location, INode<Fact>, W>(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(succ.fact()), (Location)succ.stmt(), this.getCallWeights().normal(curr, succ)));
    }

    public void synchedEmptyStackReachable(Node<Stmt, Fact> sourceNode, final EmptyStackWitnessListener<Stmt, Fact> listener) {
        this.synchedReachable(sourceNode, new WitnessListener<Stmt, Fact, Field>(){
            Multimap<Fact, Node<Stmt, Fact>> potentialFieldCandidate = HashMultimap.create();
            Set<Fact> potentialCallCandidate = Sets.newHashSet();

            @Override
            public void fieldWitness(Transition<Field, INode<Node<Stmt, Fact>>> t) {
                if (t.getTarget() instanceof GeneratedState) {
                    return;
                }
                if (!t.getLabel().equals(SyncPDSSolver.this.emptyField())) {
                    return;
                }
                Node targetFact = (Node)((INode)t.getTarget()).fact();
                if (!this.potentialFieldCandidate.put(targetFact.fact(), targetFact)) {
                    return;
                }
                if (this.potentialCallCandidate.contains(targetFact.fact())) {
                    listener.witnessFound(targetFact);
                }
            }

            @Override
            public void callWitness(Transition<Stmt, INode<Fact>> t) {
                if (t.getTarget() instanceof GeneratedState) {
                    return;
                }
                Object targetFact = ((INode)t.getTarget()).fact();
                if (!this.potentialCallCandidate.add(targetFact)) {
                    return;
                }
                if (this.potentialFieldCandidate.containsKey(targetFact)) {
                    for (Node w : this.potentialFieldCandidate.get(targetFact)) {
                        listener.witnessFound(w);
                    }
                }
            }
        });
    }

    public void synchedReachable(final Node<Stmt, Fact> sourceNode, final WitnessListener<Stmt, Fact, Field> listener) {
        this.registerListener(new SyncPDSUpdateListener<Stmt, Fact>(){

            @Override
            public void onReachableNodeAdded(Node<Stmt, Fact> reachableNode) {
                if (!reachableNode.equals(sourceNode)) {
                    return;
                }
                SyncPDSSolver.this.fieldAutomaton.registerListener(new WPAUpdateListener<Field, INode<Node<Stmt, Fact>>, W>(){

                    @Override
                    public void onWeightAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> aut) {
                        if (t.getStart() instanceof GeneratedState) {
                            return;
                        }
                        if (!((Node)((INode)t.getStart()).fact()).equals(sourceNode)) {
                            return;
                        }
                        listener.fieldWitness(t);
                    }
                });
                SyncPDSSolver.this.callAutomaton.registerListener(new WPAUpdateListener<Stmt, INode<Fact>, W>(){

                    @Override
                    public void onWeightAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> aut) {
                        if (t.getStart() instanceof GeneratedState) {
                            return;
                        }
                        if (!((INode)t.getStart()).fact().equals(sourceNode.fact())) {
                            return;
                        }
                        if (!t.getLabel().equals(sourceNode.stmt())) {
                            return;
                        }
                        listener.callWitness(t);
                    }
                });
            }
        });
    }

    public void addNormalFieldFlow(Node<Stmt, Fact> curr, Node<Stmt, Fact> succ) {
        if (succ instanceof ExclusionNode) {
            ExclusionNode exNode = (ExclusionNode)succ;
            this.addFieldRule(new NormalRule<Location, INode<Node<Stmt, Fact>>, W>(this.asFieldFact(curr), (Location)this.fieldWildCard(), this.asFieldFact(succ), this.exclusionFieldWildCard((Location)exNode.exclusion()), this.getFieldWeights().normal(curr, succ)));
            return;
        }
        this.addFieldRule(new NormalRule<Field, INode<Node<Stmt, Fact>>, W>(this.asFieldFact(curr), this.fieldWildCard(), this.asFieldFact(succ), this.fieldWildCard(), this.getFieldWeights().normal(curr, succ)));
    }

    public INode<Node<Stmt, Fact>> asFieldFact(Node<Stmt, Fact> node) {
        return new SingleNode<Node<Stmt, Fact>>(new Node<Stmt, Fact>(node.stmt(), node.fact()));
    }

    public void processPop(Node<Stmt, Fact> curr, PopNode popNode) {
        PDSSystem system = popNode.system();
        Object location = popNode.location();
        if (system.equals((Object)PDSSystem.FIELDS)) {
            NodeWithLocation node = (NodeWithLocation)location;
            this.addFieldRule(new PopRule<Location, INode<Node<Stmt, Fact>>, W>(this.asFieldFact(curr), (Location)node.location(), this.asFieldFact((Node<Stmt, Fact>)node.fact()), this.getFieldWeights().pop(curr, node.location())));
            this.addNormalCallFlow(curr, (Node<Stmt, Fact>)node.fact());
        } else if (system.equals((Object)PDSSystem.CALLS)) {
            CallPopNode callPopNode = (CallPopNode)popNode;
            Location returnSite = (Location)callPopNode.getReturnSite();
            this.addNormalFieldFlow(curr, new Node(returnSite, location));
            this.addCallRule(new PopRule(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(location), this.getCallWeights().pop(curr, returnSite)));
        }
    }

    public void processPush(Node<Stmt, Fact> curr, Location location, Node<Stmt, Fact> succ, PDSSystem system) {
        if (system.equals((Object)PDSSystem.FIELDS)) {
            if (!this.fieldContextReachable.contains(succ)) {
                this.addFieldRule(new PushRule<Location, INode<Node<Stmt, Fact>>, W>(this.asFieldFact(curr), (Location)this.fieldWildCard(), this.asFieldFact(succ), location, (Location)this.fieldWildCard(), this.getFieldWeights().push(curr, succ, location)));
            }
            this.addNormalCallFlow(curr, succ);
        } else if (system.equals((Object)PDSSystem.CALLS)) {
            this.addNormalFieldFlow(curr, succ);
            this.addCallRule(new PushRule<Location, INode<Fact>, W>(this.wrap(curr.fact()), (Location)curr.stmt(), this.wrap(succ.fact()), (Location)succ.stmt(), location, this.getCallWeights().push(curr, succ, location)));
        }
    }

    public void addCallRule(Rule<Stmt, INode<Fact>, W> rule) {
        this.callingPDS.addRule(rule);
    }

    public void addFieldRule(Rule<Field, INode<Node<Stmt, Fact>>, W> rule) {
        this.fieldPDS.addRule(rule);
    }

    protected abstract WeightFunctions<Stmt, Fact, Field, W> getFieldWeights();

    protected abstract WeightFunctions<Stmt, Fact, Stmt, W> getCallWeights();

    private void setCallingContextReachable(Node<Stmt, Fact> node) {
        if (!this.callingContextReachable.add(node)) {
            return;
        }
        if (this.fieldContextReachable.contains(node)) {
            this.processNode(node);
        }
    }

    private void setFieldContextReachable(Node<Stmt, Fact> node) {
        if (!this.fieldContextReachable.add(node)) {
            return;
        }
        if (this.callingContextReachable.contains(node)) {
            this.processNode(node);
        }
    }

    public void registerListener(SyncPDSUpdateListener<Stmt, Fact> listener) {
        if (!this.updateListeners.add(listener)) {
            return;
        }
        for (Node<Stmt, Fact> reachableNode : Lists.newArrayList(this.reachedStates)) {
            listener.onReachableNodeAdded(reachableNode);
        }
    }

    public void registerListener(SyncStatePDSUpdateListener<Stmt, Fact> listener) {
        if (!this.reachedStateUpdateListeners.put(listener.getNode(), listener)) {
            return;
        }
        if (this.reachedStates.contains(listener.getNode())) {
            listener.reachable();
        }
    }

    protected INode<Fact> wrap(Fact variable) {
        return new SingleNode<Fact>(variable);
    }

    public INode<Fact> generateCallState(INode<Fact> d, Stmt loc) {
        AbstractMap.SimpleEntry<INode<Fact>, Stmt> e = new AbstractMap.SimpleEntry<INode<Fact>, Stmt>(d, loc);
        if (!this.generatedCallState.containsKey(e)) {
            this.generatedCallState.put(e, new GeneratedState<Fact, Stmt>(d, loc));
        }
        return this.generatedCallState.get(e);
    }

    public INode<Node<Stmt, Fact>> generateFieldState(INode<Node<Stmt, Fact>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState<Node<Stmt, Fact>, Field>(d, loc));
        }
        return this.generatedFieldState.get(e);
    }

    public void addGeneratedFieldState(GeneratedState<Node<Stmt, Fact>, Field> state) {
        AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<Stmt, Fact>>, Field>(state.node(), state.location());
        this.generatedFieldState.put(e, state);
    }

    public abstract void computeSuccessor(Node<Stmt, Fact> var1);

    public abstract Field epsilonField();

    public abstract Field emptyField();

    public abstract Stmt epsilonStmt();

    public abstract Field exclusionFieldWildCard(Field var1);

    public abstract Field fieldWildCard();

    public Set<Node<Stmt, Fact>> getReachedStates() {
        return Sets.newHashSet(this.reachedStates);
    }

    public void debugOutput() {
        logger.debug(this.getClass().toString());
        logger.debug("All reachable states");
        this.prettyPrintSet(this.getReachedStates());
        HashSet<Node<Stmt, Fact>> notFieldReachable = Sets.newHashSet(this.callingContextReachable);
        notFieldReachable.removeAll(this.getReachedStates());
        HashSet<Node<Stmt, Fact>> notCallingContextReachable = Sets.newHashSet(this.fieldContextReachable);
        notCallingContextReachable.removeAll(this.getReachedStates());
        if (!notFieldReachable.isEmpty()) {
            logger.debug("Calling context reachable");
            this.prettyPrintSet(notFieldReachable);
        }
        if (!notCallingContextReachable.isEmpty()) {
            logger.debug("Field matching reachable");
            this.prettyPrintSet(notCallingContextReachable);
        }
        logger.debug(this.fieldPDS.toString());
        logger.debug(this.fieldAutomaton.toDotString());
        logger.debug(this.callingPDS.toString());
        logger.debug(this.callAutomaton.toDotString());
        logger.debug("===== end === " + this.getClass());
    }

    private void prettyPrintSet(Collection<? extends Object> set) {
        int j = 0;
        String s2 = "";
        for (Object object : set) {
            s2 = s2 + object;
            s2 = s2 + "\t";
            if (j++ <= 5) continue;
            s2 = s2 + "\n";
            j = 0;
        }
        logger.debug(s2);
    }

    private class FieldUpdateListener
    implements WPAUpdateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private FieldUpdateListener() {
        }

        @Override
        public void onWeightAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> aut) {
            INode n = (INode)t.getStart();
            if (!(n instanceof GeneratedState) && !t.getLabel().equals(SyncPDSSolver.this.fieldAutomaton.epsilon())) {
                Node fact = (Node)n.fact();
                Node node = new Node(fact.stmt(), fact.fact());
                SyncPDSSolver.this.setFieldContextReachable(node);
            }
        }
    }

    private class CallAutomatonListener
    implements WPAUpdateListener<Stmt, INode<Fact>, W> {
        private CallAutomatonListener() {
        }

        @Override
        public void onWeightAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> aut) {
            if (!(t.getStart() instanceof GeneratedState) && !t.getLabel().equals(SyncPDSSolver.this.callAutomaton.epsilon())) {
                Node node = new Node(t.getString(), ((INode)t.getStart()).fact());
                SyncPDSSolver.this.setCallingContextReachable(node);
            }
        }
    }

    private class OnOutTransitionAddToStateListener
    extends WPAStateListener<Stmt, INode<Fact>, W> {
        private Transition<Stmt, INode<Fact>> nestedT;

        public OnOutTransitionAddToStateListener(INode<Fact> state, Transition<Stmt, INode<Fact>> nestedT) {
            super(state);
            this.nestedT = nestedT;
        }

        @Override
        public void onOutTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
            Node returningNode = new Node(t.getLabel(), ((INode)this.nestedT.getStart()).fact());
            SyncPDSSolver.this.setCallingContextReachable(returningNode);
        }

        @Override
        public void onInTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nestedT == null ? 0 : this.nestedT.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OnOutTransitionAddToStateListener other = (OnOutTransitionAddToStateListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.nestedT == null ? other.nestedT != null : !this.nestedT.equals(other.nestedT));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class AddEpsilonToInitialStateListener
    extends WPAStateListener<Stmt, INode<Fact>, W> {
        private WeightedPAutomaton<Stmt, INode<Fact>, W> parent;

        public AddEpsilonToInitialStateListener(INode<Fact> state, WeightedPAutomaton<Stmt, INode<Fact>, W> parent) {
            super(state);
            this.parent = parent;
        }

        @Override
        public void onOutTransitionAdded(Transition<Stmt, INode<Fact>> t, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
        }

        @Override
        public void onInTransitionAdded(Transition<Stmt, INode<Fact>> nestedT, W w, WeightedPAutomaton<Stmt, INode<Fact>, W> weightedPAutomaton) {
            if (nestedT.getLabel().equals(SyncPDSSolver.this.callAutomaton.epsilon())) {
                this.parent.registerListener(new OnOutTransitionAddToStateListener((INode)this.getState(), nestedT));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddEpsilonToInitialStateListener other = (AddEpsilonToInitialStateListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class CallSummaryListener
    implements NestedAutomatonListener<Stmt, INode<Fact>, W> {
        private CallSummaryListener() {
        }

        @Override
        public void nestedAutomaton(WeightedPAutomaton<Stmt, INode<Fact>, W> parent, WeightedPAutomaton<Stmt, INode<Fact>, W> child) {
            child.registerListener(new AddEpsilonToInitialStateListener(child.getInitialState(), parent));
        }
    }

    private class FieldOnOutTransitionAddToStateListener
    extends WPAStateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private Transition<Field, INode<Node<Stmt, Fact>>> nestedT;

        public FieldOnOutTransitionAddToStateListener(INode<Node<Stmt, Fact>> state, Transition<Field, INode<Node<Stmt, Fact>>> nestedT) {
            super(state);
            this.nestedT = nestedT;
        }

        @Override
        public void onOutTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
            SyncPDSSolver.this.setFieldContextReachable((Node)((INode)this.nestedT.getStart()).fact());
        }

        @Override
        public void onInTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nestedT == null ? 0 : this.nestedT.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldOnOutTransitionAddToStateListener other = (FieldOnOutTransitionAddToStateListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.nestedT == null ? other.nestedT != null : !this.nestedT.equals(other.nestedT));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class FieldAddEpsilonToInitialStateListener
    extends WPAStateListener<Field, INode<Node<Stmt, Fact>>, W> {
        private WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent;

        public FieldAddEpsilonToInitialStateListener(INode<Node<Stmt, Fact>> state, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent) {
            super(state);
            this.parent = parent;
        }

        @Override
        public void onOutTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> t, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
        }

        @Override
        public void onInTransitionAdded(Transition<Field, INode<Node<Stmt, Fact>>> nestedT, W w, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> weightedPAutomaton) {
            if (nestedT.getLabel().equals(SyncPDSSolver.this.fieldAutomaton.epsilon())) {
                this.parent.registerListener(new FieldOnOutTransitionAddToStateListener((INode)this.getState(), nestedT));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldAddEpsilonToInitialStateListener other = (FieldAddEpsilonToInitialStateListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private SyncPDSSolver getOuterType() {
            return SyncPDSSolver.this;
        }
    }

    private class FieldSummaryListener
    implements NestedAutomatonListener<Field, INode<Node<Stmt, Fact>>, W> {
        private FieldSummaryListener() {
        }

        @Override
        public void nestedAutomaton(WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> parent, WeightedPAutomaton<Field, INode<Node<Stmt, Fact>>, W> child) {
            child.registerListener(new FieldAddEpsilonToInitialStateListener(child.getInitialState(), parent));
        }
    }

    public static enum PDSSystem {
        FIELDS,
        CALLS;

    }
}

