/*
 * Decompiled with CFR 0.152.
 */
package soot.util.backend;

import org.objectweb.asm.ClassWriter;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.util.backend.ASMBackendUtils;

public class SootASMClassWriter
extends ClassWriter {
    public SootASMClassWriter(int flags) {
        super(flags);
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Type mergedType;
        String typeName1 = type1.replace('/', '.');
        String typeName2 = type2.replace('/', '.');
        SootClass s1 = Scene.v().getSootClass(typeName1);
        SootClass s2 = Scene.v().getSootClass(typeName2);
        if (s1.isPhantom() || s2.isPhantom() || s1.resolvingLevel() == 0 || s2.resolvingLevel() == 0) {
            mergedType = Scene.v().getObjectType();
        } else {
            RefType t1 = s1.getType();
            RefType t2 = s2.getType();
            mergedType = ((Type)t1).merge(t2, Scene.v());
        }
        if (mergedType instanceof RefType) {
            return ASMBackendUtils.slashify(mergedType.getClassName());
        }
        throw new RuntimeException("Could not find common super class");
    }
}

