/*
 * Decompiled with CFR 0.152.
 */
package soot.util.backend;

import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassWriter;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethodRef;
import soot.Type;
import soot.TypeSwitch;
import soot.VoidType;
import soot.baf.DoubleWordType;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;

public class ASMBackendUtils {
    public static String slashify(String s2) {
        if (s2 == null) {
            return null;
        }
        return s2.replace('.', '/');
    }

    public static String toTypeDesc(SootMethodRef m3) {
        return ASMBackendUtils.toTypeDesc(m3.parameterTypes(), m3.returnType());
    }

    public static String toTypeDesc(List<Type> parameterTypes, Type returnType) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Type t : parameterTypes) {
            sb.append(ASMBackendUtils.toTypeDesc(t));
        }
        sb.append(')');
        sb.append(ASMBackendUtils.toTypeDesc(returnType));
        return sb.toString();
    }

    public static String toTypeDesc(Type type) {
        final StringBuilder sb = new StringBuilder(1);
        type.apply(new TypeSwitch(){

            @Override
            public void defaultCase(Type t) {
                throw new RuntimeException("Invalid type " + t.toString());
            }

            @Override
            public void caseDoubleType(DoubleType t) {
                sb.append('D');
            }

            @Override
            public void caseFloatType(FloatType t) {
                sb.append('F');
            }

            @Override
            public void caseIntType(IntType t) {
                sb.append('I');
            }

            @Override
            public void caseByteType(ByteType t) {
                sb.append('B');
            }

            @Override
            public void caseShortType(ShortType t) {
                sb.append('S');
            }

            @Override
            public void caseCharType(CharType t) {
                sb.append('C');
            }

            @Override
            public void caseBooleanType(BooleanType t) {
                sb.append('Z');
            }

            @Override
            public void caseLongType(LongType t) {
                sb.append('J');
            }

            @Override
            public void caseArrayType(ArrayType t) {
                sb.append('[');
                t.getElementType().apply(this);
            }

            @Override
            public void caseRefType(RefType t) {
                sb.append('L');
                sb.append(ASMBackendUtils.slashify(t.getClassName()));
                sb.append(';');
            }

            @Override
            public void caseVoidType(VoidType t) {
                sb.append('V');
            }
        });
        return sb.toString();
    }

    public static Object getDefaultValue(SootField field) {
        if (field.hasTag("StringConstantValueTag")) {
            if (ASMBackendUtils.acceptsStringInitialValue(field)) {
                return ((StringConstantValueTag)field.getTag("StringConstantValueTag")).getStringValue();
            }
        } else {
            if (field.hasTag("IntegerConstantValueTag")) {
                return ((IntegerConstantValueTag)field.getTag("IntegerConstantValueTag")).getIntValue();
            }
            if (field.hasTag("LongConstantValueTag")) {
                return ((LongConstantValueTag)field.getTag("LongConstantValueTag")).getLongValue();
            }
            if (field.hasTag("FloatConstantValueTag")) {
                return Float.valueOf(((FloatConstantValueTag)field.getTag("FloatConstantValueTag")).getFloatValue());
            }
            if (field.hasTag("DoubleConstantValueTag")) {
                return ((DoubleConstantValueTag)field.getTag("DoubleConstantValueTag")).getDoubleValue();
            }
        }
        return null;
    }

    public static boolean acceptsStringInitialValue(SootField field) {
        if (field.getType() instanceof RefType) {
            SootClass fieldClass = ((RefType)field.getType()).getSootClass();
            return fieldClass.getName().equals("java.lang.String");
        }
        return false;
    }

    public static int sizeOfType(Type t) {
        if (t instanceof DoubleWordType || t instanceof LongType || t instanceof DoubleType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    public static Attribute createASMAttribute(soot.tagkit.Attribute attr) {
        final soot.tagkit.Attribute a = attr;
        return new Attribute(attr.getName()){

            @Override
            protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
                ByteVector result = new ByteVector();
                result.putByteArray(a.getValue(), 0, a.getValue().length);
                return result;
            }
        };
    }

    public static String translateJavaVersion(int javaVersion) {
        if (javaVersion == 1) {
            return "1.0";
        }
        return "1." + (javaVersion - 1);
    }
}

