/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import soot.util.HashChain;

public class IterableMap
implements Map {
    private HashMap<Object, Object> content_map;
    private HashMap<Object, Object> back_map;
    private HashChain key_chain;
    private HashChain value_chain;
    private transient Set<Object> keySet = null;
    private transient Set<Object> valueSet = null;
    private transient Collection<Object> values = null;

    public IterableMap() {
        this(7, 0.7f);
    }

    public IterableMap(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public IterableMap(int initialCapacity, float loadFactor) {
        this.content_map = new HashMap(initialCapacity, loadFactor);
        this.back_map = new HashMap(initialCapacity, loadFactor);
        this.key_chain = new HashChain();
        this.value_chain = new HashChain();
    }

    @Override
    public void clear() {
        Iterator kcit = this.key_chain.iterator();
        while (kcit.hasNext()) {
            this.content_map.remove(kcit.next());
        }
        Iterator vcit = this.value_chain.iterator();
        while (vcit.hasNext()) {
            this.back_map.remove(vcit.next());
        }
        this.key_chain.clear();
        this.value_chain.clear();
    }

    public Iterator iterator() {
        return this.key_chain.iterator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.key_chain.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.value_chain.contains(value);
    }

    public Set entrySet() {
        return this.content_map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterableMap)) {
            return false;
        }
        IterableMap other = (IterableMap)o;
        if (!this.key_chain.equals(other.key_chain)) {
            return false;
        }
        for (Object ko : this.key_chain) {
            if (other.content_map.get(ko) == this.content_map.get(ko)) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        return this.content_map.get(key);
    }

    @Override
    public int hashCode() {
        return this.content_map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.key_chain.isEmpty();
    }

    public Set<Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IterableMap.this.key_chain.iterator();
                }

                @Override
                public int size() {
                    return IterableMap.this.key_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.key_chain.contains(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (!IterableMap.this.key_chain.contains(o)) {
                        return false;
                    }
                    if (IterableMap.this.content_map.get(o) == null) {
                        IterableMap.this.remove(o);
                        return true;
                    }
                    return IterableMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Set<Object> valueSet() {
        if (this.valueSet == null) {
            this.valueSet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IterableMap.this.value_chain.iterator();
                }

                @Override
                public int size() {
                    return IterableMap.this.value_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.value_chain.contains(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (!IterableMap.this.value_chain.contains(o)) {
                        return false;
                    }
                    HashChain c = (HashChain)IterableMap.this.back_map.get(o);
                    Iterator it = c.snapshotIterator();
                    while (it.hasNext()) {
                        Object ko = it.next();
                        if (IterableMap.this.content_map.get(o) == null) {
                            IterableMap.this.remove(ko);
                            continue;
                        }
                        if (IterableMap.this.remove(ko) != null) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.valueSet;
    }

    public Object put(Object key, Object value) {
        if (this.key_chain.contains(key)) {
            Object old_value = this.content_map.get(key);
            if (old_value == value) {
                return value;
            }
            HashChain<Object> kc = (HashChain<Object>)this.back_map.get(old_value);
            kc.remove(key);
            if (kc.isEmpty()) {
                this.value_chain.remove(old_value);
                this.back_map.remove(old_value);
            }
            if ((kc = (HashChain)this.back_map.get(value)) == null) {
                kc = new HashChain<Object>();
                this.back_map.put(value, kc);
                this.value_chain.add(value);
            }
            kc.add(key);
            return old_value;
        }
        this.key_chain.add(key);
        this.content_map.put(key, value);
        HashChain<Object> kc = (HashChain<Object>)this.back_map.get(value);
        if (kc == null) {
            kc = new HashChain<Object>();
            this.back_map.put(value, kc);
            this.value_chain.add(value);
        }
        kc.add(key);
        return null;
    }

    public void putAll(Map t) {
        Iterator<Object> kit;
        Iterator<Object> iterator = kit = t instanceof IterableMap ? ((IterableMap)t).key_chain.iterator() : t.keySet().iterator();
        while (kit.hasNext()) {
            Object key = kit.next();
            this.put(key, t.get(key));
        }
    }

    public Object remove(Object key) {
        if (!this.key_chain.contains(key)) {
            return null;
        }
        this.key_chain.remove(key);
        Object value = this.content_map.remove(key);
        HashChain c = (HashChain)this.back_map.get(value);
        c.remove(key);
        if (c.size() == 0) {
            this.back_map.remove(value);
        }
        return value;
    }

    @Override
    public int size() {
        return this.key_chain.size();
    }

    public Collection<Object> values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new Mapping_Iterator(IterableMap.this.key_chain, IterableMap.this.content_map);
                }

                @Override
                public int size() {
                    return IterableMap.this.key_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.value_chain.contains(o);
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public class Mapping_Iterator
    implements Iterator {
        private final Iterator it;
        private HashMap<Object, Object> m;

        public Mapping_Iterator(HashChain c, HashMap<Object, Object> m3) {
            this.it = c.iterator();
            this.m = m3;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return this.m.get(this.it.next());
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("You cannot remove from an Iterator on the values() for an IterableMap.");
        }
    }
}

