/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.util.Chain;

public class UnusedLocalEliminator
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnusedLocalEliminator.class);

    public UnusedLocalEliminator(Singletons.Global g2) {
    }

    public static UnusedLocalEliminator v() {
        return G.v().soot_toolkits_scalar_UnusedLocalEliminator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Eliminating unused locals...");
        }
        int i = 0;
        int n = body.getLocals().size();
        int[] oldNumbers = new int[n];
        Chain<Local> locals = body.getLocals();
        for (Local local : locals) {
            oldNumbers[i] = local.getNumber();
            local.setNumber(i);
            ++i;
        }
        BitSet usedLocals = new BitSet(n);
        for (Unit s2 : body.getUnits()) {
            Local l;
            Value v;
            for (ValueBox vb : s2.getUseBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                assert (locals.contains(l));
                usedLocals.set(l.getNumber());
            }
            for (ValueBox vb : s2.getDefBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                assert (locals.contains(l));
                usedLocals.set(l.getNumber());
            }
        }
        Iterator<Local> iterator = locals.iterator();
        while (iterator.hasNext()) {
            Local local = iterator.next();
            int lno = local.getNumber();
            if (!usedLocals.get(lno)) {
                iterator.remove();
                continue;
            }
            local.setNumber(oldNumbers[lno]);
        }
    }
}

