/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;

public abstract class UnitGraph
implements DirectedGraph<Unit> {
    private static final Logger logger = LoggerFactory.getLogger(UnitGraph.class);
    protected List<Unit> heads;
    protected List<Unit> tails;
    protected Map<Unit, List<Unit>> unitToSuccs;
    protected Map<Unit, List<Unit>> unitToPreds;
    protected SootMethod method;
    protected Body body;
    protected Chain<Unit> unitChain;

    protected UnitGraph(Body body) {
        this.body = body;
        this.unitChain = body.getUnits();
        this.method = body.getMethod();
        if (Options.v().verbose()) {
            logger.debug("[" + this.method.getName() + "]     Constructing " + this.getClass().getName() + "...");
        }
    }

    protected void buildUnexceptionalEdges(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds) {
        Unit nextUnit;
        Iterator<Unit> unitIt = this.unitChain.iterator();
        Unit unit = nextUnit = unitIt.hasNext() ? unitIt.next() : null;
        while (nextUnit != null) {
            Unit currentUnit = nextUnit;
            nextUnit = unitIt.hasNext() ? unitIt.next() : null;
            ArrayList<Unit> successors = new ArrayList<Unit>();
            if (currentUnit.fallsThrough() && nextUnit != null) {
                successors.add(nextUnit);
                List<Unit> preds = unitToPreds.get(nextUnit);
                if (preds == null) {
                    preds = new ArrayList<Unit>();
                    unitToPreds.put(nextUnit, preds);
                }
                preds.add(currentUnit);
            }
            if (currentUnit.branches()) {
                for (UnitBox targetBox : currentUnit.getUnitBoxes()) {
                    Unit target = targetBox.getUnit();
                    if (successors.contains(target)) continue;
                    successors.add(target);
                    List<Unit> preds = unitToPreds.get(target);
                    if (preds == null) {
                        preds = new ArrayList<Unit>();
                        unitToPreds.put(target, preds);
                    }
                    preds.add(currentUnit);
                }
            }
            if (successors.isEmpty()) continue;
            successors.trimToSize();
            unitToSuccs.put(currentUnit, successors);
        }
    }

    protected void buildHeadsAndTails() {
        Unit entryPoint;
        this.tails = new ArrayList<Unit>();
        this.heads = new ArrayList<Unit>();
        for (Unit s2 : this.unitChain) {
            List<Unit> preds;
            List<Unit> succs = this.unitToSuccs.get(s2);
            if (succs == null || succs.isEmpty()) {
                this.tails.add(s2);
            }
            if ((preds = this.unitToPreds.get(s2)) != null && !preds.isEmpty()) continue;
            this.heads.add(s2);
        }
        if (!this.unitChain.isEmpty() && !this.heads.contains(entryPoint = this.unitChain.getFirst())) {
            this.heads.add(entryPoint);
        }
    }

    protected Map<Unit, List<Unit>> combineMapValues(Map<Unit, List<Unit>> mapA, Map<Unit, List<Unit>> mapB) {
        LinkedHashMap<Unit, List<Unit>> result = new LinkedHashMap<Unit, List<Unit>>(mapA.size() * 2 + 1, 0.7f);
        for (Unit unit : this.unitChain) {
            int resultSize;
            List<Unit> listB;
            List<Unit> listA = mapA.get(unit);
            if (listA == null) {
                listA = Collections.emptyList();
            }
            if ((listB = mapB.get(unit)) == null) {
                listB = Collections.emptyList();
            }
            if ((resultSize = listA.size() + listB.size()) == 0) {
                result.put(unit, Collections.emptyList());
                continue;
            }
            ArrayList<Unit> resultList = new ArrayList<Unit>(resultSize);
            List<Unit> list = null;
            if (listA.size() >= listB.size()) {
                resultList.addAll(listA);
                list = listB;
            } else {
                resultList.addAll(listB);
                list = listA;
            }
            for (Unit element : list) {
                if (resultList.contains(element)) continue;
                resultList.add(element);
            }
            result.put(unit, resultList);
        }
        return result;
    }

    protected void addEdge(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds, Unit head, Unit tail) {
        List<Unit> headsSuccs = unitToSuccs.get(head);
        if (headsSuccs == null) {
            headsSuccs = new ArrayList<Unit>(3);
            unitToSuccs.put(head, headsSuccs);
        }
        if (!headsSuccs.contains(tail)) {
            headsSuccs.add(tail);
            List<Unit> tailsPreds = unitToPreds.get(tail);
            if (tailsPreds == null) {
                tailsPreds = new ArrayList<Unit>();
                unitToPreds.put(tail, tailsPreds);
            }
            tailsPreds.add(head);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public List<Unit> getExtendedBasicBlockPathBetween(Unit from, Unit to) {
        UnitGraph g2 = this;
        if (g2.getPredsOf(to).size() > 1) {
            return null;
        }
        LinkedList<Unit> pathStack = new LinkedList<Unit>();
        LinkedList<Integer> pathStackIndex = new LinkedList<Integer>();
        pathStack.add(from);
        pathStackIndex.add(new Integer(0));
        int psiMax = g2.getSuccsOf((Unit)pathStack.get(0)).size();
        int level = 0;
        while ((Integer)pathStackIndex.get(0) != psiMax) {
            List<Unit> succs;
            int p = (Integer)pathStackIndex.get(level);
            if (p >= (succs = g2.getSuccsOf((Unit)pathStack.get(level))).size()) {
                pathStack.remove(level);
                pathStackIndex.remove(level);
                int q = (Integer)pathStackIndex.get(--level);
                pathStackIndex.set(level, new Integer(q + 1));
                continue;
            }
            Unit betweenUnit = succs.get(p);
            if (betweenUnit == to) {
                pathStack.add(to);
                return pathStack;
            }
            if (g2.getPredsOf(betweenUnit).size() > 1) {
                pathStackIndex.set(level, new Integer(p + 1));
                continue;
            }
            ++level;
            pathStackIndex.add(new Integer(0));
            pathStack.add(betweenUnit);
        }
        return null;
    }

    @Override
    public List<Unit> getHeads() {
        return this.heads;
    }

    @Override
    public List<Unit> getTails() {
        return this.tails;
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        List<Unit> l = this.unitToPreds.get(u);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        List<Unit> l = this.unitToSuccs.get(u);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    @Override
    public int size() {
        return this.unitChain.size();
    }

    @Override
    public Iterator<Unit> iterator() {
        return this.unitChain.iterator();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Unit u : this.unitChain) {
            buf.append("// preds: ").append(this.getPredsOf(u)).append('\n');
            buf.append(u).append('\n');
            buf.append("// succs ").append(this.getSuccsOf(u)).append('\n');
        }
        return buf.toString();
    }
}

