/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.TrapTransformer;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.Chain;

public final class TrapTightener
extends TrapTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TrapTightener.class);
    protected ThrowAnalysis throwAnalysis = null;

    public TrapTightener(Singletons.Global g2) {
    }

    public static TrapTightener v() {
        return G.v().soot_toolkits_exceptions_TrapTightener();
    }

    public TrapTightener(ThrowAnalysis ta) {
        this.throwAnalysis = ta;
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Tightening trap boundaries...");
        }
        Chain<Trap> trapChain = body.getTraps();
        UnitPatchingChain unitChain = body.getUnits();
        if (trapChain.size() > 0) {
            ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body, this.throwAnalysis);
            Set<Unit> unitsWithMonitor = this.getUnitsWithMonitor(graph);
            Iterator<Trap> trapIt = trapChain.iterator();
            while (trapIt.hasNext()) {
                Trap trap = trapIt.next();
                boolean isCatchAll = trap.getException().getName().equals("java.lang.Throwable");
                Unit firstTrappedUnit = trap.getBeginUnit();
                Unit firstTrappedThrower = null;
                Unit firstUntrappedUnit = trap.getEndUnit();
                Unit lastTrappedUnit = unitChain.getPredOf(firstUntrappedUnit);
                Unit lastTrappedThrower = null;
                Unit u = firstTrappedUnit;
                while (u != null && u != firstUntrappedUnit) {
                    if (this.mightThrowTo(graph, u, trap)) {
                        firstTrappedThrower = u;
                        break;
                    }
                    if (isCatchAll && unitsWithMonitor.contains(u)) {
                        if (firstTrappedThrower != null) break;
                        firstTrappedThrower = u;
                        break;
                    }
                    u = unitChain.getSuccOf(u);
                }
                if (firstTrappedThrower != null) {
                    u = lastTrappedUnit;
                    while (u != null) {
                        if (this.mightThrowTo(graph, u, trap)) {
                            lastTrappedThrower = u;
                            break;
                        }
                        if (isCatchAll && unitsWithMonitor.contains(u)) {
                            lastTrappedThrower = u;
                            break;
                        }
                        u = unitChain.getPredOf(u);
                    }
                }
                if (firstTrappedThrower == null) {
                    trapIt.remove();
                    continue;
                }
                if (firstTrappedThrower != null && firstTrappedUnit != firstTrappedThrower) {
                    trap.setBeginUnit(firstTrappedThrower);
                }
                if (lastTrappedThrower == null) {
                    lastTrappedThrower = firstTrappedUnit;
                }
                if (lastTrappedUnit == lastTrappedThrower) continue;
                trap.setEndUnit(unitChain.getSuccOf(lastTrappedThrower));
            }
        }
    }

    protected boolean mightThrowTo(ExceptionalUnitGraph g2, Unit u, Trap t) {
        for (ExceptionalUnitGraph.ExceptionDest dest : g2.getExceptionDests(u)) {
            if (dest.getTrap() != t) continue;
            return true;
        }
        return false;
    }
}

