/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.NewArrayExpr;

public class DexArrayInitDetector {
    private Map<Unit, List<Value>> arrayInitToFillValues = new HashMap<Unit, List<Value>>();
    private Set<Unit> ignoreUnits = new HashSet<Unit>();
    private int minimumArrayLength = -1;

    public void constructArrayInitializations(Body body) {
        Unit arrayInitStmt = null;
        ArrayList<Value> arrayValues = null;
        HashSet<Unit> curIgnoreUnits = null;
        int arraySize = 0;
        for (Unit u : body.getUnits()) {
            IntConstant intConst;
            if (!(u instanceof AssignStmt)) {
                arrayValues = null;
                continue;
            }
            AssignStmt assignStmt = (AssignStmt)u;
            if (assignStmt.getRightOp() instanceof NewArrayExpr) {
                NewArrayExpr newArrayExp = (NewArrayExpr)assignStmt.getRightOp();
                if (newArrayExp.getSize() instanceof IntConstant) {
                    intConst = (IntConstant)newArrayExp.getSize();
                    if (this.minimumArrayLength != -1 && intConst.value < this.minimumArrayLength) continue;
                    arrayValues = new ArrayList<Value>();
                    arraySize = intConst.value;
                    curIgnoreUnits = new HashSet<Unit>();
                    continue;
                }
                arrayValues = null;
                continue;
            }
            if (assignStmt.getLeftOp() instanceof ArrayRef && assignStmt.getRightOp() instanceof IntConstant && arrayValues != null) {
                ArrayRef aref = (ArrayRef)assignStmt.getLeftOp();
                if (aref.getIndex() instanceof IntConstant) {
                    intConst = (IntConstant)aref.getIndex();
                    if (intConst.value == arrayValues.size()) {
                        arrayValues.add(assignStmt.getRightOp());
                        if (intConst.value == 0) {
                            arrayInitStmt = u;
                            continue;
                        }
                        if (intConst.value == arraySize - 1) {
                            curIgnoreUnits.add(u);
                            this.checkAndSave(arrayInitStmt, arrayValues, arraySize, curIgnoreUnits);
                            arrayValues = null;
                            continue;
                        }
                        curIgnoreUnits.add(u);
                        continue;
                    }
                    arrayValues = null;
                    continue;
                }
                arrayValues = null;
                continue;
            }
            arrayValues = null;
        }
    }

    public void setMinimumArrayLength(int l) {
        this.minimumArrayLength = l;
    }

    private void checkAndSave(Unit arrayInitStmt, List<Value> arrayValues, int arraySize, Set<Unit> curIgnoreUnits) {
        if (arrayValues != null && arrayValues.size() == arraySize && arrayInitStmt != null) {
            this.arrayInitToFillValues.put(arrayInitStmt, arrayValues);
            this.ignoreUnits.addAll(curIgnoreUnits);
        }
    }

    public List<Value> getValuesForArrayInit(Unit arrayInit) {
        return this.arrayInitToFillValues.get(arrayInit);
    }

    public Set<Unit> getIgnoreUnits() {
        return this.ignoreUnits;
    }

    public void fixTraps(Body activeBody) {
        Iterator<Trap> trapIt = activeBody.getTraps().iterator();
        block0: while (trapIt.hasNext()) {
            Trap t = trapIt.next();
            Unit beginUnit = t.getBeginUnit();
            Unit endUnit = t.getEndUnit();
            while (this.ignoreUnits.contains(beginUnit)) {
                beginUnit = activeBody.getUnits().getPredOf(beginUnit);
                if (beginUnit == endUnit) {
                    trapIt.remove();
                    continue block0;
                }
                if (!this.arrayInitToFillValues.containsKey(beginUnit)) continue;
            }
            while (this.ignoreUnits.contains(endUnit)) {
                endUnit = activeBody.getUnits().getSuccOf(endUnit);
                if (beginUnit != endUnit) continue;
                trapIt.remove();
                continue block0;
            }
            t.setBeginUnit(beginUnit);
            t.setEndUnit(endUnit);
        }
    }
}

