/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PhaseOptions;
import soot.Singletons;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.JimpleBody;
import soot.options.Options;
import soot.shimple.PhiExpr;
import soot.shimple.PiExpr;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleExpr;
import soot.shimple.internal.SPhiExpr;
import soot.shimple.internal.SPiExpr;
import soot.toolkits.graph.Block;
import soot.toolkits.scalar.ValueUnitPair;

public class Shimple {
    private static final Logger logger = LoggerFactory.getLogger(Shimple.class);
    public static final String IFALIAS = "IfAlias";
    public static final String MAYMODIFY = "MayModify";
    public static final String PHI = "Phi";
    public static final String PI = "Pi";
    public static final String PHASE = "shimple";

    public Shimple(Singletons.Global g2) {
    }

    public static Shimple v() {
        return G.v().soot_shimple_Shimple();
    }

    public ShimpleBody newBody(SootMethod m3) {
        Map<String, String> options = PhaseOptions.v().getPhaseOptions(PHASE);
        return new ShimpleBody(m3, options);
    }

    public ShimpleBody newBody(SootMethod m3, Map<String, String> options) {
        return new ShimpleBody(m3, options);
    }

    public ShimpleBody newBody(Body b) {
        Map<String, String> options = PhaseOptions.v().getPhaseOptions(PHASE);
        return new ShimpleBody(b, options);
    }

    public ShimpleBody newBody(Body b, Map<String, String> options) {
        return new ShimpleBody(b, options);
    }

    public PhiExpr newPhiExpr(Local leftLocal, List<Block> preds) {
        return new SPhiExpr(leftLocal, preds);
    }

    public PiExpr newPiExpr(Local local, Unit predicate, Object targetKey) {
        return new SPiExpr(local, predicate, targetKey);
    }

    public PhiExpr newPhiExpr(List<Value> args, List<Unit> preds) {
        return new SPhiExpr(args, preds);
    }

    public JimpleBody newJimpleBody(ShimpleBody body) {
        return body.toJimpleBody();
    }

    public static boolean isPhiExpr(Value value) {
        return value instanceof PhiExpr;
    }

    public static boolean isPhiNode(Unit unit) {
        return Shimple.getPhiExpr(unit) != null;
    }

    public static PhiExpr getPhiExpr(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (Shimple.isPhiExpr(right)) {
            return (PhiExpr)right;
        }
        return null;
    }

    public static boolean isPiExpr(Value value) {
        return value instanceof PiExpr;
    }

    public static boolean isPiNode(Unit unit) {
        return Shimple.getPiExpr(unit) != null;
    }

    public static PiExpr getPiExpr(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (Shimple.isPiExpr(right)) {
            return (PiExpr)right;
        }
        return null;
    }

    public static Local getLhsLocal(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (right instanceof ShimpleExpr) {
            Value left = ((AssignStmt)unit).getLeftOp();
            return (Local)left;
        }
        return null;
    }

    public static void redirectToPreds(Body body, Unit remove) {
        Object possiblePred;
        boolean debug = Options.v().debug();
        if (body instanceof ShimpleBody) {
            debug |= ((ShimpleBody)body).getOptions().debug();
        }
        UnitPatchingChain units = body.getUnits();
        List<UnitBox> boxesPointingToThis = remove.getBoxesPointingToThis();
        if (boxesPointingToThis.isEmpty()) {
            return;
        }
        for (UnitBox pointer : boxesPointingToThis) {
            if (!pointer.isBranchTarget()) break;
        }
        HashSet<Object> preds = new HashSet<Object>();
        HashSet<PhiExpr> phis = new HashSet<PhiExpr>();
        if (!remove.equals(units.getFirst()) && (possiblePred = units.getPredOf(remove)).fallsThrough()) {
            preds.add(possiblePred);
        }
        for (Unit unit : units) {
            for (UnitBox targetBox : unit.getUnitBoxes()) {
                if (!remove.equals(targetBox.getUnit())) continue;
                if (targetBox.isBranchTarget()) {
                    preds.add(unit);
                    continue;
                }
                PhiExpr phiExpr = Shimple.getPhiExpr(unit);
                if (phiExpr == null) continue;
                phis.add(phiExpr);
            }
        }
        if (phis.size() == 0) {
            if (debug) {
                logger.warn("Orphaned UnitBoxes to " + remove + "? Shimple.redirectToPreds is giving up.");
            }
            return;
        }
        if (preds.size() == 0) {
            if (debug) {
                logger.warn("Shimple.redirectToPreds couldn't find any predecessors for " + remove + " in " + body.getMethod() + ".");
            }
            if (!remove.equals(units.getFirst())) {
                Unit pred = units.getPredOf(remove);
                if (debug) {
                    logger.warn("Falling back to immediate chain predecessor: " + pred + ".");
                }
                preds.add(pred);
            } else if (!remove.equals(units.getLast())) {
                Unit succ = units.getSuccOf(remove);
                if (debug) {
                    logger.warn("Falling back to immediate chain successor: " + succ + ".");
                }
                preds.add(succ);
            } else {
                throw new RuntimeException("Assertion failed.");
            }
        }
        for (PhiExpr phiExpr : phis) {
            ValueUnitPair argBox = phiExpr.getArgBox(remove);
            if (argBox == null) {
                throw new RuntimeException("Assertion failed.");
            }
            Value arg = argBox.getValue();
            phiExpr.removeArg(argBox);
            for (Unit unit : preds) {
                phiExpr.addArg(arg, unit);
            }
        }
    }

    public static void redirectPointers(Unit oldLocation, Unit newLocation) {
        UnitBox[] boxes;
        List<UnitBox> boxesPointing = oldLocation.getBoxesPointingToThis();
        for (UnitBox box : boxes = boxesPointing.toArray(new UnitBox[boxesPointing.size()])) {
            if (box.getUnit() != oldLocation) {
                throw new RuntimeException("Something weird's happening");
            }
            if (box.isBranchTarget()) continue;
            box.setUnit(newLocation);
        }
    }
}

