/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.SootMethod;
import soot.jimple.toolkits.thread.EncapsulatedMethodAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class EncapsulatedObjectAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(EncapsulatedObjectAnalysis.class);
    List cachedClasses = new ArrayList();
    List<SootMethod> objectPureMethods = new ArrayList<SootMethod>();
    List<SootMethod> objectPureInitMethods = new ArrayList<SootMethod>();

    public boolean isMethodPureOnObject(SootMethod sm) {
        if (!this.cachedClasses.contains(sm.getDeclaringClass()) && sm.isConcrete()) {
            SootMethod initMethod = null;
            List<SootMethod> methods = sm.getDeclaringClass().getMethods();
            Iterator methodsIt = methods.iterator();
            ArrayList<SootMethod> mayBePureMethods = new ArrayList<SootMethod>(methods.size());
            while (methodsIt.hasNext()) {
                Body b;
                EncapsulatedMethodAnalysis ema;
                SootMethod method = (SootMethod)methodsIt.next();
                if (!method.isConcrete()) continue;
                if (method.getSubSignature().startsWith("void <init>")) {
                    initMethod = method;
                }
                if (!(ema = new EncapsulatedMethodAnalysis(new ExceptionalUnitGraph(b = method.retrieveActiveBody()))).isPure()) continue;
                mayBePureMethods.add(method);
            }
            if (mayBePureMethods.size() == methods.size()) {
                this.objectPureMethods.addAll(mayBePureMethods);
            } else if (initMethod != null) {
                this.objectPureMethods.add(initMethod);
            }
            if (initMethod != null) {
                this.objectPureInitMethods.add(initMethod);
            }
        }
        return this.objectPureMethods.contains(sm);
    }

    public boolean isInitMethodPureOnObject(SootMethod sm) {
        if (this.isMethodPureOnObject(sm)) {
            boolean ret = this.objectPureInitMethods.contains(sm);
            return ret;
        }
        return false;
    }

    public List<SootMethod> getObjectPureMethodsSoFar() {
        return this.objectPureMethods;
    }
}

