/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;
import soot.util.HashChain;

public class SlowAvailableExpressionsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Value>> {
    Map<Unit, BoundedFlowSet<Value>> unitToGenerateSet;
    Map<Unit, BoundedFlowSet<Value>> unitToPreserveSet;
    Map<Value, Stmt> rhsToContainingStmt;
    private final HashMap<Value, EquivalentValue> valueToEquivValue;
    FlowSet<Value> emptySet;

    public SlowAvailableExpressionsAnalysis(DirectedGraph<Unit> dg) {
        super(dg);
        UnitGraph g2 = (UnitGraph)dg;
        ArrayList<Value> exprs = new ArrayList<Value>();
        HashMap<EquivalentValue, Chain<Object>> containingExprs = new HashMap<EquivalentValue, Chain<Object>>();
        this.valueToEquivValue = new HashMap();
        this.rhsToContainingStmt = new HashMap<Value, Stmt>();
        HashMap<EquivalentValue, Chain<Value>> equivValToSiblingList = new HashMap<EquivalentValue, Chain<Value>>();
        for (Unit u : g2.getBody().getUnits()) {
            Unit s2 = (Stmt)u;
            if (!(s2 instanceof AssignStmt)) continue;
            Value v = ((AssignStmt)s2).getRightOp();
            this.rhsToContainingStmt.put(v, (Stmt)s2);
            Object ev = this.valueToEquivValue.get(v);
            if (ev == null) {
                ev = new EquivalentValue(v);
                this.valueToEquivValue.put(v, (EquivalentValue)ev);
            }
            Chain<Value> sibList = null;
            if (equivValToSiblingList.get(ev) == null) {
                sibList = new HashChain();
                equivValToSiblingList.put((EquivalentValue)ev, sibList);
            } else {
                sibList = (Chain)equivValToSiblingList.get(ev);
            }
            if (!sibList.contains(v)) {
                sibList.add(v);
            }
            if (!(v instanceof Expr) || exprs.contains(v)) continue;
            exprs.add(v);
            for (ValueBox vb : v.getUseBoxes()) {
                Value o = vb.getValue();
                EquivalentValue eo = this.valueToEquivValue.get(o);
                if (eo == null) {
                    eo = new EquivalentValue(o);
                    this.valueToEquivValue.put(o, eo);
                }
                if (equivValToSiblingList.get(eo) == null) {
                    sibList = new HashChain();
                    equivValToSiblingList.put(eo, sibList);
                } else {
                    sibList = (Chain)equivValToSiblingList.get(eo);
                }
                if (!sibList.contains(o)) {
                    sibList.add(o);
                }
                Chain<Object> l = null;
                if (containingExprs.containsKey(eo)) {
                    l = (Chain)containingExprs.get(eo);
                } else {
                    l = new HashChain();
                    containingExprs.put(eo, l);
                }
                if (l.contains(ev)) continue;
                l.add(ev);
            }
        }
        ArrayFlowUniverse<Value> exprUniv = new ArrayFlowUniverse<Value>(exprs.toArray(new Value[exprs.size()]));
        this.emptySet = new ArrayPackedSet<Value>(exprUniv);
        this.unitToPreserveSet = new HashMap<Unit, BoundedFlowSet<Value>>(g2.size() * 2 + 1, 0.7f);
        for (Unit s2 : g2) {
            ArrayPackedSet<Value> killSet = new ArrayPackedSet<Value>(exprUniv);
            for (ValueBox box : s2.getDefBoxes()) {
                Value v = box.getValue();
                EquivalentValue ev = this.valueToEquivValue.get(v);
                Chain c = (Chain)containingExprs.get(ev);
                if (c == null) continue;
                for (EquivalentValue container2 : c) {
                    for (Value sibVal : (Chain)equivValToSiblingList.get(container2)) {
                        killSet.add(sibVal, killSet);
                    }
                }
            }
            killSet.complement(killSet);
            this.unitToPreserveSet.put(s2, killSet);
        }
        this.unitToGenerateSet = new HashMap<Unit, BoundedFlowSet<Value>>(g2.size() * 2 + 1, 0.7f);
        for (Unit s2 : g2) {
            AssignStmt as;
            ArrayPackedSet<Value> genSet = new ArrayPackedSet<Value>(exprUniv);
            if (s2 instanceof AssignStmt && (as = (AssignStmt)s2).getRightOp() instanceof Expr) {
                Value gen = as.getRightOp();
                boolean cantAdd = false;
                if (gen instanceof NewExpr || gen instanceof NewArrayExpr || gen instanceof NewMultiArrayExpr) {
                    cantAdd = true;
                }
                if (gen instanceof InvokeExpr) {
                    cantAdd = true;
                }
                if (!cantAdd) {
                    genSet.add(gen, genSet);
                }
            }
            genSet.intersection((FlowSet<Value>)this.unitToPreserveSet.get(s2), genSet);
            this.unitToGenerateSet.put(s2, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Value> newInitialFlow() {
        BoundedFlowSet out = (BoundedFlowSet)this.emptySet.clone();
        out.complement(out);
        return out;
    }

    @Override
    protected FlowSet<Value> entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Value> in, Unit unit, FlowSet<Value> out) {
        in.intersection((FlowSet<Value>)this.unitToPreserveSet.get(unit), out);
        out.union((FlowSet<Value>)this.unitToGenerateSet.get(unit), out);
    }

    @Override
    protected void merge(FlowSet<Value> inSet1, FlowSet<Value> inSet2, FlowSet<Value> outSet) {
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<Value> sourceSet, FlowSet<Value> destSet) {
        sourceSet.copy(destSet);
    }
}

