/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.AvailableExpressions;
import soot.jimple.toolkits.scalar.SlowAvailableExpressionsAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;
import soot.util.HashChain;

public class SlowAvailableExpressions
implements AvailableExpressions {
    Map<Unit, List<UnitValueBoxPair>> unitToPairsAfter;
    Map<Unit, List<UnitValueBoxPair>> unitToPairsBefore;
    Map<Unit, Chain<EquivalentValue>> unitToEquivsAfter;
    Map<Unit, Chain<EquivalentValue>> unitToEquivsBefore;

    public SlowAvailableExpressions(Body b) {
        SlowAvailableExpressionsAnalysis analysis = new SlowAvailableExpressionsAnalysis(new ExceptionalUnitGraph(b));
        this.unitToPairsAfter = new HashMap<Unit, List<UnitValueBoxPair>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToPairsBefore = new HashMap<Unit, List<UnitValueBoxPair>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsAfter = new HashMap<Unit, Chain<EquivalentValue>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsBefore = new HashMap<Unit, Chain<EquivalentValue>>(b.getUnits().size() * 2 + 1, 0.7f);
        for (Unit s2 : b.getUnits()) {
            EquivalentValue ev;
            UnitValueBoxPair p;
            Stmt containingStmt;
            FlowSet set = (FlowSet)analysis.getFlowBefore(s2);
            ArrayList<UnitValueBoxPair> pairsBefore = new ArrayList<UnitValueBoxPair>();
            ArrayList<UnitValueBoxPair> pairsAfter = new ArrayList<UnitValueBoxPair>();
            HashChain<EquivalentValue> equivsBefore = new HashChain<EquivalentValue>();
            HashChain<EquivalentValue> equivsAfter = new HashChain<EquivalentValue>();
            for (Value v : set) {
                containingStmt = analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                ev = new EquivalentValue(v);
                pairsBefore.add(p);
                if (equivsBefore.contains(ev)) continue;
                equivsBefore.add(ev);
            }
            this.unitToPairsBefore.put(s2, pairsBefore);
            this.unitToEquivsBefore.put(s2, equivsBefore);
            for (Value v : (FlowSet)analysis.getFlowAfter(s2)) {
                containingStmt = analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                ev = new EquivalentValue(v);
                pairsAfter.add(p);
                if (equivsAfter.contains(ev)) continue;
                equivsAfter.add(ev);
            }
            this.unitToPairsAfter.put(s2, pairsAfter);
            this.unitToEquivsAfter.put(s2, equivsAfter);
        }
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsBefore(Unit u) {
        return this.unitToPairsBefore.get(u);
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsAfter(Unit u) {
        return this.unitToPairsAfter.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsBefore(Unit u) {
        return this.unitToEquivsBefore.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsAfter(Unit u) {
        return this.unitToEquivsAfter.get(u);
    }
}

