/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.reflection;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class ConstantInvokeMethodBaseTransformer
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConstantInvokeMethodBaseTransformer.class);
    private static final String INVOKE_SIG = "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>";

    public ConstantInvokeMethodBaseTransformer(Singletons.Global g2) {
    }

    public static ConstantInvokeMethodBaseTransformer v() {
        return G.v().soot_jimple_toolkits_reflection_ConstantInvokeMethodBaseTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        boolean verbose = options.containsKey("verbose");
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            if (sootClass.resolvingLevel() < 3) continue;
            for (SootMethod sootMethod : sootClass.getMethods()) {
                Body body = sootMethod.retrieveActiveBody();
                Iterator iterator = body.getUnits().snapshotIterator();
                while (iterator.hasNext()) {
                    InvokeExpr invokeExpr;
                    Stmt u = (Stmt)iterator.next();
                    if (!u.containsInvokeExpr() || !(invokeExpr = u.getInvokeExpr()).getMethod().getSignature().equals(INVOKE_SIG) || !(invokeExpr.getArg(0) instanceof StringConstant)) continue;
                    StringConstant constant = (StringConstant)invokeExpr.getArg(0);
                    Local newLocal = Jimple.v().newLocal("sc" + body.getLocalCount(), constant.getType());
                    body.getLocals().add(newLocal);
                    body.getUnits().insertBefore(Jimple.v().newAssignStmt(newLocal, constant), u);
                    invokeExpr.setArg(0, newLocal);
                    if (!verbose) continue;
                    logger.debug("Replaced constant base object of Method.invoke() by local in: " + sootMethod.toString());
                }
            }
        }
    }
}

