/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.PointsToSet;
import soot.Type;
import soot.jimple.toolkits.pointer.Union;

public class MemoryEfficientRasUnion
extends Union {
    HashSet<PointsToSet> subsets;

    @Override
    public boolean isEmpty() {
        if (this.subsets == null) {
            return true;
        }
        for (PointsToSet subset : this.subsets) {
            if (subset.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNonEmptyIntersection(PointsToSet other) {
        if (this.subsets == null) {
            return true;
        }
        for (PointsToSet subset : this.subsets) {
            if (!(other instanceof Union ? other.hasNonEmptyIntersection(subset) : subset.hasNonEmptyIntersection(other))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(PointsToSet s2) {
        boolean result;
        if (this.subsets == null) {
            this.subsets = new HashSet();
        }
        if (s2 instanceof MemoryEfficientRasUnion) {
            MemoryEfficientRasUnion meru = (MemoryEfficientRasUnion)s2;
            if (meru.subsets == null || this.subsets.containsAll(meru.subsets)) {
                return false;
            }
            result = this.subsets.addAll(meru.subsets);
        } else {
            result = this.subsets.add(s2);
        }
        return result;
    }

    public Object clone() {
        MemoryEfficientRasUnion ret = new MemoryEfficientRasUnion();
        ret.addAll(this);
        return ret;
    }

    public Set possibleTypes() {
        if (this.subsets == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Type> ret = new HashSet<Type>();
        for (PointsToSet subset : this.subsets) {
            ret.addAll(subset.possibleTypes());
        }
        return ret;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.subsets == null ? 0 : this.subsets.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryEfficientRasUnion other = (MemoryEfficientRasUnion)obj;
        return !(this.subsets == null ? other.subsets != null : !this.subsets.equals(other.subsets));
    }

    public String toString() {
        if (this.subsets == null) {
            return "[]";
        }
        return this.subsets.toString();
    }
}

