/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Hierarchy;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ExplicitEdgesPred;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.Targets;
import soot.jimple.toolkits.callgraph.TopologicalOrderer;
import soot.jimple.toolkits.invoke.InlinerSafetyManager;
import soot.jimple.toolkits.invoke.SiteInliner;
import soot.options.Options;
import soot.tagkit.Host;

public class StaticInliner
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(StaticInliner.class);
    private final HashMap<SootMethod, Integer> methodToOriginalSize = new HashMap();

    public StaticInliner(Singletons.Global g2) {
    }

    public static StaticInliner v() {
        return G.v().soot_jimple_toolkits_invoke_StaticInliner();
    }

    protected void internalTransform(String phaseName, Map options) {
        Filter explicitInvokesFilter = new Filter(new ExplicitEdgesPred());
        if (Options.v().verbose()) {
            logger.debug("[] Inlining methods...");
        }
        boolean enableNullPointerCheckInsertion = PhaseOptions.getBoolean(options, "insert-null-checks");
        boolean enableRedundantCastInsertion = PhaseOptions.getBoolean(options, "insert-redundant-casts");
        String modifierOptions = PhaseOptions.getString(options, "allowed-modifier-changes");
        float expansionFactor = PhaseOptions.getFloat(options, "expansion-factor");
        int maxContainerSize = PhaseOptions.getInt(options, "max-container-size");
        int maxInlineeSize = PhaseOptions.getInt(options, "max-inlinee-size");
        boolean rerunJb = PhaseOptions.getBoolean(options, "rerun-jb");
        HashMap instanceToStaticMap = new HashMap();
        CallGraph cg = Scene.v().getCallGraph();
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        ArrayList sitesToInline = new ArrayList();
        this.computeAverageMethodSizeAndSaveOriginalSizes();
        TopologicalOrderer orderer = new TopologicalOrderer(cg);
        orderer.go();
        List<SootMethod> list = orderer.order();
        ListIterator<SootMethod> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            SootMethod container2 = it.previous();
            if (this.methodToOriginalSize.get(container2) == null || !container2.isConcrete() || !explicitInvokesFilter.wrap(cg.edgesOutOf(container2)).hasNext()) continue;
            JimpleBody b = (JimpleBody)container2.retrieveActiveBody();
            ArrayList<Unit> unitList = new ArrayList<Unit>();
            unitList.addAll(b.getUnits());
            for (Stmt stmt : unitList) {
                Targets targets;
                if (!stmt.containsInvokeExpr() || !(targets = new Targets(explicitInvokesFilter.wrap(cg.edgesOutOf(stmt)))).hasNext()) continue;
                SootMethod target = (SootMethod)targets.next();
                if (targets.hasNext() || !target.getDeclaringClass().isApplicationClass() || !target.isConcrete() || !InlinerSafetyManager.ensureInlinability(target, stmt, container2, modifierOptions)) continue;
                ArrayList<Host> l = new ArrayList<Host>();
                l.add(target);
                l.add(stmt);
                l.add(container2);
                sitesToInline.add(l);
            }
        }
        for (List list2 : sitesToInline) {
            SootMethod inlinee = (SootMethod)list2.get(0);
            int inlineeSize = ((JimpleBody)inlinee.retrieveActiveBody()).getUnits().size();
            Stmt invokeStmt = (Stmt)list2.get(1);
            SootMethod container3 = (SootMethod)list2.get(2);
            int containerSize = ((JimpleBody)container3.retrieveActiveBody()).getUnits().size();
            if (inlineeSize + containerSize > maxContainerSize || inlineeSize > maxInlineeSize || (float)(inlineeSize + containerSize) > expansionFactor * (float)this.methodToOriginalSize.get(container3).intValue() || !InlinerSafetyManager.ensureInlinability(inlinee, invokeStmt, container3, modifierOptions)) continue;
            SiteInliner.inlineSite(inlinee, invokeStmt, container3, options);
            if (!rerunJb) continue;
            PackManager.v().getPack("jb").apply(container3.getActiveBody());
        }
    }

    private void computeAverageMethodSizeAndSaveOriginalSizes() {
        long sum = 0L;
        long count = 0L;
        for (SootClass c : Scene.v().getApplicationClasses()) {
            Iterator<SootMethod> methodsIt = c.methodIterator();
            while (methodsIt.hasNext()) {
                SootMethod m3 = methodsIt.next();
                if (!m3.isConcrete()) continue;
                int size = ((JimpleBody)m3.retrieveActiveBody()).getUnits().size();
                sum += (long)size;
                this.methodToOriginalSize.put(m3, new Integer(size));
                ++count;
            }
        }
        if (count == 0L) {
            return;
        }
    }
}

