/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EquivalentValue;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.infoflow.CachedEquivalentValue;
import soot.jimple.toolkits.infoflow.ClassInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.util.dot.DotGraph;

public class InfoFlowAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(InfoFlowAnalysis.class);
    boolean includePrimitiveInfoFlow;
    boolean includeInnerFields;
    boolean printDebug;
    Map<SootClass, ClassInfoFlowAnalysis> classToClassInfoFlowAnalysis;
    static int nodecount = 0;

    public InfoFlowAnalysis(boolean includePrimitiveDataFlow, boolean includeInnerFields) {
        this(includePrimitiveDataFlow, includeInnerFields, false);
    }

    public InfoFlowAnalysis(boolean includePrimitiveDataFlow, boolean includeInnerFields, boolean printDebug) {
        this.includePrimitiveInfoFlow = includePrimitiveDataFlow;
        this.includeInnerFields = includeInnerFields;
        this.printDebug = printDebug;
        this.classToClassInfoFlowAnalysis = new HashMap<SootClass, ClassInfoFlowAnalysis>();
    }

    public boolean includesPrimitiveInfoFlow() {
        return this.includePrimitiveInfoFlow;
    }

    public boolean includesInnerFields() {
        return this.includeInnerFields;
    }

    public boolean printDebug() {
        return this.printDebug;
    }

    private ClassInfoFlowAnalysis getClassInfoFlowAnalysis(SootClass sc) {
        if (!this.classToClassInfoFlowAnalysis.containsKey(sc)) {
            ClassInfoFlowAnalysis cdfa = new ClassInfoFlowAnalysis(sc, this);
            this.classToClassInfoFlowAnalysis.put(sc, cdfa);
        }
        return this.classToClassInfoFlowAnalysis.get(sc);
    }

    public SmartMethodInfoFlowAnalysis getMethodInfoFlowAnalysis(SootMethod sm) {
        ClassInfoFlowAnalysis cdfa = this.getClassInfoFlowAnalysis(sm.getDeclaringClass());
        return cdfa.getMethodInfoFlowAnalysis(sm);
    }

    public HashMutableDirectedGraph<EquivalentValue> getMethodInfoFlowSummary(SootMethod sm) {
        return this.getMethodInfoFlowSummary(sm, true);
    }

    public HashMutableDirectedGraph<EquivalentValue> getMethodInfoFlowSummary(SootMethod sm, boolean doFullAnalysis) {
        ClassInfoFlowAnalysis cdfa = this.getClassInfoFlowAnalysis(sm.getDeclaringClass());
        return cdfa.getMethodInfoFlowSummary(sm, doFullAnalysis);
    }

    public static EquivalentValue getNodeForFieldRef(SootMethod sm, SootField sf) {
        return InfoFlowAnalysis.getNodeForFieldRef(sm, sf, null);
    }

    public static EquivalentValue getNodeForFieldRef(SootMethod sm, SootField sf, Local realLocal) {
        if (sf.isStatic()) {
            return new CachedEquivalentValue(Jimple.v().newStaticFieldRef(sf.makeRef()));
        }
        if (sm.isConcrete() && !sm.isStatic() && sm.getDeclaringClass() == sf.getDeclaringClass() && realLocal == null) {
            FakeJimpleLocal fakethis = new FakeJimpleLocal("fakethis", sf.getDeclaringClass().getType(), sm.retrieveActiveBody().getThisLocal());
            return new CachedEquivalentValue(Jimple.v().newInstanceFieldRef(fakethis, sf.makeRef()));
        }
        FakeJimpleLocal fakethis = new FakeJimpleLocal("fakethis", sf.getDeclaringClass().getType(), realLocal);
        return new CachedEquivalentValue(Jimple.v().newInstanceFieldRef(fakethis, sf.makeRef()));
    }

    public static EquivalentValue getNodeForParameterRef(SootMethod sm, int i) {
        return new CachedEquivalentValue(new ParameterRef(sm.getParameterType(i), i));
    }

    public static EquivalentValue getNodeForReturnRef(SootMethod sm) {
        return new CachedEquivalentValue(new ParameterRef(sm.getReturnType(), -1));
    }

    public static EquivalentValue getNodeForThisRef(SootMethod sm) {
        return new CachedEquivalentValue(new ThisRef(sm.getDeclaringClass().getType()));
    }

    protected HashMutableDirectedGraph<EquivalentValue> getInvokeInfoFlowSummary(InvokeExpr ie, Stmt is, SootMethod context) {
        HashMutableDirectedGraph<EquivalentValue> ret = null;
        SootMethodRef methodRef = ie.getMethodRef();
        String subSig = methodRef.resolve().getSubSignature();
        CallGraph cg = Scene.v().getCallGraph();
        Iterator<Edge> edges = cg.edgesOutOf(is);
        while (edges.hasNext()) {
            Edge e = edges.next();
            SootMethod target = e.getTgt().method();
            if (!target.getSubSignature().equals(subSig)) continue;
            HashMutableDirectedGraph<EquivalentValue> ifs = this.getMethodInfoFlowSummary(target, context.getDeclaringClass().isApplicationClass());
            if (ret == null) {
                ret = ifs;
                continue;
            }
            for (EquivalentValue node : ifs.getNodes()) {
                if (!ret.containsNode((Object)node)) {
                    ret.addNode(node);
                }
                for (EquivalentValue succ : ifs.getSuccsOf(node)) {
                    ret.addEdge(node, succ);
                }
            }
        }
        return ret;
    }

    protected MutableDirectedGraph<EquivalentValue> getInvokeAbbreviatedInfoFlowGraph(InvokeExpr ie, SootMethod context) {
        SootMethodRef methodRef = ie.getMethodRef();
        return this.getMethodInfoFlowAnalysis(methodRef.resolve()).getMethodAbbreviatedInfoFlowGraph();
    }

    public static void printInfoFlowSummary(DirectedGraph<EquivalentValue> g2) {
        if (g2.size() > 0) {
            logger.debug("     --> ");
        }
        for (EquivalentValue node : g2) {
            List<EquivalentValue> sources = g2.getPredsOf(node);
            if (sources.isEmpty()) continue;
            logger.debug("    [ ");
            int sourcesnamelength = 0;
            int lastnamelength = 0;
            int idx = 0;
            for (EquivalentValue t : sources) {
                Value v = t.getValue();
                if (v instanceof FieldRef) {
                    FieldRef fr = (FieldRef)v;
                    String name = fr.getFieldRef().name();
                    lastnamelength = name.length();
                    if (lastnamelength > sourcesnamelength) {
                        sourcesnamelength = lastnamelength;
                    }
                    logger.debug("" + name);
                } else if (v instanceof ParameterRef) {
                    ParameterRef pr = (ParameterRef)v;
                    lastnamelength = 11;
                    if (lastnamelength > sourcesnamelength) {
                        sourcesnamelength = lastnamelength;
                    }
                    logger.debug("@parameter" + pr.getIndex());
                } else {
                    String name = v.toString();
                    lastnamelength = name.length();
                    if (lastnamelength > sourcesnamelength) {
                        sourcesnamelength = lastnamelength;
                    }
                    logger.debug("" + name);
                }
                if (idx++ >= sources.size()) continue;
                logger.debug("\n      ");
            }
            for (int i = 0; i < sourcesnamelength - lastnamelength; ++i) {
                logger.debug(" ");
            }
            logger.debug(" ] --> " + node.toString());
        }
    }

    public static void printGraphToDotFile(String filename, DirectedGraph<EquivalentValue> graph, String graphname, boolean onePage) {
        nodecount = 0;
        DotGraph canvas = new DotGraph(filename);
        if (!onePage) {
            canvas.setPageSize(8.5, 11.0);
        }
        canvas.setNodeShape("box");
        canvas.setGraphLabel(graphname);
        for (EquivalentValue node : graph) {
            canvas.drawNode(InfoFlowAnalysis.getNodeName(node));
            canvas.getNode(InfoFlowAnalysis.getNodeName(node)).setLabel(InfoFlowAnalysis.getNodeLabel(node));
            for (EquivalentValue s2 : graph.getSuccsOf(node)) {
                canvas.drawNode(InfoFlowAnalysis.getNodeName(s2));
                canvas.getNode(InfoFlowAnalysis.getNodeName(s2)).setLabel(InfoFlowAnalysis.getNodeLabel(s2));
                canvas.drawEdge(InfoFlowAnalysis.getNodeName(node), InfoFlowAnalysis.getNodeName(s2));
            }
        }
        canvas.plot(filename + ".dot");
    }

    public static String getNodeName(Object o) {
        return InfoFlowAnalysis.getNodeLabel(o);
    }

    public static String getNodeLabel(Object o) {
        Value node = ((EquivalentValue)o).getValue();
        if (node instanceof FieldRef) {
            FieldRef fr = (FieldRef)node;
            return fr.getField().getDeclaringClass().getShortName() + "." + fr.getFieldRef().name();
        }
        return node.toString();
    }
}

