/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.FastHierarchy;
import soot.G;
import soot.NullType;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.options.CGOptions;
import soot.toolkits.scalar.Pair;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.MultiMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;

public class VirtualCalls {
    private CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
    private final LargeNumberedMap<Type, SmallNumberedMap<SootMethod>> typeToVtbl = new LargeNumberedMap(Scene.v().getTypeNumberer());
    protected MultiMap<Type, Type> baseToSubTypes = new HashMultiMap<Type, Type>();
    protected MultiMap<Pair<Type, NumberedString>, Pair<Type, NumberedString>> baseToPossibleSubTypes = new HashMultiMap<Pair<Type, NumberedString>, Pair<Type, NumberedString>>();
    public final NumberedString sigClinit = Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()");
    public final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    public final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");

    public VirtualCalls(Singletons.Global g2) {
    }

    public static VirtualCalls v() {
        return G.v().soot_jimple_toolkits_callgraph_VirtualCalls();
    }

    public SootMethod resolveSpecial(SpecialInvokeExpr iie, NumberedString subSig, SootMethod container2) {
        return this.resolveSpecial(iie, subSig, container2, false);
    }

    public SootMethod resolveSpecial(SpecialInvokeExpr iie, NumberedString subSig, SootMethod container2, boolean appOnly) {
        SootMethod target = iie.getMethod();
        if (Scene.v().getOrMakeFastHierarchy().canStoreType(container2.getDeclaringClass().getType(), target.getDeclaringClass().getType()) && container2.getDeclaringClass().getType() != target.getDeclaringClass().getType() && !target.getName().equals("<init>") && subSig != this.sigClinit) {
            return this.resolveNonSpecial(container2.getDeclaringClass().getSuperclass().getType(), subSig, appOnly);
        }
        return target;
    }

    public SootMethod resolveNonSpecial(RefType t, NumberedString subSig) {
        return this.resolveNonSpecial(t, subSig, false);
    }

    public SootMethod resolveNonSpecial(RefType t, NumberedString subSig, boolean appOnly) {
        SootMethod ret;
        SmallNumberedMap<SootMethod> vtbl = this.typeToVtbl.get(t);
        if (vtbl == null) {
            vtbl = new SmallNumberedMap();
            this.typeToVtbl.put(t, vtbl);
        }
        if ((ret = vtbl.get(subSig)) != null) {
            return ret;
        }
        SootClass cls = t.getSootClass();
        if (appOnly && cls.isLibraryClass()) {
            return null;
        }
        SootMethod m3 = cls.getMethodUnsafe(subSig);
        if (m3 != null) {
            if (!m3.isAbstract()) {
                ret = m3;
            }
        } else {
            SootClass c = cls.getSuperclassUnsafe();
            if (c != null) {
                ret = this.resolveNonSpecial(c.getType(), subSig);
            }
        }
        vtbl.put(subSig, ret);
        return ret;
    }

    public void resolve(Type t, Type declaredType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, null, subSig, container2, targets);
    }

    public void resolve(Type t, Type declaredType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        this.resolve(t, declaredType, null, subSig, container2, targets, appOnly);
    }

    public void resolve(Type t, Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t, declaredType, sigType, subSig, container2, targets, false);
    }

    public void resolve(Type t, Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType instanceof ArrayType) {
            declaredType = RefType.v("java.lang.Object");
        }
        if (sigType instanceof ArrayType) {
            sigType = RefType.v("java.lang.Object");
        }
        if (t instanceof ArrayType) {
            t = RefType.v("java.lang.Object");
        }
        FastHierarchy fastHierachy = Scene.v().getOrMakeFastHierarchy();
        if (declaredType != null && !fastHierachy.canStoreType(t, declaredType)) {
            return;
        }
        if (sigType != null && !fastHierachy.canStoreType(t, sigType)) {
            return;
        }
        if (t instanceof RefType) {
            SootMethod target = this.resolveNonSpecial((RefType)t, subSig, appOnly);
            if (target != null) {
                targets.add(target);
            }
        } else if (t instanceof AnySubType) {
            RefType base = ((AnySubType)t).getBase();
            if (this.options.library() == 3 && base.getSootClass().isInterface()) {
                this.resolveLibrarySignature(declaredType, sigType, subSig, container2, targets, appOnly, base);
            } else {
                this.resolveAnySubType(declaredType, sigType, subSig, container2, targets, appOnly, base);
            }
        } else if (!(t instanceof NullType)) {
            throw new RuntimeException("oops " + t);
        }
    }

    public void resolveSuperType(Type t, Type declaredType, NumberedString subSig, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType == null) {
            return;
        }
        if (t == null) {
            return;
        }
        if (declaredType instanceof ArrayType) {
            declaredType = RefType.v("java.lang.Object");
        }
        if (t instanceof ArrayType) {
            t = RefType.v("java.lang.Object");
        }
        if (declaredType instanceof RefType) {
            SootMethod target;
            RefType child;
            RefType parent = (RefType)declaredType;
            SootClass parentClass = parent.getSootClass();
            if (t instanceof AnySubType) {
                child = ((AnySubType)t).getBase();
            } else if (t instanceof RefType) {
                child = (RefType)t;
            } else {
                return;
            }
            SootClass childClass = child.getSootClass();
            FastHierarchy fastHierachy = Scene.v().getOrMakeFastHierarchy();
            if (fastHierachy.canStoreClass(childClass, parentClass) && (target = this.resolveNonSpecial(child, subSig, appOnly)) != null) {
                targets.add(target);
            }
        }
    }

    protected void resolveAnySubType(Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly, RefType base) {
        FastHierarchy fastHierachy = Scene.v().getOrMakeFastHierarchy();
        Set<Type> subTypes = this.baseToSubTypes.get(base);
        if (subTypes != null && !subTypes.isEmpty()) {
            for (Type st : subTypes) {
                this.resolve(st, declaredType, sigType, subSig, container2, targets, appOnly);
            }
            return;
        }
        HashSet<RefType> newSubTypes = new HashSet<RefType>();
        newSubTypes.add(base);
        LinkedList<SootClass> worklist = new LinkedList<SootClass>();
        HashSet<SootClass> workset = new HashSet<SootClass>();
        FastHierarchy fh = fastHierachy;
        SootClass cl = base.getSootClass();
        if (workset.add(cl)) {
            worklist.add(cl);
        }
        while (!worklist.isEmpty()) {
            cl = (SootClass)worklist.removeFirst();
            if (cl.isInterface()) {
                for (SootClass c : fh.getAllImplementersOfInterface(cl)) {
                    if (!workset.add(c)) continue;
                    worklist.add(c);
                }
                continue;
            }
            if (cl.isConcrete()) {
                this.resolve(cl.getType(), declaredType, sigType, subSig, container2, targets, appOnly);
                newSubTypes.add(cl.getType());
            }
            for (SootClass c : fh.getSubclassesOf(cl)) {
                if (!workset.add(c)) continue;
                worklist.add(c);
            }
        }
        this.baseToSubTypes.putAll(base, newSubTypes);
    }

    protected void resolveLibrarySignature(Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly, RefType base) {
        FastHierarchy fastHierachy = Scene.v().getOrMakeFastHierarchy();
        assert (declaredType instanceof RefType);
        Pair<RefType, NumberedString> pair = new Pair<RefType, NumberedString>(base, subSig);
        Set<Pair<Type, NumberedString>> types = this.baseToPossibleSubTypes.get(pair);
        if (types != null) {
            for (Pair<Type, NumberedString> tuple : types) {
                Type st = tuple.getO1();
                if (!fastHierachy.canStoreType(st, declaredType)) {
                    this.resolve(st, st, sigType, subSig, container2, targets, appOnly);
                    continue;
                }
                this.resolve(st, declaredType, sigType, subSig, container2, targets, appOnly);
            }
            return;
        }
        types = new HashSet<Pair<Type, NumberedString>>();
        String[] split = subSig.getString().replaceAll("(.*) (.*)\\((.*)\\)", "$1;$2;$3").split(";");
        Type declaredReturnType = Scene.v().getType(split[0]);
        String declaredName = split[1];
        ArrayList<Type> declaredParamTypes = new ArrayList<Type>();
        if (split.length == 3) {
            for (String type : split[2].split(",")) {
                declaredParamTypes.add(Scene.v().getType(type));
            }
        }
        Chain<SootClass> classes = Scene.v().getClasses();
        for (SootClass sc : classes) {
            for (SootMethod sm : sc.getMethods()) {
                if (sm.isAbstract() || !sm.getName().equals(declaredName) || !fastHierachy.canStoreType(sm.getReturnType(), declaredReturnType)) continue;
                List<Type> paramTypes = sm.getParameterTypes();
                if (declaredParamTypes.size() != paramTypes.size()) continue;
                boolean check = true;
                for (int i = 0; i < paramTypes.size(); ++i) {
                    if (fastHierachy.canStoreType((Type)declaredParamTypes.get(i), paramTypes.get(i))) continue;
                    check = false;
                    break;
                }
                if (!check) continue;
                RefType st = sc.getType();
                if (!fastHierachy.canStoreType(st, declaredType)) {
                    if (sc.isFinal()) continue;
                    NumberedString newSubSig = sm.getNumberedSubSignature();
                    this.resolve(st, st, sigType, newSubSig, container2, targets, appOnly);
                    types.add(new Pair<RefType, NumberedString>(st, newSubSig));
                    continue;
                }
                this.resolve(st, declaredType, sigType, subSig, container2, targets, appOnly);
                types.add(new Pair<RefType, NumberedString>(st, subSig));
            }
        }
        this.baseToPossibleSubTypes.putAll(pair, types);
    }
}

