/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;
import soot.util.NumberedSet;

public class TopologicalOrderer {
    CallGraph cg;
    List<SootMethod> order = new ArrayList<SootMethod>();
    NumberedSet<SootMethod> visited = new NumberedSet<SootMethod>(Scene.v().getMethodNumberer());

    public TopologicalOrderer(CallGraph cg) {
        this.cg = cg;
    }

    public void go() {
        Iterator<MethodOrMethodContext> methods = this.cg.sourceMethods();
        while (methods.hasNext()) {
            SootMethod m3 = (SootMethod)methods.next();
            this.dfsVisit(m3);
        }
    }

    private void dfsVisit(SootMethod m3) {
        if (this.visited.contains(m3)) {
            return;
        }
        this.visited.add(m3);
        Targets targets = new Targets(this.cg.edgesOutOf(m3));
        while (targets.hasNext()) {
            SootMethod target = (SootMethod)targets.next();
            this.dfsVisit(target);
        }
        this.order.add(m3);
    }

    public List<SootMethod> order() {
        return this.order;
    }
}

