/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.Targets;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class ReachableMethods {
    protected CallGraph cg;
    protected Iterator<Edge> edgeSource;
    protected final ChunkedQueue<MethodOrMethodContext> reachables = new ChunkedQueue();
    protected final Set<MethodOrMethodContext> set = new HashSet<MethodOrMethodContext>();
    protected QueueReader<MethodOrMethodContext> unprocessedMethods;
    protected final QueueReader<MethodOrMethodContext> allReachables = this.reachables.reader();
    protected Filter filter;

    public ReachableMethods(CallGraph graph, Iterator<? extends MethodOrMethodContext> entryPoints) {
        this(graph, entryPoints, null);
    }

    public ReachableMethods(CallGraph graph, Iterator<? extends MethodOrMethodContext> entryPoints, Filter filter) {
        this.filter = filter;
        this.cg = graph;
        this.addMethods(entryPoints);
        this.unprocessedMethods = this.reachables.reader();
        this.edgeSource = graph.listener();
        if (filter != null) {
            this.edgeSource = filter.wrap(this.edgeSource);
        }
    }

    public ReachableMethods(CallGraph graph, Collection<? extends MethodOrMethodContext> entryPoints) {
        this(graph, entryPoints.iterator());
    }

    protected void addMethods(Iterator<? extends MethodOrMethodContext> methods) {
        while (methods.hasNext()) {
            this.addMethod(methods.next());
        }
    }

    protected void addMethod(MethodOrMethodContext m3) {
        if (this.set.add(m3)) {
            this.reachables.add(m3);
        }
    }

    public void update() {
        while (this.edgeSource.hasNext()) {
            Edge e = this.edgeSource.next();
            if (e == null) continue;
            MethodOrMethodContext srcMethod = e.getSrc();
            if (e.isInvalid() || srcMethod == null || !this.set.contains(srcMethod)) continue;
            this.addMethod(e.getTgt());
        }
        while (this.unprocessedMethods.hasNext()) {
            MethodOrMethodContext m3 = this.unprocessedMethods.next();
            Iterator<Edge> targets = this.cg.edgesOutOf(m3);
            if (this.filter != null) {
                targets = this.filter.wrap(targets);
            }
            this.addMethods(new Targets(targets));
        }
    }

    public QueueReader<MethodOrMethodContext> listener() {
        return this.allReachables.clone();
    }

    public QueueReader<MethodOrMethodContext> newListener() {
        return this.reachables.reader();
    }

    public boolean contains(MethodOrMethodContext m3) {
        return this.set.contains(m3);
    }

    public int size() {
        return this.set.size();
    }
}

