/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.FastHierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.base.ExceptionCheckerError;
import soot.jimple.toolkits.base.ExceptionCheckerErrorReporter;
import soot.tagkit.SourceLnPosTag;
import soot.util.NumberedString;

public class ExceptionChecker
extends BodyTransformer {
    FastHierarchy hierarchy;
    ExceptionCheckerErrorReporter reporter;

    public ExceptionChecker(ExceptionCheckerErrorReporter r) {
        this.reporter = r;
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        for (Stmt s2 : b.getUnits()) {
            if (s2 instanceof ThrowStmt) {
                ThrowStmt ts = (ThrowStmt)s2;
                this.checkThrow(b, ts);
                continue;
            }
            if (s2 instanceof InvokeStmt) {
                InvokeStmt is = (InvokeStmt)s2;
                this.checkInvoke(b, is);
                continue;
            }
            if (!(s2 instanceof AssignStmt) || !(((AssignStmt)s2).getRightOp() instanceof InvokeExpr)) continue;
            InvokeExpr ie = (InvokeExpr)((AssignStmt)s2).getRightOp();
            this.checkInvokeExpr(b, ie, s2);
        }
    }

    protected void checkThrow(Body b, ThrowStmt ts) {
        if (this.isThrowDeclared(b, ((RefType)ts.getOp().getType()).getSootClass()) || this.isThrowFromCompiler(ts) || this.isExceptionCaught(b, ts, (RefType)ts.getOp().getType())) {
            return;
        }
        if (this.reporter != null) {
            this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), ((RefType)ts.getOp().getType()).getSootClass(), ts, (SourceLnPosTag)ts.getOpBox().getTag("SourceLnPosTag")));
        }
    }

    protected boolean isThrowDeclared(Body b, SootClass throwClass) {
        if (this.hierarchy == null) {
            this.hierarchy = new FastHierarchy();
        }
        if (throwClass.equals(Scene.v().getSootClass("java.lang.RuntimeException")) || throwClass.equals(Scene.v().getSootClass("java.lang.Error"))) {
            return true;
        }
        if (this.hierarchy.isSubclass(throwClass, Scene.v().getSootClass("java.lang.RuntimeException")) || this.hierarchy.isSubclass(throwClass, Scene.v().getSootClass("java.lang.Error"))) {
            return true;
        }
        if (b.getMethod().throwsException(throwClass)) {
            return true;
        }
        List<SootClass> exceptions = b.getMethod().getExceptionsUnsafe();
        if (exceptions != null) {
            for (SootClass nextEx : exceptions) {
                if (!this.hierarchy.isSubclass(throwClass, nextEx)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isThrowFromCompiler(ThrowStmt ts) {
        return ts.hasTag("ThrowCreatedByCompilerTag");
    }

    protected boolean isExceptionCaught(Body b, Stmt s2, RefType throwType) {
        if (this.hierarchy == null) {
            this.hierarchy = new FastHierarchy();
        }
        for (Trap trap : b.getTraps()) {
            if (!trap.getException().getType().equals(throwType) && !this.hierarchy.isSubclass(throwType.getSootClass(), trap.getException().getType().getSootClass()) || !this.isThrowInStmtRange(b, (Stmt)trap.getBeginUnit(), (Stmt)trap.getEndUnit(), s2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isThrowInStmtRange(Body b, Stmt begin, Stmt end, Stmt s2) {
        Iterator<Stmt> it = b.getUnits().iterator(begin, end);
        while (it.hasNext()) {
            if (!it.next().equals(s2)) continue;
            return true;
        }
        return false;
    }

    protected void checkInvoke(Body b, InvokeStmt is) {
        this.checkInvokeExpr(b, is.getInvokeExpr(), is);
    }

    private List<SootClass> getExceptionSpec(SootClass intrface, NumberedString sig) {
        SootMethod sm = intrface.getMethodUnsafe(sig);
        if (sm != null) {
            return sm.getExceptions();
        }
        List<SootClass> result = null;
        SootClass obj = Scene.v().getSootClass("java.lang.Object");
        sm = obj.getMethodUnsafe(sig);
        if (sm.getExceptionsUnsafe() == null) {
            return Collections.emptyList();
        }
        if (sm != null) {
            result = new Vector<SootClass>(sm.getExceptions());
        }
        for (SootClass suprintr : intrface.getInterfaces()) {
            List<SootClass> other = this.getExceptionSpec(suprintr, sig);
            if (other == null) continue;
            if (result == null) {
                result = other;
                continue;
            }
            result.retainAll(other);
        }
        return result;
    }

    protected void checkInvokeExpr(Body b, InvokeExpr ie, Stmt s2) {
        List<SootClass> exceptions;
        if (ie instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)ie).getBase().getType() instanceof ArrayType && ie.getMethodRef().name().equals("clone") && ie.getMethodRef().parameterTypes().size() == 0) {
            return;
        }
        List<SootClass> list = exceptions = ie instanceof InterfaceInvokeExpr ? this.getExceptionSpec(ie.getMethodRef().declaringClass(), ie.getMethodRef().getSubSignature()) : ie.getMethod().getExceptionsUnsafe();
        if (exceptions == null) {
            return;
        }
        for (SootClass sc : exceptions) {
            if (this.isThrowDeclared(b, sc) || this.isExceptionCaught(b, s2, sc.getType()) || this.reporter == null) continue;
            if (s2 instanceof InvokeStmt) {
                this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), sc, s2, (SourceLnPosTag)s2.getTag("SourceLnPosTag")));
                continue;
            }
            if (!(s2 instanceof AssignStmt)) continue;
            this.reporter.reportError(new ExceptionCheckerError(b.getMethod(), sc, s2, (SourceLnPosTag)((AssignStmt)s2).getRightOpBox().getTag("SourceLnPosTag")));
        }
    }
}

