/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.DirectedGraph;
import soot.util.HashMultiMap;

public class DirectedCallGraph
implements DirectedGraph<SootMethod> {
    private static final Logger logger = LoggerFactory.getLogger(DirectedCallGraph.class);
    protected Set<SootMethod> nodes;
    protected Map<SootMethod, List<SootMethod>> succ;
    protected Map<SootMethod, List<SootMethod>> pred;
    protected List<SootMethod> heads;
    protected List<SootMethod> tails;
    protected int size;

    public DirectedCallGraph(CallGraph cg, SootMethodFilter filter, Iterator<SootMethod> heads, boolean verbose) {
        LinkedList<SootMethod> filteredHeads = new LinkedList<SootMethod>();
        while (heads.hasNext()) {
            SootMethod m3 = heads.next();
            if (!m3.isConcrete() || !filter.want(m3)) continue;
            filteredHeads.add(m3);
        }
        this.nodes = new HashSet<SootMethod>(filteredHeads);
        HashMultiMap<SootMethod, SootMethod> s2 = new HashMultiMap<SootMethod, SootMethod>();
        HashMultiMap<SootMethod, SootMethod> p = new HashMultiMap<SootMethod, SootMethod>();
        HashSet remain = new HashSet(filteredHeads);
        int nb = 0;
        if (verbose) {
            logger.debug("[AM] dumping method dependencies");
        }
        while (!remain.isEmpty()) {
            HashSet<SootMethod> newRemain = new HashSet<SootMethod>();
            for (SootMethod m4 : remain) {
                if (verbose) {
                    logger.debug(" |- " + m4.toString() + " calls");
                }
                Iterator<Edge> itt = cg.edgesOutOf(m4);
                while (itt.hasNext()) {
                    boolean keep;
                    Edge edge = itt.next();
                    SootMethod mm3 = edge.tgt();
                    boolean bl = keep = mm3.isConcrete() && filter.want(mm3);
                    if (verbose) {
                        logger.debug(" |  |- " + mm3.toString() + (keep ? "" : " (filtered out)"));
                    }
                    if (!keep) continue;
                    if (this.nodes.add(mm3)) {
                        newRemain.add(mm3);
                    }
                    s2.put(m4, mm3);
                    p.put(mm3, m4);
                }
                ++nb;
            }
            remain = newRemain;
        }
        logger.debug("[AM] number of methods to be analysed: " + nb);
        this.succ = new HashMap<SootMethod, List<SootMethod>>();
        this.pred = new HashMap<SootMethod, List<SootMethod>>();
        this.tails = new LinkedList<SootMethod>();
        this.heads = new LinkedList<SootMethod>();
        for (SootMethod x : this.nodes) {
            Set ss = s2.get(x);
            Set pp = p.get(x);
            this.succ.put(x, new LinkedList(ss));
            this.pred.put(x, new LinkedList(pp));
            if (ss.isEmpty()) {
                this.tails.add(x);
            }
            if (!pp.isEmpty()) continue;
            this.heads.add(x);
        }
        this.size = this.nodes.size();
    }

    @Override
    public List<SootMethod> getHeads() {
        return this.heads;
    }

    @Override
    public List<SootMethod> getTails() {
        return this.tails;
    }

    @Override
    public Iterator<SootMethod> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<SootMethod> getSuccsOf(SootMethod s2) {
        return this.succ.get(s2);
    }

    @Override
    public List<SootMethod> getPredsOf(SootMethod s2) {
        return this.pred.get(s2);
    }
}

