/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.SourceLocator;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.purity.DirectedCallGraph;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public abstract class AbstractInterproceduralAnalysis<S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInterproceduralAnalysis.class);
    public static final boolean doCheck = false;
    protected final CallGraph cg;
    protected final DirectedGraph<SootMethod> dg;
    protected final Map<SootMethod, S> data;
    protected final Map<SootMethod, Integer> order;
    protected final Map<SootMethod, S> unanalysed;

    public AbstractInterproceduralAnalysis(CallGraph cg, SootMethodFilter filter, Iterator<SootMethod> heads, boolean verbose) {
        this.cg = cg;
        this.dg = new DirectedCallGraph(cg, filter, heads, verbose);
        this.data = new HashMap<SootMethod, S>();
        this.unanalysed = new HashMap<SootMethod, S>();
        this.order = new HashMap<SootMethod, Integer>();
        int i = 0;
        for (SootMethod m3 : new PseudoTopologicalOrderer<SootMethod>().newList(this.dg, true)) {
            this.order.put(m3, i);
            ++i;
        }
    }

    protected abstract S newInitialSummary();

    protected abstract S summaryOfUnanalysedMethod(SootMethod var1);

    protected abstract void analyseMethod(SootMethod var1, S var2);

    protected abstract void applySummary(S var1, Stmt var2, S var3, S var4);

    protected abstract void merge(S var1, S var2, S var3);

    protected abstract void copy(S var1, S var2);

    protected void fillDotGraph(String prefix, S o, DotGraph out) {
        throw new Error("abstract function AbstractInterproceduralAnalysis.fillDotGraph called but not implemented.");
    }

    public void analyseCall(S src, Stmt callStmt, S dst) {
        S accum = this.newInitialSummary();
        this.copy(accum, dst);
        System.out.println("Edges out of " + callStmt + "...");
        Iterator<Edge> it = this.cg.edgesOutOf(callStmt);
        while (it.hasNext()) {
            S elem;
            Edge edge = it.next();
            SootMethod m3 = edge.tgt();
            System.out.println("\t-> " + m3.getSignature());
            if (this.data.containsKey(m3)) {
                elem = this.data.get(m3);
            } else {
                if (!this.unanalysed.containsKey(m3)) {
                    this.unanalysed.put(m3, this.summaryOfUnanalysedMethod(m3));
                }
                elem = this.unanalysed.get(m3);
            }
            this.applySummary(src, callStmt, elem, accum);
            this.merge(dst, accum, dst);
        }
    }

    public void drawAsOneDot(String name) {
        DotGraph dot = new DotGraph(name);
        dot.setGraphLabel(name);
        dot.setGraphAttribute("compound", "true");
        int id = 0;
        HashMap<SootMethod, Integer> idmap = new HashMap<SootMethod, Integer>();
        for (SootMethod m3 : this.dg) {
            DotGraph sub = dot.createSubGraph("cluster" + id);
            DotGraphNode label = sub.drawNode("head" + id);
            idmap.put(m3, id);
            sub.setGraphLabel("");
            label.setLabel("(" + this.order.get(m3) + ") " + m3.toString());
            label.setAttribute("fontsize", "18");
            label.setShape("box");
            if (this.data.containsKey(m3)) {
                this.fillDotGraph("X" + id, this.data.get(m3), sub);
            }
            ++id;
        }
        for (SootMethod m3 : this.dg) {
            for (SootMethod mm3 : this.dg.getSuccsOf(m3)) {
                DotGraphEdge edge = dot.drawEdge("head" + idmap.get(m3), "head" + idmap.get(mm3));
                edge.setAttribute("ltail", "cluster" + idmap.get(m3));
                edge.setAttribute("lhead", "cluster" + idmap.get(mm3));
            }
        }
        File f = new File(SourceLocator.v().getOutputDir(), name + ".dot");
        dot.plot(f.getPath());
    }

    public void drawAsManyDot(String prefix, boolean drawUnanalysed) {
        File f;
        DotGraph dot;
        for (SootMethod m3 : this.data.keySet()) {
            dot = new DotGraph(m3.toString());
            dot.setGraphLabel(m3.toString());
            this.fillDotGraph("X", this.data.get(m3), dot);
            f = new File(SourceLocator.v().getOutputDir(), prefix + m3.toString() + ".dot");
            dot.plot(f.getPath());
        }
        if (drawUnanalysed) {
            for (SootMethod m3 : this.unanalysed.keySet()) {
                dot = new DotGraph(m3.toString());
                dot.setGraphLabel(m3.toString() + " (unanalysed)");
                this.fillDotGraph("X", this.unanalysed.get(m3), dot);
                f = new File(SourceLocator.v().getOutputDir(), prefix + m3.toString() + "_u" + ".dot");
                dot.plot(f.getPath());
            }
        }
    }

    public S getSummaryFor(SootMethod m3) {
        if (this.data.containsKey(m3)) {
            return this.data.get(m3);
        }
        if (this.unanalysed.containsKey(m3)) {
            return this.unanalysed.get(m3);
        }
        return this.newInitialSummary();
    }

    public Iterator<SootMethod> getAnalysedMethods() {
        return this.data.keySet().iterator();
    }

    protected void doAnalysis(boolean verbose) {
        class IntComparator
        implements Comparator<SootMethod> {
            IntComparator() {
            }

            @Override
            public int compare(SootMethod o1, SootMethod o2) {
                return AbstractInterproceduralAnalysis.this.order.get(o1) - AbstractInterproceduralAnalysis.this.order.get(o2);
            }
        }
        TreeSet<SootMethod> queue = new TreeSet<SootMethod>(new IntComparator());
        for (SootMethod o : this.order.keySet()) {
            this.data.put(o, this.newInitialSummary());
            queue.add(o);
        }
        HashMap<SootMethod, Integer> nb = new HashMap<SootMethod, Integer>();
        while (!queue.isEmpty()) {
            SootMethod m3 = (SootMethod)queue.first();
            queue.remove(m3);
            S newSummary = this.newInitialSummary();
            S oldSummary = this.data.get(m3);
            if (nb.containsKey(m3)) {
                nb.put(m3, (Integer)nb.get(m3) + 1);
            } else {
                nb.put(m3, 1);
            }
            if (verbose) {
                logger.debug(" |- processing " + m3.toString() + " (" + nb.get(m3) + "-st time)");
            }
            this.analyseMethod(m3, newSummary);
            if (oldSummary.equals(newSummary)) continue;
            this.data.put(m3, newSummary);
            queue.addAll(this.dg.getPredsOf(m3));
        }
    }
}

