/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.jimple.toolkits.annotation.tags.NullCheckTag;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class NullPointerChecker
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(NullPointerChecker.class);
    private boolean isProfiling = false;
    private boolean enableOther = true;

    public NullPointerChecker(Singletons.Global g2) {
    }

    public static NullPointerChecker v() {
        return G.v().soot_jimple_toolkits_annotation_nullcheck_NullPointerChecker();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        this.isProfiling = PhaseOptions.getBoolean(options, "profiling");
        this.enableOther = !PhaseOptions.getBoolean(options, "onlyarrayref");
        Date start = new Date();
        if (Options.v().verbose()) {
            logger.debug("[npc] Null pointer check for " + body.getMethod().getName() + " started on " + start);
        }
        BranchedRefVarsAnalysis analysis = new BranchedRefVarsAnalysis(new ExceptionalUnitGraph(body));
        SootClass counterClass = null;
        SootMethod increase = null;
        if (this.isProfiling) {
            counterClass = Scene.v().loadClassAndSupport("MultiCounter");
            increase = counterClass.getMethod("void increase(int)");
        }
        UnitPatchingChain units = body.getUnits();
        Iterator stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            boolean needCheck;
            Stmt s2 = (Stmt)stmtIt.next();
            Value obj = null;
            if (s2.containsArrayRef()) {
                ArrayRef aref = s2.getArrayRef();
                obj = aref.getBase();
            } else if (this.enableOther) {
                if (s2 instanceof ThrowStmt) {
                    obj = ((ThrowStmt)s2).getOp();
                } else if (s2 instanceof MonitorStmt) {
                    obj = ((MonitorStmt)s2).getOp();
                } else {
                    Value v;
                    for (ValueBox vBox : s2.getDefBoxes()) {
                        v = vBox.getValue();
                        if (v instanceof InstanceFieldRef) {
                            obj = ((InstanceFieldRef)v).getBase();
                            break;
                        }
                        if (v instanceof InstanceInvokeExpr) {
                            obj = ((InstanceInvokeExpr)v).getBase();
                            break;
                        }
                        if (!(v instanceof LengthExpr)) continue;
                        obj = ((LengthExpr)v).getOp();
                        break;
                    }
                    for (ValueBox vBox : s2.getUseBoxes()) {
                        v = vBox.getValue();
                        if (v instanceof InstanceFieldRef) {
                            obj = ((InstanceFieldRef)v).getBase();
                            break;
                        }
                        if (v instanceof InstanceInvokeExpr) {
                            obj = ((InstanceInvokeExpr)v).getBase();
                            break;
                        }
                        if (!(v instanceof LengthExpr)) continue;
                        obj = ((LengthExpr)v).getOp();
                        break;
                    }
                }
            }
            if (obj == null) continue;
            FlowSet beforeSet = (FlowSet)analysis.getFlowBefore(s2);
            int vInfo = analysis.anyRefInfo(obj, beforeSet);
            boolean bl = needCheck = vInfo != 2;
            if (this.isProfiling) {
                int whichCounter = 5;
                if (!needCheck) {
                    whichCounter = 6;
                }
                units.insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(increase.makeRef(), (Value)IntConstant.v(whichCounter))), s2);
            }
            NullCheckTag nullTag = new NullCheckTag(needCheck);
            s2.addTag(nullTag);
        }
        Date finish = new Date();
        if (Options.v().verbose()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            logger.debug("[npc] Null pointer checker finished. It took " + mins + " mins and " + secs + " secs.");
        }
    }
}

