/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Context;
import soot.EntryPoints;
import soot.G;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.internal.SparkLibraryHelper;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.toolkits.pointer.representations.ReferenceVariable;
import soot.util.NumberedString;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class MethodPAG {
    private PAG pag;
    private Set<Context> addedContexts;
    private final ChunkedQueue<Node> internalEdges = new ChunkedQueue();
    private final ChunkedQueue<Node> inEdges = new ChunkedQueue();
    private final ChunkedQueue<Node> outEdges = new ChunkedQueue();
    private final QueueReader<Node> internalReader = this.internalEdges.reader();
    private final QueueReader<Node> inReader = this.inEdges.reader();
    private final QueueReader<Node> outReader = this.outEdges.reader();
    SootMethod method;
    protected MethodNodeFactory nodeFactory;
    protected boolean hasBeenAdded = false;
    protected boolean hasBeenBuilt = false;
    private static final String mainSubSignature = SootMethod.getSubSignature("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
    protected final NumberedString sigCanonicalize = Scene.v().getSubSigNumberer().findOrAdd("java.lang.String canonicalize(java.lang.String)");

    public PAG pag() {
        return this.pag;
    }

    protected MethodPAG(PAG pag, SootMethod m3) {
        this.pag = pag;
        this.method = m3;
        this.nodeFactory = new MethodNodeFactory(pag, this);
    }

    public void addToPAG(Context varNodeParameter) {
        Node dst;
        Node src;
        if (!this.hasBeenBuilt) {
            throw new RuntimeException(String.format("No PAG built for context %s and method %s", varNodeParameter, this.method));
        }
        if (varNodeParameter == null) {
            if (this.hasBeenAdded) {
                return;
            }
            this.hasBeenAdded = true;
        } else {
            if (this.addedContexts == null) {
                this.addedContexts = new HashSet<Context>();
            }
            if (!this.addedContexts.add(varNodeParameter)) {
                return;
            }
        }
        Object reader = this.internalReader.clone();
        while (((QueueReader)reader).hasNext()) {
            src = (Node)((QueueReader)reader).next();
            src = this.parameterize(src, varNodeParameter);
            dst = (Node)((QueueReader)reader).next();
            dst = this.parameterize(dst, varNodeParameter);
            this.pag.addEdge(src, dst);
        }
        reader = this.inReader.clone();
        while (((QueueReader)reader).hasNext()) {
            src = (Node)((QueueReader)reader).next();
            dst = (Node)((QueueReader)reader).next();
            dst = this.parameterize(dst, varNodeParameter);
            this.pag.addEdge(src, dst);
        }
        reader = this.outReader.clone();
        while (((QueueReader)reader).hasNext()) {
            src = (Node)((QueueReader)reader).next();
            src = this.parameterize(src, varNodeParameter);
            dst = (Node)((QueueReader)reader).next();
            this.pag.addEdge(src, dst);
        }
    }

    public void addInternalEdge(Node src, Node dst) {
        if (src == null) {
            return;
        }
        this.internalEdges.add(src);
        this.internalEdges.add(dst);
        if (this.hasBeenAdded) {
            this.pag.addEdge(src, dst);
        }
    }

    public void addInEdge(Node src, Node dst) {
        if (src == null) {
            return;
        }
        this.inEdges.add(src);
        this.inEdges.add(dst);
        if (this.hasBeenAdded) {
            this.pag.addEdge(src, dst);
        }
    }

    public void addOutEdge(Node src, Node dst) {
        if (src == null) {
            return;
        }
        this.outEdges.add(src);
        this.outEdges.add(dst);
        if (this.hasBeenAdded) {
            this.pag.addEdge(src, dst);
        }
    }

    public SootMethod getMethod() {
        return this.method;
    }

    public MethodNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public static MethodPAG v(PAG pag, SootMethod m3) {
        MethodPAG ret = G.v().MethodPAG_methodToPag.get(m3);
        if (ret == null) {
            ret = new MethodPAG(pag, m3);
            G.v().MethodPAG_methodToPag.put(m3, ret);
        }
        return ret;
    }

    public void build() {
        if (this.hasBeenBuilt) {
            return;
        }
        this.hasBeenBuilt = true;
        if (this.method.isNative()) {
            if (this.pag().getOpts().simulate_natives()) {
                this.buildNative();
            }
        } else if (this.method.isConcrete() && !this.method.isPhantom()) {
            this.buildNormal();
        }
        this.addMiscEdges();
    }

    protected VarNode parameterize(LocalVarNode vn, Context varNodeParameter) {
        SootMethod m3 = vn.getMethod();
        if (m3 != this.method && m3 != null) {
            throw new RuntimeException("VarNode " + vn + " with method " + m3 + " parameterized in method " + this.method);
        }
        return this.pag().makeContextVarNode(vn, varNodeParameter);
    }

    protected FieldRefNode parameterize(FieldRefNode frn, Context varNodeParameter) {
        return this.pag().makeFieldRefNode((VarNode)this.parameterize(frn.getBase(), varNodeParameter), frn.getField());
    }

    public Node parameterize(Node n, Context varNodeParameter) {
        if (varNodeParameter == null) {
            return n;
        }
        if (n instanceof LocalVarNode) {
            return this.parameterize((LocalVarNode)n, varNodeParameter);
        }
        if (n instanceof FieldRefNode) {
            return this.parameterize((FieldRefNode)n, varNodeParameter);
        }
        return n;
    }

    protected void buildNormal() {
        Body b = this.method.retrieveActiveBody();
        for (Unit u : b.getUnits()) {
            this.nodeFactory.handleStmt((Stmt)u);
        }
    }

    protected void buildNative() {
        ValNode thisNode = null;
        ValNode retNode = null;
        if (!this.method.isStatic()) {
            thisNode = (ValNode)this.nodeFactory.caseThis();
        }
        if (this.method.getReturnType() instanceof RefLikeType) {
            retNode = (ValNode)this.nodeFactory.caseRet();
            if (this.pag.getCGOpts().library() != 1) {
                Type retType = this.method.getReturnType();
                retType.apply(new SparkLibraryHelper(this.pag, retNode, this.method));
            }
        }
        ReferenceVariable[] args = new ValNode[this.method.getParameterCount()];
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            if (!(this.method.getParameterType(i) instanceof RefLikeType)) continue;
            args[i] = (ValNode)this.nodeFactory.caseParm(i);
        }
        this.pag.nativeMethodDriver.process(this.method, thisNode, retNode, args);
    }

    protected void addMiscEdges() {
        block22: {
            String signature = this.method.getSignature();
            if (this.method.getSubSignature().equals(mainSubSignature)) {
                this.addInEdge(this.pag().nodeFactory().caseArgv(), this.nodeFactory.caseParm(0));
            } else if (signature.equals("<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>")) {
                this.addInEdge(this.pag().nodeFactory().caseMainThread(), this.nodeFactory.caseThis());
                this.addInEdge(this.pag().nodeFactory().caseMainThreadGroup(), this.nodeFactory.caseParm(0));
            } else if (signature.equals("<java.lang.ref.Finalizer: void <init>(java.lang.Object)>")) {
                this.addInEdge(this.nodeFactory.caseThis(), this.pag().nodeFactory().caseFinalizeQueue());
            } else if (signature.equals("<java.lang.ref.Finalizer: void runFinalizer()>")) {
                this.addInEdge(this.pag.nodeFactory().caseFinalizeQueue(), this.nodeFactory.caseThis());
            } else if (signature.equals("<java.lang.ref.Finalizer: void access$100(java.lang.Object)>")) {
                this.addInEdge(this.pag.nodeFactory().caseFinalizeQueue(), this.nodeFactory.caseParm(0));
            } else if (signature.equals("<java.lang.ClassLoader: void <init>()>")) {
                this.addInEdge(this.pag.nodeFactory().caseDefaultClassLoader(), this.nodeFactory.caseThis());
            } else if (signature.equals("<java.lang.Thread: void exit()>")) {
                this.addInEdge(this.pag.nodeFactory().caseMainThread(), this.nodeFactory.caseThis());
            } else if (signature.equals("<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>")) {
                this.addInEdge(this.pag.nodeFactory().caseThrow(), this.nodeFactory.caseParm(0));
                this.addInEdge(this.pag.nodeFactory().casePrivilegedActionException(), this.nodeFactory.caseThis());
            }
            if (this.method.getNumberedSubSignature().equals(this.sigCanonicalize)) {
                for (SootClass cl = this.method.getDeclaringClass(); cl != null; cl = cl.getSuperclassUnsafe()) {
                    if (!cl.equals(Scene.v().getSootClass("java.io.FileSystem"))) continue;
                    this.addInEdge(this.pag.nodeFactory().caseCanonicalPath(), this.nodeFactory.caseRet());
                }
            }
            boolean isImplicit = false;
            for (SootMethod implicitMethod : EntryPoints.v().implicit()) {
                if (!implicitMethod.getNumberedSubSignature().equals(this.method.getNumberedSubSignature())) continue;
                isImplicit = true;
                break;
            }
            if (isImplicit) {
                SootClass c = this.method.getDeclaringClass();
                while (!c.getName().equals("java.lang.ClassLoader")) {
                    if (c.hasSuperclass()) {
                        c = c.getSuperclass();
                        continue;
                    }
                    break block22;
                }
                if (!this.method.getName().equals("<init>")) {
                    this.addInEdge(this.pag().nodeFactory().caseDefaultClassLoader(), this.nodeFactory.caseThis());
                    this.addInEdge(this.pag().nodeFactory().caseMainClassNameString(), this.nodeFactory.caseParm(0));
                }
            }
        }
    }
}

