/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.internal.ClientAccessibilityOracle;
import soot.jimple.spark.internal.SparkLibraryHelper;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.NewInstanceNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.Parm;
import soot.jimple.spark.pag.VarNode;
import soot.shimple.AbstractShimpleValueSwitch;
import soot.shimple.PhiExpr;
import soot.toolkits.scalar.Pair;

public class MethodNodeFactory
extends AbstractShimpleValueSwitch {
    protected final RefType rtClass;
    protected final RefType rtStringType;
    protected final RefType rtHashSet;
    protected final RefType rtHashMap;
    protected final RefType rtLinkedList;
    protected final RefType rtHashtableEmptyIterator;
    protected final RefType rtHashtableEmptyEnumerator;
    protected final PAG pag;
    protected final MethodPAG mpag;
    protected SootMethod method;
    protected ClientAccessibilityOracle accessibilityOracle = Scene.v().getClientAccessibilityOracle();

    public MethodNodeFactory(PAG pag, MethodPAG mpag) {
        this.pag = pag;
        this.mpag = mpag;
        this.rtClass = RefType.v("java.lang.Class");
        this.rtStringType = RefType.v("java.lang.String");
        this.rtHashSet = RefType.v("java.util.HashSet");
        this.rtHashMap = RefType.v("java.util.HashMap");
        this.rtLinkedList = RefType.v("java.util.LinkedList");
        this.rtHashtableEmptyIterator = RefType.v("java.util.Hashtable$EmptyIterator");
        this.rtHashtableEmptyEnumerator = RefType.v("java.util.Hashtable$EmptyEnumerator");
        this.setCurrentMethod(mpag.getMethod());
    }

    private void setCurrentMethod(SootMethod m3) {
        this.method = m3;
        if (!m3.isStatic()) {
            SootClass c = m3.getDeclaringClass();
            if (c == null) {
                throw new RuntimeException("Method " + m3 + " has no declaring class");
            }
            this.caseThis();
        }
        for (int i = 0; i < m3.getParameterCount(); ++i) {
            if (!(m3.getParameterType(i) instanceof RefLikeType)) continue;
            this.caseParm(i);
        }
        Type retType = m3.getReturnType();
        if (retType instanceof RefLikeType) {
            this.caseRet();
        }
    }

    public Node getNode(Value v) {
        v.apply(this);
        return this.getNode();
    }

    public final void handleStmt(Stmt s2) {
        if (s2.containsInvokeExpr()) {
            if (!this.pag.getCGOpts().types_for_invoke()) {
                return;
            }
            InvokeExpr iexpr = s2.getInvokeExpr();
            if (iexpr instanceof VirtualInvokeExpr ? !this.isReflectionNewInstance(iexpr) : !(iexpr instanceof StaticInvokeExpr)) {
                return;
            }
        }
        s2.apply(new AbstractStmtSwitch(){

            @Override
            public final void caseAssignStmt(AssignStmt as) {
                Value l = as.getLeftOp();
                Value r = as.getRightOp();
                if (!(l.getType() instanceof RefLikeType)) {
                    return;
                }
                assert (r.getType() instanceof RefLikeType) : "Type mismatch in assignment " + as + " in method " + MethodNodeFactory.this.method.getSignature();
                l.apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                r.apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                if (l instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)l).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                }
                if (r instanceof InstanceFieldRef) {
                    ((InstanceFieldRef)r).getBase().apply(MethodNodeFactory.this);
                    MethodNodeFactory.this.pag.addDereference((VarNode)MethodNodeFactory.this.getNode());
                } else if (r instanceof StaticFieldRef) {
                    StaticFieldRef sfr = (StaticFieldRef)r;
                    SootFieldRef s2 = sfr.getFieldRef();
                    if (MethodNodeFactory.this.pag.getOpts().empties_as_allocs()) {
                        if (s2.declaringClass().getName().equals("java.util.Collections")) {
                            if (s2.name().equals("EMPTY_SET")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(MethodNodeFactory.this.rtHashSet, MethodNodeFactory.this.rtHashSet, MethodNodeFactory.this.method);
                            } else if (s2.name().equals("EMPTY_MAP")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(MethodNodeFactory.this.rtHashMap, MethodNodeFactory.this.rtHashMap, MethodNodeFactory.this.method);
                            } else if (s2.name().equals("EMPTY_LIST")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(MethodNodeFactory.this.rtLinkedList, MethodNodeFactory.this.rtLinkedList, MethodNodeFactory.this.method);
                            }
                        } else if (s2.declaringClass().getName().equals("java.util.Hashtable")) {
                            if (s2.name().equals("emptyIterator")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(MethodNodeFactory.this.rtHashtableEmptyIterator, MethodNodeFactory.this.rtHashtableEmptyIterator, MethodNodeFactory.this.method);
                            } else if (s2.name().equals("emptyEnumerator")) {
                                src = MethodNodeFactory.this.pag.makeAllocNode(MethodNodeFactory.this.rtHashtableEmptyEnumerator, MethodNodeFactory.this.rtHashtableEmptyEnumerator, MethodNodeFactory.this.method);
                            }
                        }
                    }
                }
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            @Override
            public final void caseReturnStmt(ReturnStmt rs) {
                if (!(rs.getOp().getType() instanceof RefLikeType)) {
                    return;
                }
                rs.getOp().apply(MethodNodeFactory.this);
                Node retNode = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(retNode, MethodNodeFactory.this.caseRet());
            }

            @Override
            public final void caseIdentityStmt(IdentityStmt is) {
                if (!(is.getLeftOp().getType() instanceof RefLikeType)) {
                    return;
                }
                Value leftOp = is.getLeftOp();
                Value rightOp = is.getRightOp();
                leftOp.apply(MethodNodeFactory.this);
                Node dest = MethodNodeFactory.this.getNode();
                rightOp.apply(MethodNodeFactory.this);
                Node src = MethodNodeFactory.this.getNode();
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
                int libOption = MethodNodeFactory.this.pag.getCGOpts().library();
                if (libOption != 1 && MethodNodeFactory.this.accessibilityOracle.isAccessible(MethodNodeFactory.this.method) && rightOp instanceof IdentityRef) {
                    Type rt = rightOp.getType();
                    rt.apply(new SparkLibraryHelper(MethodNodeFactory.this.pag, src, MethodNodeFactory.this.method));
                }
            }

            @Override
            public final void caseThrowStmt(ThrowStmt ts) {
                ts.getOp().apply(MethodNodeFactory.this);
                MethodNodeFactory.this.mpag.addOutEdge(MethodNodeFactory.this.getNode(), MethodNodeFactory.this.pag.nodeFactory().caseThrow());
            }
        });
    }

    private boolean isReflectionNewInstance(InvokeExpr iexpr) {
        RefType rt;
        VirtualInvokeExpr vie;
        return iexpr instanceof VirtualInvokeExpr && (vie = (VirtualInvokeExpr)iexpr).getBase().getType() instanceof RefType && (rt = (RefType)vie.getBase().getType()).getSootClass().getName().equals("java.lang.Class") && vie.getMethodRef().name().equals("newInstance") && vie.getMethodRef().parameterTypes().size() == 0;
    }

    public final Node getNode() {
        return (Node)this.getResult();
    }

    public final Node caseThis() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair<SootMethod, String>(this.method, "THIS_NODE"), this.method.getDeclaringClass().getType(), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public final Node caseParm(int index) {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Pair<SootMethod, Integer>(this.method, new Integer(index)), this.method.getParameterType(index), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    @Override
    public final void casePhiExpr(PhiExpr e) {
        Pair<PhiExpr, String> phiPair = new Pair<PhiExpr, String>(e, "PHI_NODE");
        LocalVarNode phiNode = this.pag.makeLocalVarNode(phiPair, e.getType(), this.method);
        for (Value op : e.getValues()) {
            op.apply(this);
            Node opNode = this.getNode();
            this.mpag.addInternalEdge(opNode, phiNode);
        }
        this.setResult(phiNode);
    }

    public final Node caseRet() {
        LocalVarNode ret = this.pag.makeLocalVarNode(Parm.v(this.method, -2), this.method.getReturnType(), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public final Node caseArray(VarNode base) {
        return this.pag.makeFieldRefNode(base, ArrayElement.v());
    }

    @Override
    public final void caseArrayRef(ArrayRef ar) {
        this.caseLocal((Local)ar.getBase());
        this.setResult(this.caseArray((VarNode)this.getNode()));
    }

    @Override
    public final void caseCastExpr(CastExpr ce) {
        Pair<CastExpr, String> castPair = new Pair<CastExpr, String>(ce, "CAST_NODE");
        ce.getOp().apply(this);
        Node opNode = this.getNode();
        LocalVarNode castNode = this.pag.makeLocalVarNode(castPair, ce.getCastType(), this.method);
        this.mpag.addInternalEdge(opNode, castNode);
        this.setResult(castNode);
    }

    @Override
    public final void caseCaughtExceptionRef(CaughtExceptionRef cer) {
        this.setResult(this.pag.nodeFactory().caseThrow());
    }

    @Override
    public final void caseInstanceFieldRef(InstanceFieldRef ifr) {
        if (this.pag.getOpts().field_based() || this.pag.getOpts().vta()) {
            this.setResult(this.pag.makeGlobalVarNode(ifr.getField(), ifr.getField().getType()));
        } else {
            this.setResult(this.pag.makeLocalFieldRefNode(ifr.getBase(), ifr.getBase().getType(), ifr.getField(), this.method));
        }
    }

    @Override
    public final void caseLocal(Local l) {
        this.setResult(this.pag.makeLocalVarNode(l, l.getType(), this.method));
    }

    @Override
    public final void caseNewArrayExpr(NewArrayExpr nae) {
        this.setResult(this.pag.makeAllocNode(nae, nae.getType(), this.method));
    }

    private boolean isStringBuffer(Type t) {
        if (!(t instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)t;
        String s2 = rt.toString();
        if (s2.equals("java.lang.StringBuffer")) {
            return true;
        }
        return s2.equals("java.lang.StringBuilder");
    }

    @Override
    public final void caseNewExpr(NewExpr ne) {
        if (this.pag.getOpts().merge_stringbuffer() && this.isStringBuffer(ne.getType())) {
            this.setResult(this.pag.makeAllocNode(ne.getType(), ne.getType(), null));
        } else {
            this.setResult(this.pag.makeAllocNode(ne, ne.getType(), this.method));
        }
    }

    @Override
    public final void caseNewMultiArrayExpr(NewMultiArrayExpr nmae) {
        Type t;
        ArrayType type = (ArrayType)nmae.getType();
        AllocNode prevAn = this.pag.makeAllocNode(new Pair<NewMultiArrayExpr, Integer>(nmae, new Integer(type.numDimensions)), type, this.method);
        LocalVarNode prevVn = this.pag.makeLocalVarNode(prevAn, prevAn.getType(), this.method);
        this.mpag.addInternalEdge(prevAn, prevVn);
        this.setResult(prevAn);
        while ((t = type.getElementType()) instanceof ArrayType) {
            type = (ArrayType)t;
            AllocNode an = this.pag.makeAllocNode(new Pair<NewMultiArrayExpr, Integer>(nmae, new Integer(type.numDimensions)), type, this.method);
            LocalVarNode vn = this.pag.makeLocalVarNode(an, an.getType(), this.method);
            this.mpag.addInternalEdge(an, vn);
            this.mpag.addInternalEdge(vn, this.pag.makeFieldRefNode(prevVn, ArrayElement.v()));
            prevAn = an;
            prevVn = vn;
        }
    }

    @Override
    public final void caseParameterRef(ParameterRef pr) {
        this.setResult(this.caseParm(pr.getIndex()));
    }

    @Override
    public final void caseStaticFieldRef(StaticFieldRef sfr) {
        this.setResult(this.pag.makeGlobalVarNode(sfr.getField(), sfr.getField().getType()));
    }

    @Override
    public final void caseStringConstant(StringConstant sc) {
        AllocNode stringConstant = this.pag.getOpts().string_constants() || Scene.v().containsClass(sc.value) || sc.value.length() > 0 && sc.value.charAt(0) == '[' ? this.pag.makeStringConstantNode(sc.value) : this.pag.makeAllocNode("STRING_NODE", this.rtStringType, null);
        GlobalVarNode stringConstantLocal = this.pag.makeGlobalVarNode(stringConstant, this.rtStringType);
        this.pag.addEdge(stringConstant, stringConstantLocal);
        this.setResult(stringConstantLocal);
    }

    @Override
    public final void caseThisRef(ThisRef tr) {
        this.setResult(this.caseThis());
    }

    @Override
    public final void caseNullConstant(NullConstant nr) {
        this.setResult(null);
    }

    @Override
    public final void caseClassConstant(ClassConstant cc) {
        AllocNode classConstant = this.pag.makeClassConstantNode(cc);
        GlobalVarNode classConstantLocal = this.pag.makeGlobalVarNode(classConstant, this.rtClass);
        this.pag.addEdge(classConstant, classConstantLocal);
        this.setResult(classConstantLocal);
    }

    @Override
    public final void defaultCase(Object v) {
        throw new RuntimeException("failed to handle " + v);
    }

    @Override
    public void caseStaticInvokeExpr(StaticInvokeExpr v) {
        SootMethodRef ref = v.getMethodRef();
        if (v.getArgCount() == 1 && v.getArg(0) instanceof StringConstant && ref.name().equals("forName") && ref.declaringClass().getName().equals("java.lang.Class") && ref.parameterTypes().size() == 1) {
            StringConstant classNameConst = (StringConstant)v.getArg(0);
            this.caseClassConstant(ClassConstant.v("L" + classNameConst.value.replaceAll("\\.", "/") + ";"));
        }
    }

    @Override
    public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
        if (!this.isReflectionNewInstance(v)) {
            throw new RuntimeException("Unhandled case of VirtualInvokeExpr");
        }
        NewInstanceNode newInstanceNode = this.pag.makeNewInstanceNode(v, Scene.v().getObjectType(), this.method);
        v.getBase().apply(this);
        Node srcNode = this.getNode();
        this.mpag.addInternalEdge(srcNode, newInstanceNode);
        this.setResult(newInstanceNode);
    }
}

